/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.time;

import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class Time
implements Serializable {
    private static final long serialVersionUID = -350254188460915999L;
    private final TimeUnit unit;
    private final long size;

    private Time(long size, TimeUnit unit) {
        this.unit = Preconditions.checkNotNull(unit, "time unit may not be null");
        this.size = size;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public long getSize() {
        return this.size;
    }

    public long toMilliseconds() {
        return this.unit.toMillis(this.size);
    }

    public String toString() {
        return this.toMilliseconds() + " ms";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Time time = (Time)o;
        return this.toMilliseconds() == time.toMilliseconds();
    }

    public int hashCode() {
        return Objects.hash(this.toMilliseconds());
    }

    public static Time of(long size, TimeUnit unit) {
        return new Time(size, unit);
    }

    public static Time milliseconds(long milliseconds) {
        return Time.of(milliseconds, TimeUnit.MILLISECONDS);
    }

    public static Time seconds(long seconds) {
        return Time.of(seconds, TimeUnit.SECONDS);
    }

    public static Time minutes(long minutes) {
        return Time.of(minutes, TimeUnit.MINUTES);
    }

    public static Time hours(long hours) {
        return Time.of(hours, TimeUnit.HOURS);
    }

    public static Time days(long days) {
        return Time.of(days, TimeUnit.DAYS);
    }
}

