/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.util;

import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.operators.util.BitSet;
import org.apache.flink.util.Preconditions;

public class BloomFilter {
    protected BitSet bitSet;
    protected int expectedEntries;
    protected int numHashFunctions;

    public BloomFilter(int expectedEntries, int byteSize) {
        Preconditions.checkArgument((expectedEntries > 0 ? 1 : 0) != 0, (Object)"expectedEntries should be > 0");
        this.expectedEntries = expectedEntries;
        this.numHashFunctions = BloomFilter.optimalNumOfHashFunctions(expectedEntries, byteSize << 3);
        this.bitSet = new BitSet(byteSize);
    }

    public void setBitsLocation(MemorySegment memorySegment, int offset) {
        this.bitSet.setMemorySegment(memorySegment, offset);
    }

    public static int optimalNumOfBits(long inputEntries, double fpp) {
        int numBits = (int)((double)(-inputEntries) * Math.log(fpp) / (Math.log(2.0) * Math.log(2.0)));
        return numBits;
    }

    public static double estimateFalsePositiveProbability(long inputEntries, int bitSize) {
        int numFunction = BloomFilter.optimalNumOfHashFunctions(inputEntries, bitSize);
        double p = Math.pow(Math.E, -((double)numFunction) * (double)inputEntries / (double)bitSize);
        double estimatedFPP = Math.pow(1.0 - p, numFunction);
        return estimatedFPP;
    }

    static int optimalNumOfHashFunctions(long expectEntries, long bitSize) {
        return Math.max(1, (int)Math.round((double)bitSize / (double)expectEntries * Math.log(2.0)));
    }

    public void addHash(int hash32) {
        int hash1 = hash32;
        int hash2 = hash32 >>> 16;
        for (int i = 1; i <= this.numHashFunctions; ++i) {
            int combinedHash = hash1 + i * hash2;
            if (combinedHash < 0) {
                combinedHash ^= 0xFFFFFFFF;
            }
            int pos = combinedHash % this.bitSet.bitSize();
            this.bitSet.set(pos);
        }
    }

    public boolean testHash(int hash32) {
        int hash1 = hash32;
        int hash2 = hash32 >>> 16;
        for (int i = 1; i <= this.numHashFunctions; ++i) {
            int pos;
            int combinedHash = hash1 + i * hash2;
            if (combinedHash < 0) {
                combinedHash ^= 0xFFFFFFFF;
            }
            if (this.bitSet.get(pos = combinedHash % this.bitSet.bitSize())) continue;
            return false;
        }
        return true;
    }

    public void reset() {
        this.bitSet.clear();
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        output.append("BloomFilter:\n");
        output.append("\thash function number:").append(this.numHashFunctions).append("\n");
        output.append(this.bitSet);
        return output.toString();
    }
}

