/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adapter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.runtime.executiongraph.ExecutionEdge;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.runtime.executiongraph.failover.flip1.PipelinedRegionComputeUtil;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.scheduler.adapter.DefaultExecutionVertex;
import org.apache.flink.runtime.scheduler.adapter.DefaultResultPartition;
import org.apache.flink.runtime.scheduler.adapter.DefaultSchedulingPipelinedRegion;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.ResultPartitionState;
import org.apache.flink.runtime.scheduler.strategy.SchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.SchedulingTopology;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExecutionTopology
implements SchedulingTopology {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultExecutionTopology.class);
    private final boolean containsCoLocationConstraints;
    private final Map<ExecutionVertexID, DefaultExecutionVertex> executionVerticesById;
    private final List<DefaultExecutionVertex> executionVerticesList;
    private final Map<IntermediateResultPartitionID, DefaultResultPartition> resultPartitionsById;
    private final Map<ExecutionVertexID, DefaultSchedulingPipelinedRegion> pipelinedRegionsByVertex;
    private final List<DefaultSchedulingPipelinedRegion> pipelinedRegions;

    public DefaultExecutionTopology(ExecutionGraph graph) {
        Preconditions.checkNotNull((Object)graph, (String)"execution graph can not be null");
        this.containsCoLocationConstraints = graph.getAllVertices().values().stream().map(ExecutionJobVertex::getCoLocationGroup).anyMatch(Objects::nonNull);
        this.executionVerticesById = new HashMap<ExecutionVertexID, DefaultExecutionVertex>();
        this.executionVerticesList = new ArrayList<DefaultExecutionVertex>(graph.getTotalNumberOfVertices());
        HashMap<IntermediateResultPartitionID, DefaultResultPartition> tmpResultPartitionsById = new HashMap<IntermediateResultPartitionID, DefaultResultPartition>();
        HashMap<ExecutionVertex, DefaultExecutionVertex> executionVertexMap = new HashMap<ExecutionVertex, DefaultExecutionVertex>();
        for (ExecutionVertex vertex : graph.getAllExecutionVertices()) {
            List<DefaultResultPartition> producedPartitions = DefaultExecutionTopology.generateProducedSchedulingResultPartition(vertex.getProducedPartitions());
            producedPartitions.forEach(partition -> tmpResultPartitionsById.put(partition.getId(), (DefaultResultPartition)partition));
            DefaultExecutionVertex schedulingVertex = DefaultExecutionTopology.generateSchedulingExecutionVertex(vertex, producedPartitions);
            this.executionVerticesById.put(schedulingVertex.getId(), schedulingVertex);
            this.executionVerticesList.add(schedulingVertex);
            executionVertexMap.put(vertex, schedulingVertex);
        }
        this.resultPartitionsById = tmpResultPartitionsById;
        DefaultExecutionTopology.connectVerticesToConsumedPartitions(executionVertexMap, tmpResultPartitionsById);
        this.pipelinedRegionsByVertex = new HashMap<ExecutionVertexID, DefaultSchedulingPipelinedRegion>();
        this.pipelinedRegions = new ArrayList<DefaultSchedulingPipelinedRegion>();
        this.initializePipelinedRegions();
    }

    private void initializePipelinedRegions() {
        long buildRegionsStartTime = System.nanoTime();
        Set<Set<SchedulingExecutionVertex>> rawPipelinedRegions = PipelinedRegionComputeUtil.computePipelinedRegions(this);
        for (Set<SchedulingExecutionVertex> rawPipelinedRegion : rawPipelinedRegions) {
            DefaultSchedulingPipelinedRegion pipelinedRegion = new DefaultSchedulingPipelinedRegion(rawPipelinedRegion);
            this.pipelinedRegions.add(pipelinedRegion);
            for (SchedulingExecutionVertex executionVertex : rawPipelinedRegion) {
                this.pipelinedRegionsByVertex.put((ExecutionVertexID)executionVertex.getId(), pipelinedRegion);
            }
        }
        long buildRegionsDuration = (System.nanoTime() - buildRegionsStartTime) / 1000000L;
        LOG.info("Built {} pipelined regions in {} ms", (Object)this.pipelinedRegions.size(), (Object)buildRegionsDuration);
    }

    @Override
    public Iterable<DefaultExecutionVertex> getVertices() {
        return this.executionVerticesList;
    }

    @Override
    public boolean containsCoLocationConstraints() {
        return this.containsCoLocationConstraints;
    }

    @Override
    public DefaultExecutionVertex getVertex(ExecutionVertexID executionVertexId) {
        DefaultExecutionVertex executionVertex = this.executionVerticesById.get(executionVertexId);
        if (executionVertex == null) {
            throw new IllegalArgumentException("can not find vertex: " + executionVertexId);
        }
        return executionVertex;
    }

    @Override
    public DefaultResultPartition getResultPartition(IntermediateResultPartitionID intermediateResultPartitionId) {
        DefaultResultPartition resultPartition = this.resultPartitionsById.get(intermediateResultPartitionId);
        if (resultPartition == null) {
            throw new IllegalArgumentException("can not find partition: " + intermediateResultPartitionId);
        }
        return resultPartition;
    }

    @Override
    public Iterable<DefaultSchedulingPipelinedRegion> getAllPipelinedRegions() {
        return Collections.unmodifiableCollection(this.pipelinedRegions);
    }

    @Override
    public DefaultSchedulingPipelinedRegion getPipelinedRegionOfVertex(ExecutionVertexID vertexId) {
        DefaultSchedulingPipelinedRegion pipelinedRegion = this.pipelinedRegionsByVertex.get(vertexId);
        if (pipelinedRegion == null) {
            throw new IllegalArgumentException("Unknown execution vertex " + vertexId);
        }
        return pipelinedRegion;
    }

    private static List<DefaultResultPartition> generateProducedSchedulingResultPartition(Map<IntermediateResultPartitionID, IntermediateResultPartition> producedIntermediatePartitions) {
        ArrayList<DefaultResultPartition> producedSchedulingPartitions = new ArrayList<DefaultResultPartition>(producedIntermediatePartitions.size());
        producedIntermediatePartitions.values().forEach(irp -> producedSchedulingPartitions.add(new DefaultResultPartition(irp.getPartitionId(), irp.getIntermediateResult().getId(), irp.getResultType(), () -> irp.isConsumable() ? ResultPartitionState.CONSUMABLE : ResultPartitionState.CREATED)));
        return producedSchedulingPartitions;
    }

    private static DefaultExecutionVertex generateSchedulingExecutionVertex(ExecutionVertex vertex, List<DefaultResultPartition> producedPartitions) {
        DefaultExecutionVertex schedulingVertex = new DefaultExecutionVertex(vertex.getID(), producedPartitions, () -> vertex.getExecutionState(), vertex.getInputDependencyConstraint());
        producedPartitions.forEach(partition -> partition.setProducer(schedulingVertex));
        return schedulingVertex;
    }

    private static void connectVerticesToConsumedPartitions(Map<ExecutionVertex, DefaultExecutionVertex> executionVertexMap, Map<IntermediateResultPartitionID, DefaultResultPartition> resultPartitions) {
        for (Map.Entry<ExecutionVertex, DefaultExecutionVertex> mapEntry : executionVertexMap.entrySet()) {
            DefaultExecutionVertex schedulingVertex = mapEntry.getValue();
            ExecutionVertex executionVertex = mapEntry.getKey();
            for (int index = 0; index < executionVertex.getNumberOfInputs(); ++index) {
                for (ExecutionEdge edge : executionVertex.getInputEdges(index)) {
                    DefaultResultPartition partition = resultPartitions.get(edge.getSource().getPartitionId());
                    schedulingVertex.addConsumedResult(partition);
                    partition.addConsumer(schedulingVertex);
                }
            }
        }
    }
}

