/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompositeTypeComparator;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;

@Internal
public class NullAwareComparator<T>
extends TypeComparator<T> {
    private static final long serialVersionUID = 1L;
    private final TypeComparator<T> wrappedComparator;
    private final boolean order;
    private final int flatFields;
    private boolean nullReference = false;

    public NullAwareComparator(TypeComparator<T> wrappedComparator, boolean order) {
        this.wrappedComparator = wrappedComparator;
        this.order = order;
        this.flatFields = wrappedComparator.getFlatComparators().length;
    }

    @Override
    public int hash(T record) {
        if (record != null) {
            return this.wrappedComparator.hash(record);
        }
        return 0;
    }

    @Override
    public void setReference(T toCompare) {
        if (toCompare == null) {
            this.nullReference = true;
        } else {
            this.nullReference = false;
            this.wrappedComparator.setReference(toCompare);
        }
    }

    @Override
    public boolean equalToReference(T candidate) {
        if (candidate == null && this.nullReference) {
            return true;
        }
        if (candidate == null || this.nullReference) {
            return false;
        }
        return this.wrappedComparator.equalToReference(candidate);
    }

    @Override
    public int compareToReference(TypeComparator<T> referencedComparator) {
        NullAwareComparator otherComparator = (NullAwareComparator)referencedComparator;
        boolean otherNullReference = otherComparator.nullReference;
        if (this.nullReference && otherNullReference) {
            return 0;
        }
        if (this.nullReference) {
            return this.order ? 1 : -1;
        }
        if (otherNullReference) {
            return this.order ? -1 : 1;
        }
        return this.wrappedComparator.compareToReference(otherComparator.wrappedComparator);
    }

    @Override
    public int compare(T first, T second) {
        if (first == null && second == null) {
            return 0;
        }
        if (first == null) {
            return this.order ? -1 : 1;
        }
        if (second == null) {
            return this.order ? 1 : -1;
        }
        return this.wrappedComparator.compare(first, second);
    }

    @Override
    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        throw new UnsupportedOperationException("Comparator does not support null-aware serialized comparision.");
    }

    @Override
    public boolean supportsNormalizedKey() {
        return this.wrappedComparator.supportsNormalizedKey();
    }

    @Override
    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    @Override
    public int getNormalizeKeyLen() {
        int len = this.wrappedComparator.getNormalizeKeyLen();
        if (len == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return len + 1;
    }

    @Override
    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return this.wrappedComparator.isNormalizedKeyPrefixOnly(keyBytes - 1);
    }

    @Override
    public void putNormalizedKey(T record, MemorySegment target, int offset, int numBytes) {
        if (numBytes > 0) {
            if (record == null) {
                target.putBoolean(offset, false);
                for (int j = 0; j < numBytes - 1; ++j) {
                    target.put(offset + 1 + j, (byte)0);
                }
            } else {
                target.putBoolean(offset, true);
                this.wrappedComparator.putNormalizedKey(record, target, offset + 1, numBytes - 1);
            }
        }
    }

    @Override
    public void writeWithKeyNormalization(T record, DataOutputView target) throws IOException {
        throw new UnsupportedOperationException("Record serialization with leading normalized keys not supported.");
    }

    @Override
    public T readWithKeyDenormalization(T reuse, DataInputView source) throws IOException {
        throw new UnsupportedOperationException("Record deserialization with leading normalized keys not supported.");
    }

    @Override
    public boolean invertNormalizedKey() {
        return this.wrappedComparator.invertNormalizedKey();
    }

    @Override
    public TypeComparator<T> duplicate() {
        return new NullAwareComparator<T>(this.wrappedComparator.duplicate(), this.order);
    }

    @Override
    public int extractKeys(Object record, Object[] target, int index) {
        if (record == null) {
            for (int i = 0; i < this.flatFields; ++i) {
                target[index + i] = null;
            }
            return this.flatFields;
        }
        return this.wrappedComparator.extractKeys(record, target, index);
    }

    @Override
    public TypeComparator[] getFlatComparators() {
        ArrayList<TypeComparator> flatComparators = new ArrayList<TypeComparator>();
        if (this.wrappedComparator instanceof CompositeTypeComparator) {
            ((CompositeTypeComparator)this.wrappedComparator).getFlatComparator(flatComparators);
        } else {
            flatComparators.add(this.wrappedComparator);
        }
        TypeComparator[] result = new TypeComparator[flatComparators.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new NullAwareComparator<T>((TypeComparator)flatComparators.get(i), this.order);
        }
        return result;
    }
}

