/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization;

import java.io.IOException;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.util.CloseableIterator;

public interface RecordDeserializer<T extends IOReadableWritable> {
    public DeserializationResult getNextRecord(T var1) throws IOException;

    public void setNextBuffer(Buffer var1) throws IOException;

    public Buffer getCurrentBuffer();

    public void clear();

    public boolean hasUnfinishedData();

    public CloseableIterator<Buffer> getUnconsumedBuffer() throws IOException;

    public static enum DeserializationResult {
        PARTIAL_RECORD(false, true),
        INTERMEDIATE_RECORD_FROM_BUFFER(true, false),
        LAST_RECORD_FROM_BUFFER(true, true);

        private final boolean isFullRecord;
        private final boolean isBufferConsumed;

        private DeserializationResult(boolean isFullRecord, boolean isBufferConsumed) {
            this.isFullRecord = isFullRecord;
            this.isBufferConsumed = isBufferConsumed;
        }

        public boolean isFullRecord() {
            return this.isFullRecord;
        }

        public boolean isBufferConsumed() {
            return this.isBufferConsumed;
        }
    }
}

