/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.taskmanager;

import java.util.Objects;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.instance.HardwareDescription;
import org.apache.flink.runtime.rest.messages.ResourceProfileInfo;
import org.apache.flink.runtime.rest.messages.json.ResourceIDDeserializer;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerInfo;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerMetricsInfo;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.util.Preconditions;

public class TaskManagerDetailsInfo
extends TaskManagerInfo {
    public static final String FIELD_NAME_METRICS = "metrics";
    @JsonProperty(value="metrics")
    private final TaskManagerMetricsInfo taskManagerMetrics;

    @JsonCreator
    public TaskManagerDetailsInfo(@JsonDeserialize(using=ResourceIDDeserializer.class) @JsonProperty(value="id") ResourceID resourceId, @JsonProperty(value="path") String address, @JsonProperty(value="dataPort") int dataPort, @JsonProperty(value="timeSinceLastHeartbeat") long lastHeartbeat, @JsonProperty(value="slotsNumber") int numberSlots, @JsonProperty(value="freeSlots") int numberAvailableSlots, @JsonProperty(value="totalResource") ResourceProfileInfo totalResource, @JsonProperty(value="freeResource") ResourceProfileInfo freeResource, @JsonProperty(value="hardware") HardwareDescription hardwareDescription, @JsonProperty(value="metrics") TaskManagerMetricsInfo taskManagerMetrics) {
        super(resourceId, address, dataPort, lastHeartbeat, numberSlots, numberAvailableSlots, totalResource, freeResource, hardwareDescription);
        this.taskManagerMetrics = (TaskManagerMetricsInfo)Preconditions.checkNotNull((Object)taskManagerMetrics);
    }

    public TaskManagerDetailsInfo(TaskManagerInfo taskManagerInfo, TaskManagerMetricsInfo taskManagerMetrics) {
        this(taskManagerInfo.getResourceId(), taskManagerInfo.getAddress(), taskManagerInfo.getDataPort(), taskManagerInfo.getLastHeartbeat(), taskManagerInfo.getNumberSlots(), taskManagerInfo.getNumberAvailableSlots(), taskManagerInfo.getTotalResource(), taskManagerInfo.getFreeResource(), taskManagerInfo.getHardwareDescription(), taskManagerMetrics);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TaskManagerDetailsInfo that = (TaskManagerDetailsInfo)o;
        return Objects.equals(this.taskManagerMetrics, that.taskManagerMetrics);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.taskManagerMetrics);
    }
}

