/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.api.common.resources.GPUResource;
import org.apache.flink.api.common.resources.Resource;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.util.Preconditions;

@Internal
public final class ResourceSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final ResourceSpec UNKNOWN;
    public static final ResourceSpec DEFAULT;
    public static final ResourceSpec ZERO;
    @Nullable
    private final Resource cpuCores;
    @Nullable
    private final MemorySize taskHeapMemory;
    @Nullable
    private final MemorySize taskOffHeapMemory;
    @Nullable
    private final MemorySize managedMemory;
    private final Map<String, Resource> extendedResources = new HashMap<String, Resource>(1);

    private ResourceSpec(Resource cpuCores, MemorySize taskHeapMemory, MemorySize taskOffHeapMemory, MemorySize managedMemory, Resource ... extendedResources) {
        Preconditions.checkNotNull(cpuCores);
        Preconditions.checkArgument(cpuCores instanceof CPUResource, "cpuCores must be CPUResource");
        this.cpuCores = cpuCores;
        this.taskHeapMemory = Preconditions.checkNotNull(taskHeapMemory);
        this.taskOffHeapMemory = Preconditions.checkNotNull(taskOffHeapMemory);
        this.managedMemory = Preconditions.checkNotNull(managedMemory);
        for (Resource resource : extendedResources) {
            if (resource == null) continue;
            this.extendedResources.put(resource.getName(), resource);
        }
    }

    private ResourceSpec() {
        this.cpuCores = null;
        this.taskHeapMemory = null;
        this.taskOffHeapMemory = null;
        this.managedMemory = null;
    }

    public ResourceSpec merge(ResourceSpec other) {
        Preconditions.checkNotNull(other, "Cannot merge with null resources");
        if (this.equals(UNKNOWN) || other.equals(UNKNOWN)) {
            return UNKNOWN;
        }
        ResourceSpec target = new ResourceSpec(this.cpuCores.merge(other.cpuCores), this.taskHeapMemory.add(other.taskHeapMemory), this.taskOffHeapMemory.add(other.taskOffHeapMemory), this.managedMemory.add(other.managedMemory), new Resource[0]);
        target.extendedResources.putAll(this.extendedResources);
        for (Resource resource : other.extendedResources.values()) {
            target.extendedResources.merge(resource.getName(), resource, (v1, v2) -> v1.merge((Resource)v2));
        }
        return target;
    }

    public ResourceSpec subtract(ResourceSpec other) {
        Preconditions.checkNotNull(other, "Cannot subtract null resources");
        if (this.equals(UNKNOWN) || other.equals(UNKNOWN)) {
            return UNKNOWN;
        }
        Preconditions.checkArgument(other.lessThanOrEqual(this), "Cannot subtract a larger ResourceSpec from this one.");
        ResourceSpec target = new ResourceSpec(this.cpuCores.subtract(other.cpuCores), this.taskHeapMemory.subtract(other.taskHeapMemory), this.taskOffHeapMemory.subtract(other.taskOffHeapMemory), this.managedMemory.subtract(other.managedMemory), new Resource[0]);
        target.extendedResources.putAll(this.extendedResources);
        for (Resource resource : other.extendedResources.values()) {
            target.extendedResources.merge(resource.getName(), resource, (v1, v2) -> {
                Resource subtracted = v1.subtract((Resource)v2);
                return subtracted.getValue().compareTo(BigDecimal.ZERO) == 0 ? null : subtracted;
            });
        }
        return target;
    }

    public Resource getCpuCores() {
        this.throwUnsupportedOperationExceptionIfUnknown();
        return this.cpuCores;
    }

    public MemorySize getTaskHeapMemory() {
        this.throwUnsupportedOperationExceptionIfUnknown();
        return this.taskHeapMemory;
    }

    public MemorySize getTaskOffHeapMemory() {
        this.throwUnsupportedOperationExceptionIfUnknown();
        return this.taskOffHeapMemory;
    }

    public MemorySize getManagedMemory() {
        this.throwUnsupportedOperationExceptionIfUnknown();
        return this.managedMemory;
    }

    public Resource getGPUResource() {
        this.throwUnsupportedOperationExceptionIfUnknown();
        return this.extendedResources.get("GPU");
    }

    public Map<String, Resource> getExtendedResources() {
        this.throwUnsupportedOperationExceptionIfUnknown();
        return this.extendedResources;
    }

    private void throwUnsupportedOperationExceptionIfUnknown() {
        if (this.equals(UNKNOWN)) {
            throw new UnsupportedOperationException();
        }
    }

    public boolean lessThanOrEqual(ResourceSpec other) {
        Preconditions.checkNotNull(other, "Cannot compare with null resources");
        if (this.equals(UNKNOWN) && other.equals(UNKNOWN)) {
            return true;
        }
        if (this.equals(UNKNOWN) || other.equals(UNKNOWN)) {
            throw new IllegalArgumentException("Cannot compare specified resources with UNKNOWN resources.");
        }
        int cmp1 = this.cpuCores.getValue().compareTo(other.getCpuCores().getValue());
        int cmp2 = this.taskHeapMemory.compareTo(other.taskHeapMemory);
        int cmp3 = this.taskOffHeapMemory.compareTo(other.taskOffHeapMemory);
        int cmp4 = this.managedMemory.compareTo(other.managedMemory);
        if (cmp1 <= 0 && cmp2 <= 0 && cmp3 <= 0 && cmp4 <= 0) {
            for (Resource resource : this.extendedResources.values()) {
                if (other.extendedResources.containsKey(resource.getName()) && other.extendedResources.get(resource.getName()).getValue().compareTo(resource.getValue()) >= 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == ResourceSpec.class) {
            ResourceSpec that = (ResourceSpec)obj;
            return Objects.equals(this.cpuCores, that.cpuCores) && Objects.equals(this.taskHeapMemory, that.taskHeapMemory) && Objects.equals(this.taskOffHeapMemory, that.taskOffHeapMemory) && Objects.equals(this.managedMemory, that.managedMemory) && Objects.equals(this.extendedResources, that.extendedResources);
        }
        return false;
    }

    public int hashCode() {
        int result = Objects.hashCode(this.cpuCores);
        result = 31 * result + Objects.hashCode(this.taskHeapMemory);
        result = 31 * result + Objects.hashCode(this.taskOffHeapMemory);
        result = 31 * result + Objects.hashCode(this.managedMemory);
        result = 31 * result + this.extendedResources.hashCode();
        return result;
    }

    public String toString() {
        if (this.equals(UNKNOWN)) {
            return "ResourceSpec{UNKNOWN}";
        }
        StringBuilder extResources = new StringBuilder(this.extendedResources.size() * 10);
        for (Map.Entry<String, Resource> resource : this.extendedResources.entrySet()) {
            extResources.append(", ").append(resource.getKey()).append('=').append(resource.getValue().getValue());
        }
        return "ResourceSpec{cpuCores=" + this.cpuCores.getValue() + ", taskHeapMemory=" + this.taskHeapMemory.toHumanReadableString() + ", taskOffHeapMemory=" + this.taskOffHeapMemory.toHumanReadableString() + ", managedMemory=" + this.managedMemory.toHumanReadableString() + extResources + '}';
    }

    private Object readResolve() {
        return this.equals(UNKNOWN) ? UNKNOWN : this;
    }

    public static Builder newBuilder(double cpuCores, int taskHeapMemoryMB) {
        return new Builder(new CPUResource(cpuCores), MemorySize.ofMebiBytes(taskHeapMemoryMB));
    }

    static {
        DEFAULT = UNKNOWN = new ResourceSpec();
        ZERO = ResourceSpec.newBuilder(0.0, 0).build();
    }

    public static class Builder {
        private Resource cpuCores;
        private MemorySize taskHeapMemory;
        private MemorySize taskOffHeapMemory = MemorySize.ZERO;
        private MemorySize managedMemory = MemorySize.ZERO;
        private GPUResource gpuResource;

        private Builder(CPUResource cpuCores, MemorySize taskHeapMemory) {
            this.cpuCores = cpuCores;
            this.taskHeapMemory = taskHeapMemory;
        }

        public Builder setCpuCores(double cpuCores) {
            this.cpuCores = new CPUResource(cpuCores);
            return this;
        }

        public Builder setTaskHeapMemory(MemorySize taskHeapMemory) {
            this.taskHeapMemory = taskHeapMemory;
            return this;
        }

        public Builder setTaskHeapMemoryMB(int taskHeapMemoryMB) {
            this.taskHeapMemory = MemorySize.ofMebiBytes(taskHeapMemoryMB);
            return this;
        }

        public Builder setTaskOffHeapMemory(MemorySize taskOffHeapMemory) {
            this.taskOffHeapMemory = taskOffHeapMemory;
            return this;
        }

        public Builder setOffTaskHeapMemoryMB(int taskOffHeapMemoryMB) {
            this.taskOffHeapMemory = MemorySize.ofMebiBytes(taskOffHeapMemoryMB);
            return this;
        }

        public Builder setManagedMemory(MemorySize managedMemory) {
            this.managedMemory = managedMemory;
            return this;
        }

        public Builder setManagedMemoryMB(int managedMemoryMB) {
            this.managedMemory = MemorySize.ofMebiBytes(managedMemoryMB);
            return this;
        }

        public Builder setGPUResource(double gpus) {
            this.gpuResource = new GPUResource(gpus);
            return this;
        }

        public ResourceSpec build() {
            return new ResourceSpec(this.cpuCores, this.taskHeapMemory, this.taskOffHeapMemory, this.managedMemory, new Resource[]{this.gpuResource});
        }
    }
}

