/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.flink.annotation.Public;
import org.apache.flink.api.common.accumulators.Accumulator;

@Public
public class Histogram
implements Accumulator<Integer, TreeMap<Integer, Integer>> {
    private static final long serialVersionUID = 1L;
    private TreeMap<Integer, Integer> treeMap = new TreeMap();

    @Override
    public void add(Integer value) {
        Integer current = this.treeMap.get(value);
        Integer newValue = (current != null ? current : 0) + 1;
        this.treeMap.put(value, newValue);
    }

    @Override
    public TreeMap<Integer, Integer> getLocalValue() {
        return this.treeMap;
    }

    @Override
    public void merge(Accumulator<Integer, TreeMap<Integer, Integer>> other) {
        for (Map.Entry<Integer, Integer> entryFromOther : other.getLocalValue().entrySet()) {
            Integer ownValue = this.treeMap.get(entryFromOther.getKey());
            if (ownValue == null) {
                this.treeMap.put(entryFromOther.getKey(), entryFromOther.getValue());
                continue;
            }
            this.treeMap.put(entryFromOther.getKey(), entryFromOther.getValue() + ownValue);
        }
    }

    @Override
    public void resetLocal() {
        this.treeMap.clear();
    }

    public String toString() {
        return this.treeMap.toString();
    }

    @Override
    public Accumulator<Integer, TreeMap<Integer, Integer>> clone() {
        Histogram result = new Histogram();
        result.treeMap = new TreeMap<Integer, Integer>((SortedMap<Integer, Integer>)this.treeMap);
        return result;
    }
}

