/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.connector.source.lib.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.api.connector.source.ReaderOutput;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.api.connector.source.lib.util.IteratorSourceSplit;
import org.apache.flink.core.io.InputStatus;
import org.apache.flink.util.Preconditions;

public class IteratorSourceReader<E, IterT extends Iterator<E>, SplitT extends IteratorSourceSplit<E, IterT>>
implements SourceReader<E, SplitT> {
    private final SourceReaderContext context;
    private final CompletableFuture<Void> availability;
    @Nullable
    private IterT iterator;
    @Nullable
    private SplitT currentSplit;
    @Nullable
    private Queue<SplitT> remainingSplits;

    public IteratorSourceReader(SourceReaderContext context) {
        this.context = Preconditions.checkNotNull(context);
        this.availability = new CompletableFuture();
    }

    @Override
    public void start() {
        if (this.iterator == null) {
            this.context.sendSplitRequest();
        }
    }

    @Override
    public InputStatus pollNext(ReaderOutput<E> output) {
        if (this.iterator != null && this.iterator.hasNext()) {
            output.collect(this.iterator.next());
            return InputStatus.MORE_AVAILABLE;
        }
        if (this.remainingSplits == null) {
            return InputStatus.NOTHING_AVAILABLE;
        }
        this.currentSplit = (IteratorSourceSplit)this.remainingSplits.poll();
        if (this.currentSplit != null) {
            this.iterator = this.currentSplit.getIterator();
            return this.pollNext(output);
        }
        return InputStatus.END_OF_INPUT;
    }

    @Override
    public CompletableFuture<Void> isAvailable() {
        return this.availability;
    }

    @Override
    public void addSplits(List<SplitT> splits) {
        Preconditions.checkState(this.remainingSplits == null, "Cannot accept more than one split assignment");
        this.remainingSplits = new ArrayDeque<SplitT>(splits);
        this.availability.complete(null);
    }

    @Override
    public void notifyNoMoreSplits() {
        Preconditions.checkState(this.remainingSplits == null, "Unexpected response, requested more than one split.");
        this.remainingSplits = new ArrayDeque<SplitT>();
    }

    @Override
    public List<SplitT> snapshotState(long checkpointId) {
        if (this.remainingSplits == null) {
            return Collections.emptyList();
        }
        ArrayList allSplits = new ArrayList(1 + this.remainingSplits.size());
        if (this.iterator != null && this.iterator.hasNext()) {
            IteratorSourceSplit inProgressSplit = this.currentSplit.getUpdatedSplitForIterator(this.iterator);
            allSplits.add(inProgressSplit);
        }
        allSplits.addAll(this.remainingSplits);
        return allSplits;
    }

    @Override
    public void close() throws Exception {
    }
}

