/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerUtil;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.java.typeutils.runtime.MaskUtils;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;

@Internal
public final class RowSerializer
extends TypeSerializer<Row> {
    public static final int ROW_KIND_OFFSET = 2;
    private static final long serialVersionUID = 1L;
    private final boolean legacyModeEnabled;
    private final int legacyOffset;
    private final TypeSerializer<Object>[] fieldSerializers;
    private final int arity;
    private transient boolean[] mask;

    public RowSerializer(TypeSerializer<?>[] fieldSerializers) {
        this(fieldSerializers, false);
    }

    public RowSerializer(TypeSerializer<?>[] fieldSerializers, boolean legacyModeEnabled) {
        this.legacyModeEnabled = legacyModeEnabled;
        this.legacyOffset = legacyModeEnabled ? 0 : 2;
        this.fieldSerializers = Preconditions.checkNotNull(fieldSerializers);
        this.arity = fieldSerializers.length;
        this.mask = new boolean[this.legacyOffset + fieldSerializers.length];
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public TypeSerializer<Row> duplicate() {
        TypeSerializer[] duplicateFieldSerializers = new TypeSerializer[this.fieldSerializers.length];
        for (int i = 0; i < this.fieldSerializers.length; ++i) {
            duplicateFieldSerializers[i] = this.fieldSerializers[i].duplicate();
        }
        return new RowSerializer(duplicateFieldSerializers, this.legacyModeEnabled);
    }

    @Override
    public Row createInstance() {
        return new Row(this.fieldSerializers.length);
    }

    @Override
    public Row copy(Row from) {
        int len = this.fieldSerializers.length;
        if (from.getArity() != len) {
            throw new RuntimeException("Row arity of from (" + from.getArity() + ") does not match this serializers field length (" + len + ").");
        }
        Row result = new Row(from.getKind(), len);
        for (int i = 0; i < len; ++i) {
            Object fromField = from.getField(i);
            if (fromField != null) {
                Object copy = this.fieldSerializers[i].copy(fromField);
                result.setField(i, copy);
                continue;
            }
            result.setField(i, null);
        }
        return result;
    }

    @Override
    public Row copy(Row from, Row reuse) {
        int len = this.fieldSerializers.length;
        if (reuse == null) {
            return this.copy(from);
        }
        if (from.getArity() != len || reuse.getArity() != len) {
            throw new RuntimeException("Row arity of reuse (" + reuse.getArity() + ") or from (" + from.getArity() + ") is incompatible with this serializers field length (" + len + ").");
        }
        reuse.setKind(from.getKind());
        for (int i = 0; i < len; ++i) {
            Object fromField = from.getField(i);
            if (fromField != null) {
                Object copy;
                Object reuseField = reuse.getField(i);
                if (reuseField != null) {
                    copy = this.fieldSerializers[i].copy(fromField, reuseField);
                    reuse.setField(i, copy);
                    continue;
                }
                copy = this.fieldSerializers[i].copy(fromField);
                reuse.setField(i, copy);
                continue;
            }
            reuse.setField(i, null);
        }
        return reuse;
    }

    @Override
    public int getLength() {
        return -1;
    }

    public int getArity() {
        return this.arity;
    }

    @Override
    public void serialize(Row record, DataOutputView target) throws IOException {
        int len = this.fieldSerializers.length;
        if (record.getArity() != len) {
            throw new RuntimeException("Row arity of record (" + record.getArity() + ") does not match this serializers field length (" + len + ").");
        }
        RowSerializer.fillMask(len, record, this.mask, this.legacyModeEnabled, this.legacyOffset);
        MaskUtils.writeMask(this.mask, target);
        for (int fieldPos = 0; fieldPos < len; ++fieldPos) {
            Object o = record.getField(fieldPos);
            if (o == null) continue;
            this.fieldSerializers[fieldPos].serialize(o, target);
        }
    }

    @Override
    public Row deserialize(DataInputView source) throws IOException {
        int len = this.fieldSerializers.length;
        MaskUtils.readIntoMask(source, this.mask);
        Row result = this.legacyModeEnabled ? new Row(len) : new Row(RowSerializer.readKindFromMask(this.mask), len);
        for (int fieldPos = 0; fieldPos < len; ++fieldPos) {
            if (this.mask[this.legacyOffset + fieldPos]) continue;
            result.setField(fieldPos, this.fieldSerializers[fieldPos].deserialize(source));
        }
        return result;
    }

    @Override
    public Row deserialize(Row reuse, DataInputView source) throws IOException {
        int len = this.fieldSerializers.length;
        if (reuse.getArity() != len) {
            throw new RuntimeException("Row arity of reuse (" + reuse.getArity() + ") does not match this serializers field length (" + len + ").");
        }
        MaskUtils.readIntoMask(source, this.mask);
        if (!this.legacyModeEnabled) {
            reuse.setKind(RowSerializer.readKindFromMask(this.mask));
        }
        for (int fieldPos = 0; fieldPos < len; ++fieldPos) {
            if (this.mask[this.legacyOffset + fieldPos]) {
                reuse.setField(fieldPos, null);
                continue;
            }
            Object reuseField = reuse.getField(fieldPos);
            if (reuseField != null) {
                reuse.setField(fieldPos, this.fieldSerializers[fieldPos].deserialize(reuseField, source));
                continue;
            }
            reuse.setField(fieldPos, this.fieldSerializers[fieldPos].deserialize(source));
        }
        return reuse;
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int len = this.fieldSerializers.length;
        MaskUtils.readIntoAndCopyMask(source, target, this.mask);
        for (int fieldPos = 0; fieldPos < len; ++fieldPos) {
            if (this.mask[this.legacyOffset + fieldPos]) continue;
            this.fieldSerializers[fieldPos].copy(source, target);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowSerializer that = (RowSerializer)o;
        return this.legacyModeEnabled == that.legacyModeEnabled && Arrays.equals(this.fieldSerializers, that.fieldSerializers);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(this.legacyModeEnabled);
        result = 31 * result + Arrays.hashCode(this.fieldSerializers);
        return result;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.mask = new boolean[this.legacyOffset + this.fieldSerializers.length];
    }

    private static void fillMask(int fieldLength, Row row, boolean[] mask, boolean legacyModeEnabled, int legacyOffset) {
        if (!legacyModeEnabled) {
            byte kind = row.getKind().toByteValue();
            mask[0] = (kind & 1) > 0;
            mask[1] = (kind & 2) > 0;
        }
        for (int fieldPos = 0; fieldPos < fieldLength; ++fieldPos) {
            mask[legacyOffset + fieldPos] = row.getField(fieldPos) == null;
        }
    }

    private static RowKind readKindFromMask(boolean[] mask) {
        byte kind = (byte)((mask[0] ? 1 : 0) + (mask[1] ? 2 : 0));
        return RowKind.fromByteValue(kind);
    }

    @Override
    public TypeSerializerSnapshot<Row> snapshotConfiguration() {
        return new RowSerializerSnapshot(this);
    }

    public static final class RowSerializerSnapshot
    extends CompositeTypeSerializerSnapshot<Row, RowSerializer> {
        private static final int VERSION = 3;
        private static final int LAST_VERSION_WITHOUT_ROW_KIND = 2;
        private int readVersion = 3;

        public RowSerializerSnapshot() {
            super(RowSerializer.class);
        }

        RowSerializerSnapshot(RowSerializer serializerInstance) {
            super(serializerInstance);
        }

        @Override
        protected int getCurrentOuterSnapshotVersion() {
            return 3;
        }

        @Override
        protected void readOuterSnapshot(int readOuterSnapshotVersion, DataInputView in, ClassLoader userCodeClassLoader) {
            this.readVersion = readOuterSnapshotVersion;
        }

        @Override
        protected CompositeTypeSerializerSnapshot.OuterSchemaCompatibility resolveOuterSchemaCompatibility(RowSerializer newSerializer) {
            if (this.readVersion <= 2) {
                return CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.COMPATIBLE_AFTER_MIGRATION;
            }
            return CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.COMPATIBLE_AS_IS;
        }

        @Override
        protected TypeSerializer<?>[] getNestedSerializers(RowSerializer outerSerializer) {
            return outerSerializer.fieldSerializers;
        }

        @Override
        protected RowSerializer createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
            return new RowSerializer(nestedSerializers, this.readVersion <= 2);
        }
    }

    @Deprecated
    public static final class RowSerializerConfigSnapshot
    extends CompositeTypeSerializerConfigSnapshot<Row> {
        private static final int VERSION = 1;

        public RowSerializerConfigSnapshot() {
        }

        public RowSerializerConfigSnapshot(TypeSerializer<?>[] fieldSerializers) {
            super(fieldSerializers);
        }

        @Override
        public int getVersion() {
            return 1;
        }

        @Override
        public TypeSerializerSchemaCompatibility<Row> resolveSchemaCompatibility(TypeSerializer<Row> newSerializer) {
            TypeSerializerSnapshot[] nestedSnapshots = (TypeSerializerSnapshot[])this.getNestedSerializersAndConfigs().stream().map(t -> (TypeSerializerSnapshot)t.f1).toArray(TypeSerializerSnapshot[]::new);
            return CompositeTypeSerializerUtil.delegateCompatibilityCheckToNewSnapshot(newSerializer, new RowSerializerSnapshot(), nestedSnapshots);
        }
    }
}

