/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.util.List;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class ExternalResourceOptions {
    public static final String EXTERNAL_RESOURCE_AMOUNT_SUFFIX = "amount";
    public static final String EXTERNAL_RESOURCE_DRIVER_FACTORY_SUFFIX = "driver-factory.class";
    public static final String EXTERNAL_RESOURCE_DRIVER_PARAM_SUFFIX = "param.";
    private static final String EXTERNAL_RESOURCE_DRIVER_PARAM_PATTERN_SUFFIX = "param.<param>";
    private static final String EXTERNAL_RESOURCE_PREFIX = "external-resource";
    public static final ConfigOption<List<String>> EXTERNAL_RESOURCE_LIST = ConfigOptions.key("external-resources").stringType().asList().defaultValues((String[])new String[0]).withDescription("List of the <resource_name> of all external resources with delimiter \";\", e.g. \"gpu;fpga\" for two external resource gpu and fpga. The <resource_name> will be used to splice related config options for external resource. Only the <resource_name> defined here will go into effect by external resource framework.");
    public static final ConfigOption<String> EXTERNAL_RESOURCE_DRIVER_FACTORY_CLASS = ConfigOptions.key(ExternalResourceOptions.genericKeyWithSuffix("driver-factory.class")).stringType().noDefaultValue().withDescription("Defines the factory class name for the external resource identified by <resource_name>. The factory will be used to instantiated the ExternalResourceDriver at the TaskExecutor side. For example, org.apache.flink.externalresource.gpu.GPUDriverFactory");
    public static final ConfigOption<Long> EXTERNAL_RESOURCE_AMOUNT = ConfigOptions.key(ExternalResourceOptions.genericKeyWithSuffix("amount")).longType().noDefaultValue().withDescription("The amount for the external resource specified by <resource_name> per TaskExecutor.");
    public static final ConfigOption<String> EXTERNAL_RESOURCE_DRIVER_PARAM = ConfigOptions.key(ExternalResourceOptions.genericKeyWithSuffix("param.<param>")).stringType().noDefaultValue().withDescription("The naming pattern of custom config options for the external resource specified by <resource_name>. Only the configurations that follow this pattern would be passed into the driver factory of that external resource.");

    public static String genericKeyWithSuffix(String suffix) {
        return ExternalResourceOptions.keyWithResourceNameAndSuffix("<resource_name>", suffix);
    }

    private static String keyWithResourceNameAndSuffix(String resourceName, String suffix) {
        return String.format("%s.%s.%s", EXTERNAL_RESOURCE_PREFIX, Preconditions.checkNotNull(resourceName), Preconditions.checkNotNull(suffix));
    }

    public static String getAmountConfigOptionForResource(String resourceName) {
        return ExternalResourceOptions.keyWithResourceNameAndSuffix(resourceName, EXTERNAL_RESOURCE_AMOUNT_SUFFIX);
    }

    public static String getSystemConfigKeyConfigOptionForResource(String resourceName, String suffix) {
        return ExternalResourceOptions.keyWithResourceNameAndSuffix(resourceName, suffix);
    }

    public static String getExternalResourceDriverFactoryConfigOptionForResource(String resourceName) {
        return ExternalResourceOptions.keyWithResourceNameAndSuffix(resourceName, EXTERNAL_RESOURCE_DRIVER_FACTORY_SUFFIX);
    }

    public static String getExternalResourceParamConfigPrefixForResource(String resourceName) {
        return ExternalResourceOptions.keyWithResourceNameAndSuffix(resourceName, EXTERNAL_RESOURCE_DRIVER_PARAM_SUFFIX);
    }
}

