/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.util.List;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.LineBreakElement;
import org.apache.flink.configuration.description.LinkElement;
import org.apache.flink.configuration.description.TextElement;

public class SecurityOptions {
    public static final ConfigOption<List<String>> SECURITY_CONTEXT_FACTORY_CLASSES = ConfigOptions.key("security.context.factory.classes").stringType().asList().defaultValues((String[])new String[]{"org.apache.flink.runtime.security.contexts.HadoopSecurityContextFactory", "org.apache.flink.runtime.security.contexts.NoOpSecurityContextFactory"}).withDescription("List of factories that should be used to instantiate a security context. If multiple are configured, Flink will use the first compatible factory. You should have a NoOpSecurityContextFactory in this list as a fallback.");
    public static final ConfigOption<List<String>> SECURITY_MODULE_FACTORY_CLASSES = ConfigOptions.key("security.module.factory.classes").stringType().asList().defaultValues((String[])new String[]{"org.apache.flink.runtime.security.modules.HadoopModuleFactory", "org.apache.flink.runtime.security.modules.JaasModuleFactory", "org.apache.flink.runtime.security.modules.ZookeeperModuleFactory"}).withDescription("List of factories that should be used to instantiate security modules. All listed modules will be installed. Keep in mind that the configured security context might rely on some modules being present.");
    @Documentation.Section(value={"security_auth_kerberos"})
    public static final ConfigOption<String> KERBEROS_LOGIN_PRINCIPAL = ConfigOptions.key("security.kerberos.login.principal").noDefaultValue().withDeprecatedKeys("security.principal").withDescription("Kerberos principal name associated with the keytab.");
    @Documentation.Section(value={"security_auth_kerberos"})
    public static final ConfigOption<String> KERBEROS_LOGIN_KEYTAB = ConfigOptions.key("security.kerberos.login.keytab").noDefaultValue().withDeprecatedKeys("security.keytab").withDescription("Absolute path to a Kerberos keytab file that contains the user credentials.");
    @Documentation.Section(value={"security_auth_kerberos"})
    public static final ConfigOption<Boolean> KERBEROS_LOGIN_USETICKETCACHE = ConfigOptions.key("security.kerberos.login.use-ticket-cache").defaultValue(true).withDescription("Indicates whether to read from your Kerberos ticket cache.");
    @Documentation.Section(value={"security_auth_kerberos"})
    public static final ConfigOption<String> KERBEROS_LOGIN_CONTEXTS = ConfigOptions.key("security.kerberos.login.contexts").noDefaultValue().withDescription("A comma-separated list of login contexts to provide the Kerberos credentials to (for example, `Client,KafkaClient` to use the credentials for ZooKeeper authentication and for Kafka authentication)");
    @Documentation.Section(value={"security_auth_zk"})
    public static final ConfigOption<Boolean> ZOOKEEPER_SASL_DISABLE = ConfigOptions.key("zookeeper.sasl.disable").defaultValue(false);
    @Documentation.Section(value={"security_auth_zk"})
    public static final ConfigOption<String> ZOOKEEPER_SASL_SERVICE_NAME = ConfigOptions.key("zookeeper.sasl.service-name").defaultValue("zookeeper");
    @Documentation.Section(value={"security_auth_zk"})
    public static final ConfigOption<String> ZOOKEEPER_SASL_LOGIN_CONTEXT_NAME = ConfigOptions.key("zookeeper.sasl.login-context-name").defaultValue("Client");
    @Deprecated
    public static final ConfigOption<Boolean> SSL_ENABLED = ConfigOptions.key("security.ssl.enabled").defaultValue(false).withDescription("Turns on SSL for internal and external network communication.This can be overridden by 'security.ssl.internal.enabled', 'security.ssl.external.enabled'. Specific internal components (rpc, data transport, blob server) may optionally override this through their own settings.");
    @Documentation.Section(value={"security_ssl"})
    public static final ConfigOption<Boolean> SSL_INTERNAL_ENABLED = ConfigOptions.key("security.ssl.internal.enabled").defaultValue(false).withDescription("Turns on SSL for internal network communication. Optionally, specific components may override this through their own settings (rpc, data transport, REST, etc).");
    @Documentation.Section(value={"security_ssl"})
    public static final ConfigOption<Boolean> SSL_REST_ENABLED = ConfigOptions.key("security.ssl.rest.enabled").defaultValue(false).withDescription("Turns on SSL for external communication via the REST endpoints.");
    @Documentation.Section(value={"security_ssl"})
    public static final ConfigOption<Boolean> SSL_REST_AUTHENTICATION_ENABLED = ConfigOptions.key("security.ssl.rest.authentication-enabled").defaultValue(false).withDescription("Turns on mutual SSL authentication for external communication via the REST endpoints.");
    @Documentation.ExcludeFromDocumentation(value="The SSL Setup encourages separate configs for internal and REST security.")
    public static final ConfigOption<String> SSL_KEYSTORE = ConfigOptions.key("security.ssl.keystore").noDefaultValue().withDescription("The Java keystore file to be used by the flink endpoint for its SSL Key and Certificate.");
    @Documentation.ExcludeFromDocumentation(value="The SSL Setup encourages separate configs for internal and REST security.")
    public static final ConfigOption<String> SSL_KEYSTORE_PASSWORD = ConfigOptions.key("security.ssl.keystore-password").noDefaultValue().withDescription("The secret to decrypt the keystore file.");
    @Documentation.ExcludeFromDocumentation(value="The SSL Setup encourages separate configs for internal and REST security.")
    public static final ConfigOption<String> SSL_KEY_PASSWORD = ConfigOptions.key("security.ssl.key-password").noDefaultValue().withDescription("The secret to decrypt the server key in the keystore.");
    @Documentation.ExcludeFromDocumentation(value="The SSL Setup encourages separate configs for internal and REST security.")
    public static final ConfigOption<String> SSL_TRUSTSTORE = ConfigOptions.key("security.ssl.truststore").noDefaultValue().withDescription("The truststore file containing the public CA certificates to be used by flink endpoints to verify the peer\u2019s certificate.");
    @Documentation.ExcludeFromDocumentation(value="The SSL Setup encourages separate configs for internal and REST security.")
    public static final ConfigOption<String> SSL_TRUSTSTORE_PASSWORD = ConfigOptions.key("security.ssl.truststore-password").noDefaultValue().withDescription("The secret to decrypt the truststore.");
    @Documentation.Section(value={"security_ssl"})
    public static final ConfigOption<String> SSL_INTERNAL_KEYSTORE = ConfigOptions.key("security.ssl.internal.keystore").noDefaultValue().withDescription("The Java keystore file with SSL Key and Certificate, to be used Flink's internal endpoints (rpc, data transport, blob server).");
    @Documentation.Section(value={"security_ssl"})
    public static final ConfigOption<String> SSL_INTERNAL_KEYSTORE_PASSWORD = ConfigOptions.key("security.ssl.internal.keystore-password").noDefaultValue().withDescription("The secret to decrypt the keystore file for Flink's for Flink's internal endpoints (rpc, data transport, blob server).");
    @Documentation.Section(value={"security_ssl"})
    public static final ConfigOption<String> SSL_INTERNAL_KEY_PASSWORD = ConfigOptions.key("security.ssl.internal.key-password").noDefaultValue().withDescription("The secret to decrypt the key in the keystore for Flink's internal endpoints (rpc, data transport, blob server).");
    @Documentation.Section(value={"security_ssl"})
    public static final ConfigOption<String> SSL_INTERNAL_TRUSTSTORE = ConfigOptions.key("security.ssl.internal.truststore").noDefaultValue().withDescription("The truststore file containing the public CA certificates to verify the peer for Flink's internal endpoints (rpc, data transport, blob server).");
    @Documentation.Section(value={"security_ssl"})
    public static final ConfigOption<String> SSL_INTERNAL_TRUSTSTORE_PASSWORD = ConfigOptions.key("security.ssl.internal.truststore-password").noDefaultValue().withDescription("The password to decrypt the truststore for Flink's internal endpoints (rpc, data transport, blob server).");
    @Documentation.Section(value={"security_ssl"})
    public static final ConfigOption<String> SSL_INTERNAL_CERT_FINGERPRINT = ConfigOptions.key("security.ssl.internal.cert.fingerprint").noDefaultValue().withDescription("The sha1 fingerprint of the internal certificate. This further protects the internal communication to present the exact certificate used by Flink.This is necessary where one cannot use private CA(self signed) or there is internal firm wide CA is required");
    @Documentation.Section(value={"security_ssl"})
    public static final ConfigOption<String> SSL_REST_KEYSTORE = ConfigOptions.key("security.ssl.rest.keystore").noDefaultValue().withDescription("The Java keystore file with SSL Key and Certificate, to be used Flink's external REST endpoints.");
    @Documentation.Section(value={"security_ssl"})
    public static final ConfigOption<String> SSL_REST_KEYSTORE_PASSWORD = ConfigOptions.key("security.ssl.rest.keystore-password").noDefaultValue().withDescription("The secret to decrypt the keystore file for Flink's for Flink's external REST endpoints.");
    @Documentation.Section(value={"security_ssl"})
    public static final ConfigOption<String> SSL_REST_KEY_PASSWORD = ConfigOptions.key("security.ssl.rest.key-password").noDefaultValue().withDescription("The secret to decrypt the key in the keystore for Flink's external REST endpoints.");
    @Documentation.Section(value={"security_ssl"})
    public static final ConfigOption<String> SSL_REST_TRUSTSTORE = ConfigOptions.key("security.ssl.rest.truststore").noDefaultValue().withDescription("The truststore file containing the public CA certificates to verify the peer for Flink's external REST endpoints.");
    @Documentation.Section(value={"security_ssl"})
    public static final ConfigOption<String> SSL_REST_TRUSTSTORE_PASSWORD = ConfigOptions.key("security.ssl.rest.truststore-password").noDefaultValue().withDescription("The password to decrypt the truststore for Flink's external REST endpoints.");
    @Documentation.Section(value={"security_ssl"})
    public static final ConfigOption<String> SSL_REST_CERT_FINGERPRINT = ConfigOptions.key("security.ssl.rest.cert.fingerprint").noDefaultValue().withDescription("The sha1 fingerprint of the rest certificate. This further protects the rest REST endpoints to present certificate which is only used by proxy serverThis is necessary where once uses public CA or internal firm wide CA");
    @Documentation.Section(value={"security_ssl"})
    public static final ConfigOption<String> SSL_PROTOCOL = ConfigOptions.key("security.ssl.protocol").defaultValue("TLSv1.2").withDescription("The SSL protocol version to be supported for the ssl transport. Note that it doesn\u2019t support comma separated list.");
    @Documentation.Section(value={"security_ssl"})
    public static final ConfigOption<String> SSL_ALGORITHMS = ConfigOptions.key("security.ssl.algorithms").defaultValue("TLS_RSA_WITH_AES_128_CBC_SHA").withDescription(Description.builder().text("The comma separated list of standard SSL algorithms to be supported. Read more %s", LinkElement.link("http://docs.oracle.com/javase/8/docs/technotes/guides/security/StandardNames.html#ciphersuites", "here")).build());
    @Documentation.Section(value={"security_ssl"})
    public static final ConfigOption<Boolean> SSL_VERIFY_HOSTNAME = ConfigOptions.key("security.ssl.verify-hostname").defaultValue(true).withDescription("Flag to enable peer\u2019s hostname verification during ssl handshake.");
    @Documentation.Section(value={"expert_security_ssl"})
    public static final ConfigOption<String> SSL_PROVIDER = ConfigOptions.key("security.ssl.provider").defaultValue("JDK").withDescription(Description.builder().text("The SSL engine provider to use for the ssl transport:").list(TextElement.text("%s: default Java-based SSL engine", TextElement.code("JDK")), TextElement.text("%s: openSSL-based SSL engine using system libraries", TextElement.code("OPENSSL"))).text("%s is based on %s and comes in two flavours:", TextElement.code("OPENSSL"), LinkElement.link("http://netty.io/wiki/forked-tomcat-native.html#wiki-h2-4", "netty-tcnative")).list(TextElement.text("dynamically linked: This will use your system's openSSL libraries (if compatible) and requires %s to be copied to %s", TextElement.code("opt/flink-shaded-netty-tcnative-dynamic-*.jar"), TextElement.code("lib/")), TextElement.text("statically linked: Due to potential licensing issues with openSSL (see %s), we cannot ship pre-built libraries. However, you can build the required library yourself and put it into %s:%s%s", LinkElement.link("https://issues.apache.org/jira/browse/LEGAL-393", "LEGAL-393"), TextElement.code("lib/"), LineBreakElement.linebreak(), TextElement.code("git clone https://github.com/apache/flink-shaded.git && cd flink-shaded && mvn clean package -Pinclude-netty-tcnative-static -pl flink-shaded-netty-tcnative-static"))).build());
    @Documentation.Section(value={"expert_security_ssl"})
    public static final ConfigOption<Integer> SSL_INTERNAL_SESSION_CACHE_SIZE = ConfigOptions.key("security.ssl.internal.session-cache-size").defaultValue(-1).withDescription("The size of the cache used for storing SSL session objects. According to https://github.com/netty/netty/issues/832, you should always set this to an appropriate number to not run into a bug with stalling IO threads during garbage collection. (-1 = use system default).").withDeprecatedKeys("security.ssl.session-cache-size");
    @Documentation.Section(value={"expert_security_ssl"})
    public static final ConfigOption<Integer> SSL_INTERNAL_SESSION_TIMEOUT = ConfigOptions.key("security.ssl.internal.session-timeout").defaultValue(-1).withDescription("The timeout (in ms) for the cached SSL session objects. (-1 = use system default)").withDeprecatedKeys("security.ssl.session-timeout");
    @Documentation.Section(value={"expert_security_ssl"})
    public static final ConfigOption<Integer> SSL_INTERNAL_HANDSHAKE_TIMEOUT = ConfigOptions.key("security.ssl.internal.handshake-timeout").defaultValue(-1).withDescription("The timeout (in ms) during SSL handshake. (-1 = use system default)").withDeprecatedKeys("security.ssl.handshake-timeout");
    @Documentation.Section(value={"expert_security_ssl"})
    public static final ConfigOption<Integer> SSL_INTERNAL_CLOSE_NOTIFY_FLUSH_TIMEOUT = ConfigOptions.key("security.ssl.internal.close-notify-flush-timeout").defaultValue(-1).withDescription("The timeout (in ms) for flushing the `close_notify` that was triggered by closing a channel. If the `close_notify` was not flushed in the given timeout the channel will be closed forcibly. (-1 = use system default)").withDeprecatedKeys("security.ssl.close-notify-flush-timeout");
}

