/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;

@Internal
public final class CollectionUtil {
    public static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    private CollectionUtil() {
        throw new AssertionError();
    }

    public static boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNullOrEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static <T, R> Stream<R> mapWithIndex(Collection<T> input, BiFunction<T, Integer, R> mapper) {
        AtomicInteger count = new AtomicInteger(0);
        return input.stream().map(element -> mapper.apply(element, count.getAndIncrement()));
    }

    public static <T> Collection<List<T>> partition(Collection<T> elements, int numBuckets) {
        HashMap<Integer, List> buckets = new HashMap<Integer, List>(numBuckets);
        int initialCapacity = elements.size() / numBuckets;
        int index = 0;
        for (T element : elements) {
            int bucket = index % numBuckets;
            buckets.computeIfAbsent(bucket, key -> new ArrayList(initialCapacity)).add(element);
        }
        return buckets.values();
    }

    public static <I, O> Collection<O> project(Collection<I> collection, Function<I, O> projector) {
        return collection.stream().map(projector).collect(Collectors.toList());
    }

    public static <E> List<E> iterableToList(@Nullable Iterable<E> iterable) {
        if (iterable == null) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList();
        iterable.iterator().forEachRemaining(list::add);
        return list;
    }
}

