/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.source.datagen;

import org.apache.commons.math3.random.RandomDataGenerator;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.streaming.api.functions.source.datagen.DataGenerator;

@Experimental
public abstract class RandomGenerator<T>
implements DataGenerator<T> {
    protected transient RandomDataGenerator random;

    @Override
    public void open(String name, FunctionInitializationContext context, RuntimeContext runtimeContext) throws Exception {
        this.random = new RandomDataGenerator();
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    public static RandomGenerator<Long> longGenerator(final long min, final long max) {
        return new RandomGenerator<Long>(){

            @Override
            public Long next() {
                return this.random.nextLong(min, max);
            }
        };
    }

    public static RandomGenerator<Integer> intGenerator(final int min, final int max) {
        return new RandomGenerator<Integer>(){

            @Override
            public Integer next() {
                return this.random.nextInt(min, max);
            }
        };
    }

    public static RandomGenerator<Short> shortGenerator(final short min, final short max) {
        return new RandomGenerator<Short>(){

            @Override
            public Short next() {
                return (short)this.random.nextInt((int)min, (int)max);
            }
        };
    }

    public static RandomGenerator<Byte> byteGenerator(final byte min, final byte max) {
        return new RandomGenerator<Byte>(){

            @Override
            public Byte next() {
                return (byte)this.random.nextInt((int)min, (int)max);
            }
        };
    }

    public static RandomGenerator<Float> floatGenerator(final float min, final float max) {
        return new RandomGenerator<Float>(){

            @Override
            public Float next() {
                return Float.valueOf((float)this.random.nextUniform((double)min, (double)max));
            }
        };
    }

    public static RandomGenerator<Double> doubleGenerator(final double min, final double max) {
        return new RandomGenerator<Double>(){

            @Override
            public Double next() {
                return this.random.nextUniform(min, max);
            }
        };
    }

    public static RandomGenerator<String> stringGenerator(final int len) {
        return new RandomGenerator<String>(){

            @Override
            public String next() {
                return this.random.nextHexString(len);
            }
        };
    }

    public static RandomGenerator<Boolean> booleanGenerator() {
        return new RandomGenerator<Boolean>(){

            @Override
            public Boolean next() {
                return this.random.nextInt(0, 1) == 0;
            }
        };
    }
}

