/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.collect;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.accumulators.SerializedListAccumulator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.array.BytePrimitiveArraySerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.coordination.CoordinationRequest;
import org.apache.flink.runtime.operators.coordination.CoordinationRequestGateway;
import org.apache.flink.streaming.api.operators.collect.CollectCoordinationRequest;
import org.apache.flink.streaming.api.operators.collect.CollectCoordinationResponse;
import org.apache.flink.streaming.api.operators.collect.CollectSinkFunction;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectResultFetcher<T> {
    private static final int DEFAULT_RETRY_MILLIS = 100;
    private static final long DEFAULT_ACCUMULATOR_GET_MILLIS = 10000L;
    private static final Logger LOG = LoggerFactory.getLogger(CollectResultFetcher.class);
    private final CompletableFuture<OperatorID> operatorIdFuture;
    private final String accumulatorName;
    private final int retryMillis;
    private ResultBuffer buffer;
    @Nullable
    private JobClient jobClient;
    @Nullable
    private CoordinationRequestGateway gateway;
    private boolean jobTerminated;
    private boolean closed;

    public CollectResultFetcher(CompletableFuture<OperatorID> operatorIdFuture, TypeSerializer<T> serializer, String accumulatorName) {
        this(operatorIdFuture, serializer, accumulatorName, 100);
    }

    CollectResultFetcher(CompletableFuture<OperatorID> operatorIdFuture, TypeSerializer<T> serializer, String accumulatorName, int retryMillis) {
        this.operatorIdFuture = operatorIdFuture;
        this.accumulatorName = accumulatorName;
        this.retryMillis = retryMillis;
        this.buffer = new ResultBuffer(serializer);
        this.jobTerminated = false;
        this.closed = false;
    }

    public void setJobClient(JobClient jobClient) {
        Preconditions.checkArgument((boolean)(jobClient instanceof CoordinationRequestGateway), (Object)"Job client must be a CoordinationRequestGateway. This is a bug.");
        this.jobClient = jobClient;
        this.gateway = (CoordinationRequestGateway)jobClient;
    }

    public T next() throws IOException {
        if (this.closed) {
            return null;
        }
        boolean beforeFirstTry = true;
        Object res;
        while ((res = this.buffer.next()) == null) {
            CollectCoordinationResponse<T> response;
            if (this.jobTerminated) {
                return null;
            }
            if (!beforeFirstTry) {
                this.sleepBeforeRetry();
            }
            beforeFirstTry = false;
            if (this.isJobTerminated()) {
                this.jobTerminated = true;
                Tuple2<Long, CollectCoordinationResponse<T>> accResults = this.getAccumulatorResults();
                this.buffer.dealWithResponse((CollectCoordinationResponse)accResults.f1, (Long)accResults.f0);
                this.buffer.complete();
                continue;
            }
            long requestOffset = this.buffer.offset;
            try {
                response = this.sendRequest(this.buffer.version, requestOffset);
            }
            catch (Exception e) {
                LOG.warn("An exception occurs when fetching query results", (Throwable)e);
                continue;
            }
            this.buffer.dealWithResponse(response, requestOffset);
        }
        return (T)res;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.cancelJob();
        this.closed = true;
    }

    private CollectCoordinationResponse<T> sendRequest(String version, long offset) throws InterruptedException, ExecutionException {
        this.checkJobClientConfigured();
        OperatorID operatorId = this.operatorIdFuture.getNow(null);
        Preconditions.checkNotNull((Object)operatorId, (String)"Unknown operator ID. This is a bug.");
        CollectCoordinationRequest request = new CollectCoordinationRequest(version, offset);
        return (CollectCoordinationResponse)this.gateway.sendCoordinationRequest(operatorId, (CoordinationRequest)request).get();
    }

    private Tuple2<Long, CollectCoordinationResponse<T>> getAccumulatorResults() throws IOException {
        JobExecutionResult executionResult;
        this.checkJobClientConfigured();
        try {
            executionResult = (JobExecutionResult)this.jobClient.getJobExecutionResult(this.getClass().getClassLoader()).get(10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new IOException("Failed to fetch job execution result", e);
        }
        ArrayList accResults = (ArrayList)executionResult.getAccumulatorResult(this.accumulatorName);
        if (accResults == null) {
            throw new IOException("Job terminated abnormally, no job execution result can be fetched");
        }
        try {
            List serializedResults = SerializedListAccumulator.deserializeList((ArrayList)accResults, (TypeSerializer)BytePrimitiveArraySerializer.INSTANCE);
            byte[] serializedResult = (byte[])serializedResults.get(0);
            return CollectSinkFunction.deserializeAccumulatorResult(serializedResult);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IOException("Failed to deserialize accumulator results", e);
        }
    }

    private boolean isJobTerminated() {
        this.checkJobClientConfigured();
        try {
            JobStatus status = (JobStatus)this.jobClient.getJobStatus().get();
            return status.isGloballyTerminalState();
        }
        catch (Exception e) {
            LOG.warn("Failed to get job status so we assume that the job has terminated. Some data might be lost.", (Throwable)e);
            return true;
        }
    }

    private void cancelJob() {
        this.checkJobClientConfigured();
        if (!this.isJobTerminated()) {
            this.jobClient.cancel();
        }
    }

    private void sleepBeforeRetry() {
        if (this.retryMillis <= 0) {
            return;
        }
        try {
            Thread.sleep(this.retryMillis);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted when sleeping before a retry", (Throwable)e);
        }
    }

    private void checkJobClientConfigured() {
        Preconditions.checkNotNull((Object)this.jobClient, (String)"Job client must be configured before first use.");
        Preconditions.checkNotNull((Object)this.gateway, (String)"Coordination request gateway must be configured before first use.");
    }

    private class ResultBuffer {
        private static final String INIT_VERSION = "";
        private final LinkedList<T> buffer = new LinkedList();
        private final TypeSerializer<T> serializer;
        private String version;
        private long offset;
        private long userVisibleHead;
        private long userVisibleTail;

        private ResultBuffer(TypeSerializer<T> serializer) {
            this.serializer = serializer;
            this.version = INIT_VERSION;
            this.offset = 0L;
            this.userVisibleHead = 0L;
            this.userVisibleTail = 0L;
        }

        private T next() {
            if (this.userVisibleHead == this.userVisibleTail) {
                return null;
            }
            Object ret = this.buffer.removeFirst();
            ++this.userVisibleHead;
            this.sanityCheck();
            return ret;
        }

        private void dealWithResponse(CollectCoordinationResponse<T> response, long responseOffset) throws IOException {
            String responseVersion = response.getVersion();
            long responseLastCheckpointedOffset = response.getLastCheckpointedOffset();
            List results = response.getResults(this.serializer);
            if (!this.version.equals(responseVersion)) {
                for (long i = 0L; i < this.offset - responseLastCheckpointedOffset; ++i) {
                    this.buffer.removeLast();
                }
                this.version = responseVersion;
                this.offset = responseLastCheckpointedOffset;
            }
            if (responseLastCheckpointedOffset > this.userVisibleTail) {
                this.userVisibleTail = responseLastCheckpointedOffset;
            }
            if (!results.isEmpty()) {
                int addStart = (int)(this.offset - responseOffset);
                List addedResults = results.subList(addStart, results.size());
                this.buffer.addAll(addedResults);
                this.offset += (long)addedResults.size();
            }
            this.sanityCheck();
        }

        private void complete() {
            this.userVisibleTail = this.offset;
        }

        private void sanityCheck() {
            Preconditions.checkState((this.userVisibleHead <= this.userVisibleTail ? 1 : 0) != 0, (Object)"userVisibleHead should not be larger than userVisibleTail. This is a bug.");
            Preconditions.checkState((this.userVisibleTail <= this.offset ? 1 : 0) != 0, (Object)"userVisibleTail should not be larger than offset. This is a bug.");
        }
    }
}

