/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.io.PullingAsyncDataInput;
import org.apache.flink.runtime.io.network.api.CancelCheckpointMarker;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.streaming.runtime.io.CheckpointBarrierHandler;
import org.apache.flink.util.Preconditions;

@Internal
public class CheckpointedInputGate
implements PullingAsyncDataInput<BufferOrEvent>,
Closeable {
    private final CheckpointBarrierHandler barrierHandler;
    private final InputGate inputGate;
    private boolean isFinished;

    public CheckpointedInputGate(InputGate inputGate, CheckpointBarrierHandler barrierHandler) {
        this.inputGate = inputGate;
        this.barrierHandler = barrierHandler;
    }

    public CompletableFuture<?> getAvailableFuture() {
        return this.inputGate.getAvailableFuture();
    }

    public Optional<BufferOrEvent> pollNext() throws Exception {
        BufferOrEvent bufferOrEvent;
        Optional next;
        while (true) {
            if (!(next = this.inputGate.pollNext()).isPresent()) {
                return this.handleEmptyBuffer();
            }
            bufferOrEvent = (BufferOrEvent)next.get();
            Preconditions.checkState((!this.barrierHandler.isBlocked(bufferOrEvent.getChannelInfo()) ? 1 : 0) != 0);
            if (bufferOrEvent.isBuffer()) {
                return next;
            }
            if (bufferOrEvent.getEvent().getClass() == CheckpointBarrier.class) {
                CheckpointBarrier checkpointBarrier = (CheckpointBarrier)bufferOrEvent.getEvent();
                this.barrierHandler.processBarrier(checkpointBarrier, bufferOrEvent.getChannelInfo());
                return next;
            }
            if (bufferOrEvent.getEvent().getClass() != CancelCheckpointMarker.class) break;
            this.barrierHandler.processCancellationBarrier((CancelCheckpointMarker)bufferOrEvent.getEvent());
        }
        if (bufferOrEvent.getEvent().getClass() == EndOfPartitionEvent.class) {
            this.barrierHandler.processEndOfPartition();
        }
        return next;
    }

    public void spillInflightBuffers(long checkpointId, int channelIndex, ChannelStateWriter channelStateWriter) throws IOException {
        InputChannel channel = this.inputGate.getChannel(channelIndex);
        if (this.barrierHandler.hasInflightData(checkpointId, channel.getChannelInfo())) {
            channel.spillInflightBuffers(checkpointId, channelStateWriter);
        }
    }

    public CompletableFuture<Void> getAllBarriersReceivedFuture(long checkpointId) {
        return this.barrierHandler.getAllBarriersReceivedFuture(checkpointId);
    }

    private Optional<BufferOrEvent> handleEmptyBuffer() {
        if (this.inputGate.isFinished()) {
            this.isFinished = true;
        }
        return Optional.empty();
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    @Override
    public void close() throws IOException {
        this.barrierHandler.close();
    }

    @VisibleForTesting
    long getLatestCheckpointId() {
        return this.barrierHandler.getLatestCheckpointId();
    }

    @VisibleForTesting
    long getAlignmentDurationNanos() {
        return this.barrierHandler.getAlignmentDurationNanos();
    }

    @VisibleForTesting
    long getCheckpointStartDelayNanos() {
        return this.barrierHandler.getCheckpointStartDelayNanos();
    }

    public int getNumberOfInputChannels() {
        return this.inputGate.getNumberOfInputChannels();
    }

    public String toString() {
        return this.barrierHandler.toString();
    }

    public InputChannel getChannel(int channelIndex) {
        return this.inputGate.getChannel(channelIndex);
    }

    public List<InputChannelInfo> getChannelInfos() {
        return this.inputGate.getChannelInfos();
    }

    @VisibleForTesting
    CheckpointBarrierHandler getCheckpointBarrierHandler() {
        return this.barrierHandler;
    }
}

