/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.io.network.partition.consumer.IndexedInputGate;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;
import org.apache.flink.shaded.guava18.com.google.common.collect.Iterables;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.runtime.io.AlternatingCheckpointBarrierHandler;
import org.apache.flink.streaming.runtime.io.CheckpointBarrierAligner;
import org.apache.flink.streaming.runtime.io.CheckpointBarrierHandler;
import org.apache.flink.streaming.runtime.io.CheckpointBarrierTracker;
import org.apache.flink.streaming.runtime.io.CheckpointBarrierUnaligner;
import org.apache.flink.streaming.runtime.io.CheckpointedInputGate;
import org.apache.flink.streaming.runtime.io.InputGateUtil;
import org.apache.flink.streaming.runtime.tasks.SubtaskCheckpointCoordinator;

@Internal
public class InputProcessorUtil {
    public static CheckpointedInputGate createCheckpointedInputGate(AbstractInvokable toNotifyOnCheckpoint, StreamConfig config, SubtaskCheckpointCoordinator checkpointCoordinator, IndexedInputGate[] inputGates, TaskIOMetricGroup taskIOMetricGroup, String taskName) {
        CheckpointedInputGate[] checkpointedInputGates = InputProcessorUtil.createCheckpointedMultipleInputGate(toNotifyOnCheckpoint, config, checkpointCoordinator, taskIOMetricGroup, taskName, Arrays.asList(inputGates));
        return (CheckpointedInputGate)Iterables.getOnlyElement(Arrays.asList(checkpointedInputGates));
    }

    public static CheckpointedInputGate[] createCheckpointedMultipleInputGate(AbstractInvokable toNotifyOnCheckpoint, StreamConfig config, SubtaskCheckpointCoordinator checkpointCoordinator, TaskIOMetricGroup taskIOMetricGroup, String taskName, List<IndexedInputGate> ... inputGates) {
        IndexedInputGate[] sortedInputGates = (IndexedInputGate[])Arrays.stream(inputGates).flatMap(Collection::stream).sorted(Comparator.comparing(IndexedInputGate::getGateIndex)).toArray(IndexedInputGate[]::new);
        CheckpointBarrierHandler barrierHandler = InputProcessorUtil.createCheckpointBarrierHandler(config, (InputGate[])sortedInputGates, checkpointCoordinator, taskName, toNotifyOnCheckpoint);
        InputProcessorUtil.registerCheckpointMetrics(taskIOMetricGroup, barrierHandler);
        InputGate[] unionedInputGates = (InputGate[])Arrays.stream(inputGates).map(InputGateUtil::createInputGate).toArray(InputGate[]::new);
        barrierHandler.getBufferReceivedListener().ifPresent(listener -> {
            for (InputGate inputGate : unionedInputGates) {
                inputGate.registerBufferReceivedListener(listener);
            }
        });
        return (CheckpointedInputGate[])Arrays.stream(unionedInputGates).map(unionedInputGate -> new CheckpointedInputGate((InputGate)unionedInputGate, barrierHandler)).toArray(CheckpointedInputGate[]::new);
    }

    private static CheckpointBarrierHandler createCheckpointBarrierHandler(StreamConfig config, InputGate[] inputGates, SubtaskCheckpointCoordinator checkpointCoordinator, String taskName, AbstractInvokable toNotifyOnCheckpoint) {
        switch (config.getCheckpointMode()) {
            case EXACTLY_ONCE: {
                if (config.isUnalignedCheckpointsEnabled()) {
                    return new AlternatingCheckpointBarrierHandler(new CheckpointBarrierAligner(taskName, toNotifyOnCheckpoint, inputGates), new CheckpointBarrierUnaligner(checkpointCoordinator, taskName, toNotifyOnCheckpoint, inputGates), toNotifyOnCheckpoint);
                }
                return new CheckpointBarrierAligner(taskName, toNotifyOnCheckpoint, inputGates);
            }
            case AT_LEAST_ONCE: {
                if (config.isUnalignedCheckpointsEnabled()) {
                    throw new IllegalStateException("Cannot use unaligned checkpoints with AT_LEAST_ONCE checkpointing mode");
                }
                int numInputChannels = Arrays.stream(inputGates).mapToInt(InputGate::getNumberOfInputChannels).sum();
                return new CheckpointBarrierTracker(numInputChannels, toNotifyOnCheckpoint);
            }
        }
        throw new UnsupportedOperationException("Unrecognized Checkpointing Mode: " + (Object)((Object)config.getCheckpointMode()));
    }

    private static void registerCheckpointMetrics(TaskIOMetricGroup taskIOMetricGroup, CheckpointBarrierHandler barrierHandler) {
        taskIOMetricGroup.gauge("checkpointAlignmentTime", barrierHandler::getAlignmentDurationNanos);
        taskIOMetricGroup.gauge("checkpointStartDelayNanos", barrierHandler::getCheckpointStartDelayNanos);
    }
}

