/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.io.network.partition.consumer.IndexedInputGate;
import org.apache.flink.runtime.metrics.MetricNames;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.operators.InputSelectable;
import org.apache.flink.streaming.api.operators.MultipleInputStreamOperator;
import org.apache.flink.streaming.runtime.io.CheckpointedInputGate;
import org.apache.flink.streaming.runtime.io.InputProcessorUtil;
import org.apache.flink.streaming.runtime.io.MultipleInputSelectionHandler;
import org.apache.flink.streaming.runtime.io.StreamMultipleInputProcessor;
import org.apache.flink.streaming.runtime.metrics.MinWatermarkGauge;
import org.apache.flink.streaming.runtime.metrics.WatermarkGauge;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.util.Preconditions;

@Internal
public class MultipleInputStreamTask<OUT>
extends StreamTask<OUT, MultipleInputStreamOperator<OUT>> {
    public MultipleInputStreamTask(Environment env) throws Exception {
        super(env);
    }

    @Override
    public void init() throws Exception {
        StreamConfig configuration = this.getConfiguration();
        ClassLoader userClassLoader = this.getUserCodeClassLoader();
        TypeSerializer<?>[] inputDeserializers = configuration.getTypeSerializersIn(userClassLoader);
        ArrayList[] inputLists = new ArrayList[inputDeserializers.length];
        WatermarkGauge[] watermarkGauges = new WatermarkGauge[inputDeserializers.length];
        for (int i = 0; i < inputDeserializers.length; ++i) {
            inputLists[i] = new ArrayList();
            watermarkGauges[i] = new WatermarkGauge();
            ((MultipleInputStreamOperator)this.headOperator).getMetricGroup().gauge(MetricNames.currentInputWatermarkName((int)(i + 1)), (Gauge)watermarkGauges[i]);
        }
        MinWatermarkGauge minInputWatermarkGauge = new MinWatermarkGauge(watermarkGauges);
        ((MultipleInputStreamOperator)this.headOperator).getMetricGroup().gauge("currentInputWatermark", (Gauge)minInputWatermarkGauge);
        List<StreamEdge> inEdges = configuration.getInPhysicalEdges(userClassLoader);
        int numberOfInputs = configuration.getNumberOfInputs();
        for (int i = 0; i < numberOfInputs; ++i) {
            int inputType = inEdges.get(i).getTypeNumber();
            IndexedInputGate reader = this.getEnvironment().getInputGate(i);
            inputLists[inputType - 1].add(reader);
        }
        this.createInputProcessor(inputLists, inputDeserializers, watermarkGauges);
        this.getEnvironment().getMetricGroup().gauge("currentInputWatermark", minInputWatermarkGauge::getValue);
    }

    protected void createInputProcessor(List<IndexedInputGate>[] inputGates, TypeSerializer<?>[] inputDeserializers, WatermarkGauge[] inputWatermarkGauges) {
        MultipleInputSelectionHandler selectionHandler = new MultipleInputSelectionHandler(this.headOperator instanceof InputSelectable ? (InputSelectable)((Object)this.headOperator) : null, inputGates.length);
        CheckpointedInputGate[] checkpointedInputGates = InputProcessorUtil.createCheckpointedMultipleInputGate(this, this.getConfiguration(), this.getCheckpointCoordinator(), this.getEnvironment().getMetricGroup().getIOMetricGroup(), this.getTaskNameWithSubtaskAndId(), inputGates);
        Preconditions.checkState((checkpointedInputGates.length == inputGates.length ? 1 : 0) != 0);
        this.inputProcessor = new StreamMultipleInputProcessor(checkpointedInputGates, inputDeserializers, this.getEnvironment().getIOManager(), this.getStreamStatusMaintainer(), (MultipleInputStreamOperator)this.headOperator, selectionHandler, inputWatermarkGauges, this.operatorChain, this.setupNumRecordsInCounter(this.headOperator));
    }
}

