/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.io.network.partition.consumer.IndexedInputGate;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.io.AbstractDataOutput;
import org.apache.flink.streaming.runtime.io.CheckpointedInputGate;
import org.apache.flink.streaming.runtime.io.InputProcessorUtil;
import org.apache.flink.streaming.runtime.io.PushingAsyncDataInput;
import org.apache.flink.streaming.runtime.io.StreamOneInputProcessor;
import org.apache.flink.streaming.runtime.io.StreamTaskInput;
import org.apache.flink.streaming.runtime.io.StreamTaskNetworkInput;
import org.apache.flink.streaming.runtime.metrics.WatermarkGauge;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.streamstatus.StatusWatermarkValve;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatusMaintainer;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.streaming.runtime.tasks.TimerService;
import org.apache.flink.util.Preconditions;

@Internal
public class OneInputStreamTask<IN, OUT>
extends StreamTask<OUT, OneInputStreamOperator<IN, OUT>> {
    private final WatermarkGauge inputWatermarkGauge = new WatermarkGauge();

    public OneInputStreamTask(Environment env) throws Exception {
        super(env);
    }

    @VisibleForTesting
    public OneInputStreamTask(Environment env, @Nullable TimerService timeProvider) throws Exception {
        super(env, timeProvider);
    }

    @Override
    public void init() throws Exception {
        StreamConfig configuration = this.getConfiguration();
        int numberOfInputs = configuration.getNumberOfInputs();
        if (numberOfInputs > 0) {
            CheckpointedInputGate inputGate = this.createCheckpointedInputGate();
            PushingAsyncDataInput.DataOutput<IN> output = this.createDataOutput();
            StreamTaskInput<IN> input = this.createTaskInput(inputGate, output);
            this.inputProcessor = new StreamOneInputProcessor<IN>(input, output, this.operatorChain);
        }
        ((OneInputStreamOperator)this.headOperator).getMetricGroup().gauge("currentInputWatermark", (Gauge)this.inputWatermarkGauge);
        this.getEnvironment().getMetricGroup().gauge("currentInputWatermark", this.inputWatermarkGauge::getValue);
    }

    private CheckpointedInputGate createCheckpointedInputGate() {
        IndexedInputGate[] inputGates = this.getEnvironment().getAllInputGates();
        return InputProcessorUtil.createCheckpointedInputGate(this, this.configuration, this.getCheckpointCoordinator(), inputGates, this.getEnvironment().getMetricGroup().getIOMetricGroup(), this.getTaskNameWithSubtaskAndId());
    }

    private PushingAsyncDataInput.DataOutput<IN> createDataOutput() {
        return new StreamTaskNetworkOutput((OneInputStreamOperator)this.headOperator, this.getStreamStatusMaintainer(), this.inputWatermarkGauge, this.setupNumRecordsInCounter(this.headOperator));
    }

    private StreamTaskInput<IN> createTaskInput(CheckpointedInputGate inputGate, PushingAsyncDataInput.DataOutput<IN> output) {
        int numberOfInputChannels = inputGate.getNumberOfInputChannels();
        StatusWatermarkValve statusWatermarkValve = new StatusWatermarkValve(numberOfInputChannels, output);
        TypeSerializer inSerializer = this.configuration.getTypeSerializerIn1(this.getUserCodeClassLoader());
        return new StreamTaskNetworkInput(inputGate, inSerializer, this.getEnvironment().getIOManager(), statusWatermarkValve, 0);
    }

    private static class StreamTaskNetworkOutput<IN>
    extends AbstractDataOutput<IN> {
        private final OneInputStreamOperator<IN, ?> operator;
        private final WatermarkGauge watermarkGauge;
        private final Counter numRecordsIn;

        private StreamTaskNetworkOutput(OneInputStreamOperator<IN, ?> operator, StreamStatusMaintainer streamStatusMaintainer, WatermarkGauge watermarkGauge, Counter numRecordsIn) {
            super(streamStatusMaintainer);
            this.operator = (OneInputStreamOperator)Preconditions.checkNotNull(operator);
            this.watermarkGauge = (WatermarkGauge)Preconditions.checkNotNull((Object)watermarkGauge);
            this.numRecordsIn = (Counter)Preconditions.checkNotNull((Object)numRecordsIn);
        }

        @Override
        public void emitRecord(StreamRecord<IN> record) throws Exception {
            this.numRecordsIn.inc();
            this.operator.setKeyContextElement1(record);
            this.operator.processElement(record);
        }

        @Override
        public void emitWatermark(Watermark watermark) throws Exception {
            this.watermarkGauge.setCurrentWatermark(watermark.getTimestamp());
            this.operator.processWatermark(watermark);
        }

        @Override
        public void emitLatencyMarker(LatencyMarker latencyMarker) throws Exception {
            this.operator.processLatencyMarker(latencyMarker);
        }
    }
}

