/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.io.network.api.writer.RecordWriter;
import org.apache.flink.runtime.io.network.api.writer.RecordWriterDelegate;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.metrics.groups.OperatorIOMetricGroup;
import org.apache.flink.runtime.metrics.groups.OperatorMetricGroup;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.runtime.operators.coordination.OperatorEventDispatcher;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.streaming.api.collector.selector.CopyingDirectedOutput;
import org.apache.flink.streaming.api.collector.selector.DirectedOutput;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactoryUtil;
import org.apache.flink.streaming.api.operators.StreamTaskStateInitializer;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.io.RecordWriterOutput;
import org.apache.flink.streaming.runtime.metrics.WatermarkGauge;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatus;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatusMaintainer;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatusProvider;
import org.apache.flink.streaming.runtime.tasks.ExceptionInChainedOperatorException;
import org.apache.flink.streaming.runtime.tasks.OperatorEventDispatcherImpl;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.StreamOperatorWrapper;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.streaming.runtime.tasks.StreamTaskActionExecutor;
import org.apache.flink.streaming.runtime.tasks.mailbox.MailboxExecutorFactory;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.XORShiftRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class OperatorChain<OUT, OP extends StreamOperator<OUT>>
implements StreamStatusMaintainer {
    private static final Logger LOG = LoggerFactory.getLogger(OperatorChain.class);
    private final RecordWriterOutput<?>[] streamOutputs;
    private final WatermarkGaugeExposingOutput<StreamRecord<OUT>> chainEntryPoint;
    @Nullable
    private final StreamOperatorWrapper<OUT, OP> headOperatorWrapper;
    @Nullable
    private final StreamOperatorWrapper<?, ?> tailOperatorWrapper;
    private final int numOperators;
    private final OperatorEventDispatcherImpl operatorEventDispatcher;
    private StreamStatus streamStatus = StreamStatus.ACTIVE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperatorChain(StreamTask<OUT, OP> containingTask, RecordWriterDelegate<SerializationDelegate<StreamRecord<OUT>>> recordWriterDelegate) {
        this.operatorEventDispatcher = new OperatorEventDispatcherImpl(containingTask.getEnvironment().getUserClassLoader(), containingTask.getEnvironment().getOperatorCoordinatorEventGateway());
        ClassLoader userCodeClassloader = containingTask.getUserCodeClassLoader();
        StreamConfig configuration = containingTask.getConfiguration();
        Object operatorFactory = configuration.getStreamOperatorFactory(userCodeClassloader);
        Map<Integer, StreamConfig> chainedConfigs = configuration.getTransitiveChainedTaskConfigsWithSelf(userCodeClassloader);
        List<StreamEdge> outEdgesInOrder = configuration.getOutEdgesInOrder(userCodeClassloader);
        HashMap streamOutputMap = new HashMap(outEdgesInOrder.size());
        this.streamOutputs = new RecordWriterOutput[outEdgesInOrder.size()];
        boolean success = false;
        try {
            for (int i = 0; i < outEdgesInOrder.size(); ++i) {
                StreamEdge outEdge = outEdgesInOrder.get(i);
                RecordWriterOutput<OUT> streamOutput = this.createStreamOutput(recordWriterDelegate.getRecordWriter(i), outEdge, chainedConfigs.get(outEdge.getSourceId()), containingTask.getEnvironment());
                this.streamOutputs[i] = streamOutput;
                streamOutputMap.put(outEdge, streamOutput);
            }
            ArrayList allOpWrappers = new ArrayList(chainedConfigs.size());
            this.chainEntryPoint = this.createOutputCollector(containingTask, configuration, chainedConfigs, userCodeClassloader, streamOutputMap, allOpWrappers, containingTask.getMailboxExecutorFactory());
            if (operatorFactory != null) {
                WatermarkGaugeExposingOutput<StreamRecord<OUT>> output = this.getChainEntryPoint();
                Tuple2 headOperatorAndTimeService = StreamOperatorFactoryUtil.createOperator(operatorFactory, containingTask, configuration, output, this.operatorEventDispatcher);
                StreamOperator headOperator = (StreamOperator)headOperatorAndTimeService.f0;
                headOperator.getMetricGroup().gauge("currentOutputWatermark", output.getWatermarkGauge());
                this.headOperatorWrapper = this.createOperatorWrapper(headOperator, containingTask, configuration, (Optional)headOperatorAndTimeService.f1);
                allOpWrappers.add(this.headOperatorWrapper);
                this.tailOperatorWrapper = (StreamOperatorWrapper)allOpWrappers.get(0);
            } else {
                Preconditions.checkState((allOpWrappers.size() == 0 ? 1 : 0) != 0);
                this.headOperatorWrapper = null;
                this.tailOperatorWrapper = null;
            }
            this.numOperators = allOpWrappers.size();
            this.linkOperatorWrappers(allOpWrappers);
            success = true;
        }
        finally {
            if (!success) {
                for (RecordWriterOutput<?> output : this.streamOutputs) {
                    if (output == null) continue;
                    output.close();
                }
            }
        }
    }

    @VisibleForTesting
    OperatorChain(List<StreamOperatorWrapper<?, ?>> allOperatorWrappers, RecordWriterOutput<?>[] streamOutputs, WatermarkGaugeExposingOutput<StreamRecord<OUT>> chainEntryPoint, StreamOperatorWrapper<OUT, OP> headOperatorWrapper) {
        this.streamOutputs = (RecordWriterOutput[])Preconditions.checkNotNull(streamOutputs);
        this.chainEntryPoint = (WatermarkGaugeExposingOutput)Preconditions.checkNotNull(chainEntryPoint);
        this.operatorEventDispatcher = null;
        Preconditions.checkState((allOperatorWrappers != null && allOperatorWrappers.size() > 0 ? 1 : 0) != 0);
        this.headOperatorWrapper = (StreamOperatorWrapper)Preconditions.checkNotNull(headOperatorWrapper);
        this.tailOperatorWrapper = allOperatorWrappers.get(0);
        this.numOperators = allOperatorWrappers.size();
        this.linkOperatorWrappers(allOperatorWrappers);
    }

    @Override
    public StreamStatus getStreamStatus() {
        return this.streamStatus;
    }

    public OperatorEventDispatcher getOperatorEventDispatcher() {
        return this.operatorEventDispatcher;
    }

    public void dispatchOperatorEvent(OperatorID operator, SerializedValue<OperatorEvent> event) throws FlinkException {
        this.operatorEventDispatcher.dispatchEventToHandlers(operator, event);
    }

    @Override
    public void toggleStreamStatus(StreamStatus status) {
        if (!status.equals(this.streamStatus)) {
            this.streamStatus = status;
            for (RecordWriterOutput<?> streamOutput : this.streamOutputs) {
                streamOutput.emitStreamStatus(status);
            }
        }
    }

    public void broadcastEvent(AbstractEvent event) throws IOException {
        this.broadcastEvent(event, false);
    }

    public void broadcastEvent(AbstractEvent event, boolean isPriorityEvent) throws IOException {
        for (RecordWriterOutput<?> streamOutput : this.streamOutputs) {
            streamOutput.broadcastEvent(event, isPriorityEvent);
        }
    }

    public void prepareSnapshotPreBarrier(long checkpointId) throws Exception {
        for (StreamOperatorWrapper<?, ?> operatorWrapper : this.getAllOperators()) {
            if (operatorWrapper.isClosed()) continue;
            operatorWrapper.getStreamOperator().prepareSnapshotPreBarrier(checkpointId);
        }
    }

    public void endHeadOperatorInput(int inputId) throws Exception {
        if (this.headOperatorWrapper != null) {
            this.headOperatorWrapper.endOperatorInput(inputId);
        }
    }

    protected void initializeStateAndOpenOperators(StreamTaskStateInitializer streamTaskStateInitializer) throws Exception {
        for (StreamOperatorWrapper<?, ?> operatorWrapper : this.getAllOperators(true)) {
            Object operator = operatorWrapper.getStreamOperator();
            operator.initializeState(streamTaskStateInitializer);
            operator.open();
        }
    }

    protected void closeOperators(StreamTaskActionExecutor actionExecutor) throws Exception {
        if (this.headOperatorWrapper != null) {
            this.headOperatorWrapper.close(actionExecutor);
        }
    }

    public RecordWriterOutput<?>[] getStreamOutputs() {
        return this.streamOutputs;
    }

    public Iterable<StreamOperatorWrapper<?, ?>> getAllOperators() {
        return this.getAllOperators(false);
    }

    public Iterable<StreamOperatorWrapper<?, ?>> getAllOperators(boolean reverse) {
        return reverse ? new StreamOperatorWrapper.ReadIterator(this.tailOperatorWrapper, true) : new StreamOperatorWrapper.ReadIterator(this.headOperatorWrapper, false);
    }

    public int getNumberOfOperators() {
        return this.numOperators;
    }

    public WatermarkGaugeExposingOutput<StreamRecord<OUT>> getChainEntryPoint() {
        return this.chainEntryPoint;
    }

    public void flushOutputs() throws IOException {
        for (RecordWriterOutput<?> streamOutput : this.getStreamOutputs()) {
            streamOutput.flush();
        }
    }

    public void releaseOutputs() {
        for (RecordWriterOutput<?> streamOutput : this.streamOutputs) {
            streamOutput.close();
        }
    }

    @Nullable
    public OP getHeadOperator() {
        return this.headOperatorWrapper == null ? null : (OP)this.headOperatorWrapper.getStreamOperator();
    }

    private <T> WatermarkGaugeExposingOutput<StreamRecord<T>> createOutputCollector(StreamTask<?, ?> containingTask, StreamConfig operatorConfig, Map<Integer, StreamConfig> chainedConfigs, ClassLoader userCodeClassloader, Map<StreamEdge, RecordWriterOutput<?>> streamOutputs, List<StreamOperatorWrapper<?, ?>> allOperatorWrappers, MailboxExecutorFactory mailboxExecutorFactory) {
        ArrayList<Tuple2> allOutputs = new ArrayList<Tuple2>(4);
        for (StreamEdge outputEdge : operatorConfig.getNonChainedOutputs(userCodeClassloader)) {
            RecordWriterOutput<?> output = streamOutputs.get(outputEdge);
            allOutputs.add(new Tuple2(output, (Object)outputEdge));
        }
        for (StreamEdge outputEdge : operatorConfig.getChainedOutputs(userCodeClassloader)) {
            int outputId = outputEdge.getTargetId();
            StreamConfig chainedOpConfig = chainedConfigs.get(outputId);
            WatermarkGaugeExposingOutput output = this.createChainedOperator(containingTask, chainedOpConfig, chainedConfigs, userCodeClassloader, streamOutputs, allOperatorWrappers, outputEdge.getOutputTag(), mailboxExecutorFactory);
            allOutputs.add(new Tuple2(output, (Object)outputEdge));
        }
        List selectors = operatorConfig.getOutputSelectors(userCodeClassloader);
        if (selectors == null || selectors.isEmpty()) {
            if (allOutputs.size() == 1) {
                return (WatermarkGaugeExposingOutput)((Tuple2)allOutputs.get((int)0)).f0;
            }
            Output[] asArray = new Output[allOutputs.size()];
            for (int i = 0; i < allOutputs.size(); ++i) {
                asArray[i] = (Output)((Tuple2)allOutputs.get((int)i)).f0;
            }
            if (containingTask.getExecutionConfig().isObjectReuseEnabled()) {
                return new CopyingBroadcastingOutputCollector(asArray, this);
            }
            return new BroadcastingOutputCollector(asArray, this);
        }
        if (containingTask.getExecutionConfig().isObjectReuseEnabled()) {
            return new CopyingDirectedOutput(selectors, allOutputs);
        }
        return new DirectedOutput(selectors, allOutputs);
    }

    private <IN, OUT> WatermarkGaugeExposingOutput<StreamRecord<IN>> createChainedOperator(StreamTask<OUT, ?> containingTask, StreamConfig operatorConfig, Map<Integer, StreamConfig> chainedConfigs, ClassLoader userCodeClassloader, Map<StreamEdge, RecordWriterOutput<?>> streamOutputs, List<StreamOperatorWrapper<?, ?>> allOperatorWrappers, OutputTag<IN> outputTag, MailboxExecutorFactory mailboxExecutorFactory) {
        ChainingOutput<IN> currentOperatorOutput;
        WatermarkGaugeExposingOutput chainedOperatorOutput = this.createOutputCollector(containingTask, operatorConfig, chainedConfigs, userCodeClassloader, streamOutputs, allOperatorWrappers, mailboxExecutorFactory);
        Tuple2 chainedOperatorAndTimeService = StreamOperatorFactoryUtil.createOperator(operatorConfig.getStreamOperatorFactory(userCodeClassloader), containingTask, operatorConfig, chainedOperatorOutput, this.operatorEventDispatcher);
        OneInputStreamOperator chainedOperator = (OneInputStreamOperator)chainedOperatorAndTimeService.f0;
        allOperatorWrappers.add(this.createOperatorWrapper(chainedOperator, containingTask, operatorConfig, (Optional)chainedOperatorAndTimeService.f1));
        if (containingTask.getExecutionConfig().isObjectReuseEnabled()) {
            currentOperatorOutput = new ChainingOutput<IN>(chainedOperator, this, outputTag);
        } else {
            TypeSerializer inSerializer = operatorConfig.getTypeSerializerIn1(userCodeClassloader);
            currentOperatorOutput = new CopyingChainingOutput<IN>(chainedOperator, inSerializer, outputTag, this);
        }
        chainedOperator.getMetricGroup().gauge("currentInputWatermark", () -> currentOperatorOutput.getWatermarkGauge().getValue());
        chainedOperator.getMetricGroup().gauge("currentOutputWatermark", () -> chainedOperatorOutput.getWatermarkGauge().getValue());
        return currentOperatorOutput;
    }

    private RecordWriterOutput<OUT> createStreamOutput(RecordWriter<SerializationDelegate<StreamRecord<OUT>>> recordWriter, StreamEdge edge, StreamConfig upStreamConfig, Environment taskEnvironment) {
        OutputTag sideOutputTag = edge.getOutputTag();
        TypeSerializer outSerializer = null;
        outSerializer = edge.getOutputTag() != null ? upStreamConfig.getTypeSerializerSideOut(edge.getOutputTag(), taskEnvironment.getUserClassLoader()) : upStreamConfig.getTypeSerializerOut(taskEnvironment.getUserClassLoader());
        return new RecordWriterOutput<OUT>(recordWriter, outSerializer, sideOutputTag, this);
    }

    private void linkOperatorWrappers(List<StreamOperatorWrapper<?, ?>> allOperatorWrappers) {
        StreamOperatorWrapper<?, ?> previous = null;
        for (StreamOperatorWrapper<?, ?> current : allOperatorWrappers) {
            if (previous != null) {
                previous.setPrevious(current);
            }
            current.setNext(previous);
            previous = current;
        }
    }

    private <T, P extends StreamOperator<T>> StreamOperatorWrapper<T, P> createOperatorWrapper(P operator, StreamTask<?, ?> containingTask, StreamConfig operatorConfig, Optional<ProcessingTimeService> processingTimeService) {
        return new StreamOperatorWrapper(operator, processingTimeService, containingTask.getMailboxExecutorFactory().createExecutor(operatorConfig.getChainIndex()));
    }

    @Nullable
    StreamOperator<?> getTailOperator() {
        return this.tailOperatorWrapper == null ? null : (StreamOperator<?>)this.tailOperatorWrapper.getStreamOperator();
    }

    static final class CopyingBroadcastingOutputCollector<T>
    extends BroadcastingOutputCollector<T> {
        public CopyingBroadcastingOutputCollector(Output<StreamRecord<T>>[] outputs, StreamStatusProvider streamStatusProvider) {
            super(outputs, streamStatusProvider);
        }

        @Override
        public void collect(StreamRecord<T> record) {
            for (int i = 0; i < this.outputs.length - 1; ++i) {
                Output output = this.outputs[i];
                StreamRecord<T> shallowCopy = record.copy(record.getValue());
                output.collect(shallowCopy);
            }
            if (this.outputs.length > 0) {
                this.outputs[this.outputs.length - 1].collect(record);
            }
        }

        @Override
        public <X> void collect(OutputTag<X> outputTag, StreamRecord<X> record) {
            for (int i = 0; i < this.outputs.length - 1; ++i) {
                Output output = this.outputs[i];
                StreamRecord<X> shallowCopy = record.copy(record.getValue());
                output.collect(outputTag, shallowCopy);
            }
            if (this.outputs.length > 0) {
                this.outputs[this.outputs.length - 1].collect(outputTag, record);
            }
        }
    }

    static class BroadcastingOutputCollector<T>
    implements WatermarkGaugeExposingOutput<StreamRecord<T>> {
        protected final Output<StreamRecord<T>>[] outputs;
        private final Random random = new XORShiftRandom();
        private final StreamStatusProvider streamStatusProvider;
        private final WatermarkGauge watermarkGauge = new WatermarkGauge();

        public BroadcastingOutputCollector(Output<StreamRecord<T>>[] outputs, StreamStatusProvider streamStatusProvider) {
            this.outputs = outputs;
            this.streamStatusProvider = streamStatusProvider;
        }

        @Override
        public void emitWatermark(Watermark mark) {
            this.watermarkGauge.setCurrentWatermark(mark.getTimestamp());
            if (this.streamStatusProvider.getStreamStatus().isActive()) {
                for (Output<StreamRecord<T>> output : this.outputs) {
                    output.emitWatermark(mark);
                }
            }
        }

        @Override
        public void emitLatencyMarker(LatencyMarker latencyMarker) {
            if (this.outputs.length > 0) {
                if (this.outputs.length == 1) {
                    this.outputs[0].emitLatencyMarker(latencyMarker);
                } else {
                    this.outputs[this.random.nextInt(this.outputs.length)].emitLatencyMarker(latencyMarker);
                }
            }
        }

        @Override
        public Gauge<Long> getWatermarkGauge() {
            return this.watermarkGauge;
        }

        public void collect(StreamRecord<T> record) {
            for (Output<StreamRecord<T>> output : this.outputs) {
                output.collect(record);
            }
        }

        @Override
        public <X> void collect(OutputTag<X> outputTag, StreamRecord<X> record) {
            for (Output<StreamRecord<T>> output : this.outputs) {
                output.collect(outputTag, record);
            }
        }

        public void close() {
            for (Output<StreamRecord<T>> output : this.outputs) {
                output.close();
            }
        }
    }

    static final class CopyingChainingOutput<T>
    extends ChainingOutput<T> {
        private final TypeSerializer<T> serializer;

        public CopyingChainingOutput(OneInputStreamOperator<T, ?> operator, TypeSerializer<T> serializer, OutputTag<T> outputTag, StreamStatusProvider streamStatusProvider) {
            super(operator, streamStatusProvider, outputTag);
            this.serializer = serializer;
        }

        @Override
        public void collect(StreamRecord<T> record) {
            if (this.outputTag != null) {
                return;
            }
            this.pushToOperator(record);
        }

        @Override
        public <X> void collect(OutputTag<X> outputTag, StreamRecord<X> record) {
            if (this.outputTag == null || !this.outputTag.equals(outputTag)) {
                return;
            }
            this.pushToOperator(record);
        }

        @Override
        protected <X> void pushToOperator(StreamRecord<X> record) {
            try {
                StreamRecord<X> castRecord = record;
                this.numRecordsIn.inc();
                StreamRecord<Object> copy = castRecord.copy(this.serializer.copy(castRecord.getValue()));
                this.operator.setKeyContextElement1(copy);
                this.operator.processElement(copy);
            }
            catch (ClassCastException e) {
                if (this.outputTag != null) {
                    ClassCastException replace = new ClassCastException(String.format("%s. Failed to push OutputTag with id '%s' to operator. This can occur when multiple OutputTags with different types but identical names are being used.", e.getMessage(), this.outputTag.getId()));
                    throw new ExceptionInChainedOperatorException(replace);
                }
                throw new ExceptionInChainedOperatorException(e);
            }
            catch (Exception e) {
                throw new ExceptionInChainedOperatorException(e);
            }
        }
    }

    static class ChainingOutput<T>
    implements WatermarkGaugeExposingOutput<StreamRecord<T>> {
        protected final OneInputStreamOperator<T, ?> operator;
        protected final Counter numRecordsIn;
        protected final WatermarkGauge watermarkGauge = new WatermarkGauge();
        protected final StreamStatusProvider streamStatusProvider;
        @Nullable
        protected final OutputTag<T> outputTag;

        public ChainingOutput(OneInputStreamOperator<T, ?> operator, StreamStatusProvider streamStatusProvider, @Nullable OutputTag<T> outputTag) {
            Counter tmpNumRecordsIn;
            this.operator = operator;
            try {
                OperatorIOMetricGroup ioMetricGroup = ((OperatorMetricGroup)operator.getMetricGroup()).getIOMetricGroup();
                tmpNumRecordsIn = ioMetricGroup.getNumRecordsInCounter();
            }
            catch (Exception e) {
                LOG.warn("An exception occurred during the metrics setup.", (Throwable)e);
                tmpNumRecordsIn = new SimpleCounter();
            }
            this.numRecordsIn = tmpNumRecordsIn;
            this.streamStatusProvider = streamStatusProvider;
            this.outputTag = outputTag;
        }

        public void collect(StreamRecord<T> record) {
            if (this.outputTag != null) {
                return;
            }
            this.pushToOperator(record);
        }

        @Override
        public <X> void collect(OutputTag<X> outputTag, StreamRecord<X> record) {
            if (this.outputTag == null || !this.outputTag.equals(outputTag)) {
                return;
            }
            this.pushToOperator(record);
        }

        protected <X> void pushToOperator(StreamRecord<X> record) {
            try {
                StreamRecord<X> castRecord = record;
                this.numRecordsIn.inc();
                this.operator.setKeyContextElement1(castRecord);
                this.operator.processElement(castRecord);
            }
            catch (Exception e) {
                throw new ExceptionInChainedOperatorException(e);
            }
        }

        @Override
        public void emitWatermark(Watermark mark) {
            try {
                this.watermarkGauge.setCurrentWatermark(mark.getTimestamp());
                if (this.streamStatusProvider.getStreamStatus().isActive()) {
                    this.operator.processWatermark(mark);
                }
            }
            catch (Exception e) {
                throw new ExceptionInChainedOperatorException(e);
            }
        }

        @Override
        public void emitLatencyMarker(LatencyMarker latencyMarker) {
            try {
                this.operator.processLatencyMarker(latencyMarker);
            }
            catch (Exception e) {
                throw new ExceptionInChainedOperatorException(e);
            }
        }

        public void close() {
            try {
                this.operator.close();
            }
            catch (Exception e) {
                throw new ExceptionInChainedOperatorException(e);
            }
        }

        @Override
        public Gauge<Long> getWatermarkGauge() {
            return this.watermarkGauge;
        }
    }

    public static interface WatermarkGaugeExposingOutput<T>
    extends Output<T> {
        public Gauge<Long> getWatermarkGauge();
    }
}

