/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.source.ExternallyInducedSourceReader;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.SourceOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.io.AbstractDataOutput;
import org.apache.flink.streaming.runtime.io.StreamOneInputProcessor;
import org.apache.flink.streaming.runtime.io.StreamTaskExternallyInducedSourceInput;
import org.apache.flink.streaming.runtime.io.StreamTaskSourceInput;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatusMaintainer;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.util.Preconditions;

@Internal
public class SourceOperatorStreamTask<T>
extends StreamTask<T, SourceOperator<T, ?>> {
    private AsyncDataOutputToOutput<T> output;
    private boolean isExternallyInducedSource;

    public SourceOperatorStreamTask(Environment env) throws Exception {
        super(env);
    }

    @Override
    protected CompletableFuture<Void> getCompletionFuture() {
        return super.getCompletionFuture();
    }

    @Override
    public void init() throws Exception {
        StreamTaskSourceInput input;
        SourceOperator sourceOperator = (SourceOperator)this.headOperator;
        sourceOperator.initReader();
        SourceReader sourceReader = ((SourceOperator)this.headOperator).getSourceReader();
        if (sourceReader instanceof ExternallyInducedSourceReader) {
            this.isExternallyInducedSource = true;
            input = new StreamTaskExternallyInducedSourceInput(sourceOperator, this::triggerCheckpointForExternallyInducedSource);
        } else {
            input = new StreamTaskSourceInput(sourceOperator);
        }
        this.output = new AsyncDataOutputToOutput(this.operatorChain.getChainEntryPoint(), this.getStreamStatusMaintainer());
        this.inputProcessor = new StreamOneInputProcessor(input, this.output, this.operatorChain);
    }

    @Override
    public Future<Boolean> triggerCheckpointAsync(CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions, boolean advanceToEndOfEventTime) {
        if (!this.isExternallyInducedSource) {
            return super.triggerCheckpointAsync(checkpointMetaData, checkpointOptions, advanceToEndOfEventTime);
        }
        return CompletableFuture.completedFuture(this.isRunning());
    }

    @Override
    protected void advanceToEndOfEventTime() {
        this.output.emitWatermark(Watermark.MAX_WATERMARK);
    }

    @Override
    protected void afterInvoke() throws Exception {
        if (!this.isCanceled()) {
            this.advanceToEndOfEventTime();
        }
        super.afterInvoke();
    }

    private void triggerCheckpointForExternallyInducedSource(long checkpointId) {
        CheckpointOptions checkpointOptions = CheckpointOptions.forCheckpointWithDefaultLocation((boolean)this.configuration.isExactlyOnceCheckpointMode(), (boolean)this.configuration.isUnalignedCheckpointsEnabled());
        long timestamp = System.currentTimeMillis();
        CheckpointMetaData checkpointMetaData = new CheckpointMetaData(checkpointId, timestamp);
        super.triggerCheckpointAsync(checkpointMetaData, checkpointOptions, false);
    }

    private static class AsyncDataOutputToOutput<T>
    extends AbstractDataOutput<T> {
        private final Output<StreamRecord<T>> output;

        AsyncDataOutputToOutput(Output<StreamRecord<T>> output, StreamStatusMaintainer streamStatusMaintainer) {
            super(streamStatusMaintainer);
            this.output = (Output)Preconditions.checkNotNull(output);
        }

        @Override
        public void emitRecord(StreamRecord<T> streamRecord) {
            this.output.collect(streamRecord);
        }

        @Override
        public void emitLatencyMarker(LatencyMarker latencyMarker) {
            this.output.emitLatencyMarker(latencyMarker);
        }

        @Override
        public void emitWatermark(Watermark watermark) {
            this.output.emitWatermark(watermark);
        }
    }
}

