/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.channel;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateByteBuffer;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateReader;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateSerializer;
import org.apache.flink.runtime.checkpoint.channel.RefCountingFSDataInputStream;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.state.AbstractChannelStateHandle;
import org.apache.flink.util.Preconditions;

@NotThreadSafe
class ChannelStateStreamReader
implements Closeable {
    private final RefCountingFSDataInputStream stream;
    private final ChannelStateSerializer serializer;
    private final Queue<Long> offsets;
    private int remainingBytes = -1;
    private boolean closed = false;

    ChannelStateStreamReader(AbstractChannelStateHandle<?> handle, RefCountingFSDataInputStream.RefCountingFSDataInputStreamFactory streamFactory) {
        this(streamFactory.getOrCreate(handle), handle.getOffsets(), streamFactory.getSerializer());
    }

    private ChannelStateStreamReader(RefCountingFSDataInputStream stream, List<Long> offsets, ChannelStateSerializer serializer) {
        this.stream = stream;
        this.stream.incRef();
        this.serializer = serializer;
        this.offsets = new LinkedList<Long>(offsets);
    }

    ChannelStateReader.ReadResult readInto(Buffer buffer) throws IOException {
        return this.readInto(ChannelStateByteBuffer.wrap(buffer));
    }

    ChannelStateReader.ReadResult readInto(BufferBuilder bufferBuilder) throws IOException {
        return this.readInto(ChannelStateByteBuffer.wrap(bufferBuilder));
    }

    private ChannelStateReader.ReadResult readInto(ChannelStateByteBuffer buffer) throws IOException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"reader is closed");
        this.readWhilePossible(buffer);
        if (this.haveMoreData()) {
            return ChannelStateReader.ReadResult.HAS_MORE_DATA;
        }
        this.closed = true;
        this.stream.decRef();
        return ChannelStateReader.ReadResult.NO_MORE_DATA;
    }

    private void readWhilePossible(ChannelStateByteBuffer buffer) throws IOException {
        while (this.haveMoreData() && buffer.isWritable()) {
            if (this.remainingBytes <= 0) {
                this.advanceOffset();
            }
            int bytesRead = this.serializer.readData((InputStream)((Object)this.stream), buffer, this.remainingBytes);
            this.remainingBytes -= bytesRead;
        }
    }

    private boolean haveMoreData() {
        return this.remainingBytes > 0 || !this.offsets.isEmpty();
    }

    private void advanceOffset() throws IOException {
        this.stream.seek(this.offsets.poll());
        this.remainingBytes = this.serializer.readLength((InputStream)((Object)this.stream));
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.stream.close();
        }
    }
}

