/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.nio.ByteBuffer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufAllocator;

public interface Buffer {
    public boolean isBuffer();

    @Deprecated
    public MemorySegment getMemorySegment();

    @Deprecated
    public int getMemorySegmentOffset();

    public BufferRecycler getRecycler();

    public void recycleBuffer();

    public boolean isRecycled();

    public Buffer retainBuffer();

    public Buffer readOnlySlice();

    public Buffer readOnlySlice(int var1, int var2);

    public int getMaxCapacity();

    public int getReaderIndex();

    public void setReaderIndex(int var1) throws IndexOutOfBoundsException;

    public int getSize();

    public void setSize(int var1);

    public int readableBytes();

    public ByteBuffer getNioBufferReadable();

    public ByteBuffer getNioBuffer(int var1, int var2) throws IndexOutOfBoundsException;

    public void setAllocator(ByteBufAllocator var1);

    public ByteBuf asByteBuf();

    public boolean isCompressed();

    public void setCompressed(boolean var1);

    public DataType getDataType();

    public void setDataType(DataType var1);

    public static enum DataType {
        DATA_BUFFER(true, false),
        EVENT_BUFFER(false, false),
        ALIGNED_EXACTLY_ONCE_CHECKPOINT_BARRIER(false, true);

        private final boolean isBuffer;
        private final boolean isBlockingUpstream;

        private DataType(boolean isBuffer, boolean isBlockingUpstream) {
            this.isBuffer = isBuffer;
            this.isBlockingUpstream = isBlockingUpstream;
        }

        public boolean isBuffer() {
            return this.isBuffer;
        }

        public boolean isBlockingUpstream() {
            return this.isBlockingUpstream;
        }

        public static DataType getDataType(AbstractEvent event) {
            return event instanceof CheckpointBarrier && ((CheckpointBarrier)event).getCheckpointOptions().needsAlignment() ? ALIGNED_EXACTLY_ONCE_CHECKPOINT_BARRIER : EVENT_BUFFER;
        }
    }
}

