/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateReader;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.buffer.BufferReceivedListener;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.IndexedInputGate;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.shaded.guava18.com.google.common.collect.Sets;
import org.apache.flink.util.Preconditions;

public class UnionInputGate
extends InputGate {
    private final Map<Integer, InputGate> inputGatesByGateIndex;
    private final Set<IndexedInputGate> inputGatesWithRemainingData;
    private final LinkedHashSet<IndexedInputGate> inputGatesWithData = new LinkedHashSet();
    private final int[] inputChannelToInputGateIndex;
    private final int[] inputGateChannelIndexOffsets;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnionInputGate(IndexedInputGate ... inputGates) {
        this.inputGatesByGateIndex = Arrays.stream(inputGates).collect(Collectors.toMap(IndexedInputGate::getGateIndex, ig -> ig));
        Preconditions.checkArgument((inputGates.length > 1 ? 1 : 0) != 0, (Object)"Union input gate should union at least two input gates.");
        if (Arrays.stream(inputGates).map(IndexedInputGate::getGateIndex).distinct().count() != (long)inputGates.length) {
            throw new IllegalArgumentException("Union of two input gates with the same gate index. Given indices: " + Arrays.stream(inputGates).map(IndexedInputGate::getGateIndex).collect(Collectors.toList()));
        }
        this.inputGatesWithRemainingData = Sets.newHashSetWithExpectedSize((int)inputGates.length);
        int maxGateIndex = Arrays.stream(inputGates).mapToInt(IndexedInputGate::getGateIndex).max().orElse(0);
        int totalNumberOfInputChannels = Arrays.stream(inputGates).mapToInt(InputGate::getNumberOfInputChannels).sum();
        this.inputGateChannelIndexOffsets = new int[maxGateIndex + 1];
        this.inputChannelToInputGateIndex = new int[totalNumberOfInputChannels];
        int currentNumberOfInputChannels = 0;
        for (IndexedInputGate inputGate : inputGates) {
            this.inputGateChannelIndexOffsets[inputGate.getGateIndex()] = currentNumberOfInputChannels;
            int previousNumberOfInputChannels = currentNumberOfInputChannels;
            Arrays.fill(this.inputChannelToInputGateIndex, previousNumberOfInputChannels, currentNumberOfInputChannels += inputGate.getNumberOfInputChannels(), inputGate.getGateIndex());
        }
        LinkedHashSet<IndexedInputGate> linkedHashSet = this.inputGatesWithData;
        synchronized (linkedHashSet) {
            for (IndexedInputGate inputGate : inputGates) {
                this.inputGatesWithRemainingData.add(inputGate);
                CompletableFuture<?> available = inputGate.getAvailableFuture();
                if (available.isDone()) {
                    this.inputGatesWithData.add(inputGate);
                    continue;
                }
                available.thenRun(() -> this.queueInputGate(inputGate));
            }
            if (!this.inputGatesWithData.isEmpty()) {
                this.availabilityHelper.resetAvailable();
            }
        }
    }

    @Override
    public int getNumberOfInputChannels() {
        return this.inputChannelToInputGateIndex.length;
    }

    @Override
    public InputChannel getChannel(int channelIndex) {
        int gateIndex = this.inputChannelToInputGateIndex[channelIndex];
        return this.inputGatesByGateIndex.get(gateIndex).getChannel(channelIndex - this.inputGateChannelIndexOffsets[gateIndex]);
    }

    @Override
    public boolean isFinished() {
        return this.inputGatesWithRemainingData.isEmpty();
    }

    @Override
    public Optional<BufferOrEvent> getNext() throws IOException, InterruptedException {
        return this.getNextBufferOrEvent(true);
    }

    @Override
    public Optional<BufferOrEvent> pollNext() throws IOException, InterruptedException {
        return this.getNextBufferOrEvent(false);
    }

    private Optional<BufferOrEvent> getNextBufferOrEvent(boolean blocking) throws IOException, InterruptedException {
        if (this.inputGatesWithRemainingData.isEmpty()) {
            return Optional.empty();
        }
        Optional<InputGate.InputWithData<IndexedInputGate, BufferOrEvent>> next = this.waitAndGetNextData(blocking);
        if (!next.isPresent()) {
            return Optional.empty();
        }
        InputGate.InputWithData<IndexedInputGate, BufferOrEvent> inputWithData = next.get();
        this.handleEndOfPartitionEvent((BufferOrEvent)inputWithData.data, (InputGate)inputWithData.input);
        if (!((BufferOrEvent)inputWithData.data).moreAvailable()) {
            ((BufferOrEvent)inputWithData.data).setMoreAvailable(inputWithData.moreAvailable);
        }
        return Optional.of(inputWithData.data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<InputGate.InputWithData<IndexedInputGate, BufferOrEvent>> waitAndGetNextData(boolean blocking) throws IOException, InterruptedException {
        Optional<IndexedInputGate> inputGate;
        while ((inputGate = this.getInputGate(blocking)).isPresent()) {
            Optional<BufferOrEvent> bufferOrEvent = inputGate.get().pollNext();
            LinkedHashSet<IndexedInputGate> linkedHashSet = this.inputGatesWithData;
            synchronized (linkedHashSet) {
                if (bufferOrEvent.isPresent() && bufferOrEvent.get().moreAvailable()) {
                    this.inputGatesWithData.add(inputGate.get());
                } else if (!inputGate.get().isFinished()) {
                    inputGate.get().getAvailableFuture().thenRun(() -> this.queueInputGate((IndexedInputGate)inputGate.get()));
                }
                if (this.inputGatesWithData.isEmpty()) {
                    this.availabilityHelper.resetUnavailable();
                }
                if (bufferOrEvent.isPresent()) {
                    return Optional.of(new InputGate.InputWithData<IndexedInputGate, BufferOrEvent>(inputGate.get(), bufferOrEvent.get(), !this.inputGatesWithData.isEmpty()));
                }
            }
        }
        return Optional.empty();
    }

    private void handleEndOfPartitionEvent(BufferOrEvent bufferOrEvent, InputGate inputGate) {
        if (bufferOrEvent.isEvent() && bufferOrEvent.getEvent().getClass() == EndOfPartitionEvent.class && inputGate.isFinished()) {
            Preconditions.checkState((!bufferOrEvent.moreAvailable() ? 1 : 0) != 0);
            if (!this.inputGatesWithRemainingData.remove(inputGate)) {
                throw new IllegalStateException("Couldn't find input gate in set of remaining input gates.");
            }
            if (this.isFinished()) {
                this.markAvailable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markAvailable() {
        CompletableFuture<?> toNotify;
        LinkedHashSet<IndexedInputGate> linkedHashSet = this.inputGatesWithData;
        synchronized (linkedHashSet) {
            toNotify = this.availabilityHelper.getUnavailableToResetAvailable();
        }
        toNotify.complete(null);
    }

    @Override
    public void sendTaskEvent(TaskEvent event) throws IOException {
        for (InputGate inputGate : this.inputGatesByGateIndex.values()) {
            inputGate.sendTaskEvent(event);
        }
    }

    @Override
    public void resumeConsumption(int channelIndex) throws IOException {
        this.getChannel(channelIndex).resumeConsumption();
    }

    @Override
    public void setup() {
    }

    @Override
    public CompletableFuture<?> readRecoveredState(ExecutorService executor, ChannelStateReader reader) {
        throw new UnsupportedOperationException("This method should never be called.");
    }

    @Override
    public void requestPartitions() throws IOException {
        for (InputGate inputGate : this.inputGatesByGateIndex.values()) {
            inputGate.requestPartitions();
        }
    }

    @Override
    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueInputGate(IndexedInputGate inputGate) {
        Preconditions.checkNotNull((Object)inputGate);
        CompletableFuture<?> toNotify = null;
        LinkedHashSet<IndexedInputGate> linkedHashSet = this.inputGatesWithData;
        synchronized (linkedHashSet) {
            if (this.inputGatesWithData.contains(inputGate)) {
                return;
            }
            int availableInputGates = this.inputGatesWithData.size();
            this.inputGatesWithData.add(inputGate);
            if (availableInputGates == 0) {
                this.inputGatesWithData.notifyAll();
                toNotify = this.availabilityHelper.getUnavailableToResetAvailable();
            }
        }
        if (toNotify != null) {
            toNotify.complete(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<IndexedInputGate> getInputGate(boolean blocking) throws InterruptedException {
        LinkedHashSet<IndexedInputGate> linkedHashSet = this.inputGatesWithData;
        synchronized (linkedHashSet) {
            while (this.inputGatesWithData.size() == 0) {
                if (blocking) {
                    this.inputGatesWithData.wait();
                    continue;
                }
                this.availabilityHelper.resetUnavailable();
                return Optional.empty();
            }
            Iterator inputGateIterator = this.inputGatesWithData.iterator();
            IndexedInputGate inputGate = (IndexedInputGate)inputGateIterator.next();
            inputGateIterator.remove();
            return Optional.of(inputGate);
        }
    }

    @Override
    public void registerBufferReceivedListener(BufferReceivedListener listener) {
        for (InputGate inputGate : this.inputGatesByGateIndex.values()) {
            inputGate.registerBufferReceivedListener(listener);
        }
    }
}

