/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.coordination;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.SerializedValue;

final class OperatorEventValve {
    private static final long NO_CHECKPOINT = Long.MIN_VALUE;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final BiFunction<SerializedValue<OperatorEvent>, Integer, CompletableFuture<Acknowledge>> eventSender;
    @GuardedBy(value="lock")
    private final Map<Integer, List<BlockedEvent>> blockedEvents = new LinkedHashMap<Integer, List<BlockedEvent>>();
    @GuardedBy(value="lock")
    private long currentCheckpointId;
    @GuardedBy(value="lock")
    private long lastCheckpointId;
    @GuardedBy(value="lock")
    private boolean shut;

    public OperatorEventValve(BiFunction<SerializedValue<OperatorEvent>, Integer, CompletableFuture<Acknowledge>> eventSender) {
        this.eventSender = eventSender;
        this.currentCheckpointId = Long.MIN_VALUE;
        this.lastCheckpointId = Long.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShut() {
        Object object = this.lock;
        synchronized (object) {
            return this.shut;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Acknowledge> sendEvent(SerializedValue<OperatorEvent> event, int subtask) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.shut) {
                return this.eventSender.apply(event, subtask);
            }
            List eventsForTask = this.blockedEvents.computeIfAbsent(subtask, key -> new ArrayList());
            CompletableFuture<Acknowledge> future = new CompletableFuture<Acknowledge>();
            eventsForTask.add(new BlockedEvent(event, subtask, future));
            return future;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markForCheckpoint(long checkpointId) {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentCheckpointId != Long.MIN_VALUE && this.currentCheckpointId != checkpointId) {
                throw new IllegalStateException(String.format("Cannot mark for checkpoint %d, already marked for checkpoint %d", checkpointId, this.currentCheckpointId));
            }
            if (checkpointId <= this.lastCheckpointId) {
                throw new IllegalStateException(String.format("Regressing checkpoint IDs. Previous checkpointId = %d, new checkpointId = %d", this.lastCheckpointId, checkpointId));
            }
            this.currentCheckpointId = checkpointId;
            this.lastCheckpointId = checkpointId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutValve(long checkpointId) {
        Object object = this.lock;
        synchronized (object) {
            if (checkpointId != this.currentCheckpointId) {
                throw new IllegalStateException(String.format("Cannot shut valve for non-prepared checkpoint. Prepared checkpoint = %s, attempting-to-close checkpoint = %d", this.currentCheckpointId == Long.MIN_VALUE ? "(none)" : String.valueOf(this.currentCheckpointId), checkpointId));
            }
            this.shut = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openValveAndUnmarkCheckpoint() {
        ArrayList<FuturePair> futures;
        Iterator iterator = this.lock;
        synchronized (iterator) {
            this.currentCheckpointId = Long.MIN_VALUE;
            if (!this.shut) {
                return;
            }
            futures = new ArrayList<FuturePair>(this.blockedEvents.size());
            for (List<BlockedEvent> eventsForTask : this.blockedEvents.values()) {
                for (BlockedEvent blockedEvent : eventsForTask) {
                    CompletableFuture<Acknowledge> ackFuture = this.eventSender.apply(blockedEvent.event, blockedEvent.subtask);
                    futures.add(new FuturePair(blockedEvent.future, ackFuture));
                }
            }
            this.blockedEvents.clear();
            this.shut = false;
        }
        for (FuturePair pair : futures) {
            FutureUtils.forward(pair.ackFuture, pair.originalFuture);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetForTask(int subtask) {
        List<BlockedEvent> events;
        Object object = this.lock;
        synchronized (object) {
            events = this.blockedEvents.remove(subtask);
        }
        OperatorEventValve.failAllFutures(events);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        ArrayList<BlockedEvent> events = new ArrayList<BlockedEvent>();
        Object object = this.lock;
        synchronized (object) {
            for (List<BlockedEvent> taskEvents : this.blockedEvents.values()) {
                if (taskEvents == null) continue;
                events.addAll(taskEvents);
            }
            this.blockedEvents.clear();
            this.shut = false;
            this.currentCheckpointId = Long.MIN_VALUE;
        }
        OperatorEventValve.failAllFutures(events);
    }

    private static void failAllFutures(@Nullable List<BlockedEvent> events) {
        if (events == null || events.isEmpty()) {
            return;
        }
        FlinkException failureCause = new FlinkException("Event discarded due to failure of target task");
        for (BlockedEvent evt : events) {
            evt.future.completeExceptionally(failureCause);
        }
    }

    private static final class FuturePair {
        final CompletableFuture<Acknowledge> originalFuture;
        final CompletableFuture<Acknowledge> ackFuture;

        FuturePair(CompletableFuture<Acknowledge> originalFuture, CompletableFuture<Acknowledge> ackFuture) {
            this.originalFuture = originalFuture;
            this.ackFuture = ackFuture;
        }
    }

    private static final class BlockedEvent {
        final SerializedValue<OperatorEvent> event;
        final CompletableFuture<Acknowledge> future;
        final int subtask;

        BlockedEvent(SerializedValue<OperatorEvent> event, int subtask, CompletableFuture<Acknowledge> future) {
            this.event = event;
            this.future = future;
            this.subtask = subtask;
        }
    }
}

