/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceIDRetrievable;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.io.network.partition.ResourceManagerPartitionTrackerFactory;
import org.apache.flink.runtime.metrics.groups.ResourceManagerMetricGroup;
import org.apache.flink.runtime.resourcemanager.JobLeaderIdService;
import org.apache.flink.runtime.resourcemanager.ResourceManager;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.runtime.resourcemanager.registration.WorkerRegistration;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManager;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;

public abstract class ActiveResourceManager<WorkerType extends ResourceIDRetrievable>
extends ResourceManager<WorkerType> {
    protected final Map<String, String> env;
    protected final Configuration flinkConfig;
    protected final Configuration flinkClientConfig;
    private final PendingWorkerCounter requestedNotAllocatedWorkerCounter;
    private final PendingWorkerCounter requestedNotRegisteredWorkerCounter;
    private final Map<ResourceID, WorkerResourceSpec> allocatedNotRegisteredWorkerResourceSpecs;

    public ActiveResourceManager(Configuration flinkConfig, Map<String, String> env, RpcService rpcService, ResourceID resourceId, HighAvailabilityServices highAvailabilityServices, HeartbeatServices heartbeatServices, SlotManager slotManager, ResourceManagerPartitionTrackerFactory clusterPartitionTrackerFactory, JobLeaderIdService jobLeaderIdService, ClusterInformation clusterInformation, FatalErrorHandler fatalErrorHandler, ResourceManagerMetricGroup resourceManagerMetricGroup) {
        super(rpcService, resourceId, highAvailabilityServices, heartbeatServices, slotManager, clusterPartitionTrackerFactory, jobLeaderIdService, clusterInformation, fatalErrorHandler, resourceManagerMetricGroup, AkkaUtils.getTimeoutAsTime(flinkConfig));
        this.flinkConfig = flinkConfig;
        this.env = env;
        this.flinkClientConfig = this.loadClientConfiguration();
        this.requestedNotAllocatedWorkerCounter = new PendingWorkerCounter();
        this.requestedNotRegisteredWorkerCounter = new PendingWorkerCounter();
        this.allocatedNotRegisteredWorkerResourceSpecs = new HashMap<ResourceID, WorkerResourceSpec>();
    }

    protected CompletableFuture<Void> getStopTerminationFutureOrCompletedExceptionally(@Nullable Throwable exception) {
        CompletableFuture<Void> terminationFuture = super.onStop();
        if (exception != null) {
            return FutureUtils.completedExceptionally(new FlinkException("Error while shutting down resource manager", exception));
        }
        return terminationFuture;
    }

    protected abstract Configuration loadClientConfiguration();

    @Override
    protected void onTaskManagerRegistration(WorkerRegistration<WorkerType> workerTypeWorkerRegistration) {
        this.notifyAllocatedWorkerRegistered(workerTypeWorkerRegistration.getResourceID());
    }

    protected int getNumRequestedNotAllocatedWorkers() {
        return this.requestedNotAllocatedWorkerCounter.getTotalNum();
    }

    protected int getNumRequestedNotAllocatedWorkersFor(WorkerResourceSpec workerResourceSpec) {
        return this.requestedNotAllocatedWorkerCounter.getNum(workerResourceSpec);
    }

    protected int getNumRequestedNotRegisteredWorkers() {
        return this.requestedNotRegisteredWorkerCounter.getTotalNum();
    }

    protected int getNumRequestedNotRegisteredWorkersFor(WorkerResourceSpec workerResourceSpec) {
        return this.requestedNotRegisteredWorkerCounter.getNum(workerResourceSpec);
    }

    protected PendingWorkerNums notifyNewWorkerRequested(WorkerResourceSpec workerResourceSpec) {
        return new PendingWorkerNums(this.requestedNotAllocatedWorkerCounter.increaseAndGet(workerResourceSpec), this.requestedNotRegisteredWorkerCounter.increaseAndGet(workerResourceSpec));
    }

    protected PendingWorkerNums notifyNewWorkerAllocated(WorkerResourceSpec workerResourceSpec, ResourceID resourceID) {
        this.allocatedNotRegisteredWorkerResourceSpecs.put(resourceID, workerResourceSpec);
        return new PendingWorkerNums(this.requestedNotAllocatedWorkerCounter.decreaseAndGet(workerResourceSpec), this.requestedNotRegisteredWorkerCounter.getNum(workerResourceSpec));
    }

    protected PendingWorkerNums notifyNewWorkerAllocationFailed(WorkerResourceSpec workerResourceSpec) {
        return new PendingWorkerNums(this.requestedNotAllocatedWorkerCounter.decreaseAndGet(workerResourceSpec), this.requestedNotRegisteredWorkerCounter.decreaseAndGet(workerResourceSpec));
    }

    private void notifyAllocatedWorkerRegistered(ResourceID resourceID) {
        WorkerResourceSpec workerResourceSpec = this.allocatedNotRegisteredWorkerResourceSpecs.remove(resourceID);
        if (workerResourceSpec == null) {
            return;
        }
        this.requestedNotRegisteredWorkerCounter.decreaseAndGet(workerResourceSpec);
    }

    protected void notifyAllocatedWorkerStopped(ResourceID resourceID) {
        WorkerResourceSpec workerResourceSpec = this.allocatedNotRegisteredWorkerResourceSpecs.remove(resourceID);
        if (workerResourceSpec == null) {
            return;
        }
        this.requestedNotRegisteredWorkerCounter.decreaseAndGet(workerResourceSpec);
    }

    @VisibleForTesting
    static class PendingWorkerCounter {
        private final Map<WorkerResourceSpec, Integer> pendingWorkerNums = new HashMap<WorkerResourceSpec, Integer>();

        PendingWorkerCounter() {
        }

        int getTotalNum() {
            return this.pendingWorkerNums.values().stream().reduce(0, Integer::sum);
        }

        int getNum(WorkerResourceSpec workerResourceSpec) {
            return this.pendingWorkerNums.getOrDefault(Preconditions.checkNotNull((Object)workerResourceSpec), 0);
        }

        int increaseAndGet(WorkerResourceSpec workerResourceSpec) {
            return this.pendingWorkerNums.compute((WorkerResourceSpec)Preconditions.checkNotNull((Object)workerResourceSpec), (ignored, num) -> num != null ? num + 1 : 1);
        }

        int decreaseAndGet(WorkerResourceSpec workerResourceSpec) {
            Integer newValue = this.pendingWorkerNums.compute((WorkerResourceSpec)Preconditions.checkNotNull((Object)workerResourceSpec), (ignored, num) -> {
                Preconditions.checkState((num != null && num > 0 ? 1 : 0) != 0, (String)"Cannot decrease, no pending worker of spec %s.", (Object[])new Object[]{workerResourceSpec});
                return num == 1 ? null : Integer.valueOf(num - 1);
            });
            return newValue != null ? newValue : 0;
        }
    }

    protected static class PendingWorkerNums {
        private final int numNotAllocated;
        private final int numNotRegistered;

        private PendingWorkerNums(int numNotAllocated, int numNotRegistered) {
            this.numNotAllocated = numNotAllocated;
            this.numNotRegistered = numNotRegistered;
        }

        public int getNumNotAllocated() {
            return this.numNotAllocated;
        }

        public int getNumNotRegistered() {
            return this.numNotRegistered;
        }
    }
}

