/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessSpec;
import org.apache.flink.util.Preconditions;

public final class WorkerResourceSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final WorkerResourceSpec ZERO = new Builder().build();
    private final CPUResource cpuCores;
    private final MemorySize taskHeapSize;
    private final MemorySize taskOffHeapSize;
    private final MemorySize networkMemSize;
    private final MemorySize managedMemSize;

    private WorkerResourceSpec(CPUResource cpuCores, MemorySize taskHeapSize, MemorySize taskOffHeapSize, MemorySize networkMemSize, MemorySize managedMemSize) {
        this.cpuCores = (CPUResource)Preconditions.checkNotNull((Object)cpuCores);
        this.taskHeapSize = (MemorySize)Preconditions.checkNotNull((Object)taskHeapSize);
        this.taskOffHeapSize = (MemorySize)Preconditions.checkNotNull((Object)taskOffHeapSize);
        this.networkMemSize = (MemorySize)Preconditions.checkNotNull((Object)networkMemSize);
        this.managedMemSize = (MemorySize)Preconditions.checkNotNull((Object)managedMemSize);
    }

    public static WorkerResourceSpec fromTaskExecutorProcessSpec(TaskExecutorProcessSpec taskExecutorProcessSpec) {
        Preconditions.checkNotNull((Object)taskExecutorProcessSpec);
        return new WorkerResourceSpec(taskExecutorProcessSpec.getCpuCores(), taskExecutorProcessSpec.getTaskHeapSize(), taskExecutorProcessSpec.getTaskOffHeapSize(), taskExecutorProcessSpec.getNetworkMemSize(), taskExecutorProcessSpec.getManagedMemorySize());
    }

    public CPUResource getCpuCores() {
        return this.cpuCores;
    }

    public MemorySize getTaskHeapSize() {
        return this.taskHeapSize;
    }

    public MemorySize getTaskOffHeapSize() {
        return this.taskOffHeapSize;
    }

    public MemorySize getNetworkMemSize() {
        return this.networkMemSize;
    }

    public MemorySize getManagedMemSize() {
        return this.managedMemSize;
    }

    public int hashCode() {
        return Objects.hash(this.cpuCores, this.taskHeapSize, this.taskOffHeapSize, this.networkMemSize, this.managedMemSize);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == WorkerResourceSpec.class) {
            WorkerResourceSpec that = (WorkerResourceSpec)obj;
            return Objects.equals(this.cpuCores, that.cpuCores) && Objects.equals(this.taskHeapSize, that.taskHeapSize) && Objects.equals(this.taskOffHeapSize, that.taskOffHeapSize) && Objects.equals(this.networkMemSize, that.networkMemSize) && Objects.equals(this.managedMemSize, that.managedMemSize);
        }
        return false;
    }

    public String toString() {
        return "WorkerResourceSpec {cpuCores=" + this.cpuCores.getValue().doubleValue() + ", taskHeapSize=" + this.taskHeapSize.toHumanReadableString() + ", taskOffHeapSize=" + this.taskOffHeapSize.toHumanReadableString() + ", networkMemSize=" + this.networkMemSize.toHumanReadableString() + ", managedMemSize=" + this.managedMemSize.toHumanReadableString() + "}";
    }

    public static class Builder {
        private CPUResource cpuCores = new CPUResource(0.0);
        private MemorySize taskHeapSize = MemorySize.ZERO;
        private MemorySize taskOffHeapSize = MemorySize.ZERO;
        private MemorySize networkMemSize = MemorySize.ZERO;
        private MemorySize managedMemSize = MemorySize.ZERO;

        public Builder setCpuCores(double cpuCores) {
            this.cpuCores = new CPUResource(cpuCores);
            return this;
        }

        public Builder setTaskHeapMemoryMB(int taskHeapMemoryMB) {
            this.taskHeapSize = MemorySize.ofMebiBytes((long)taskHeapMemoryMB);
            return this;
        }

        public Builder setTaskOffHeapMemoryMB(int taskOffHeapMemoryMB) {
            this.taskOffHeapSize = MemorySize.ofMebiBytes((long)taskOffHeapMemoryMB);
            return this;
        }

        public Builder setNetworkMemoryMB(int networkMemoryMB) {
            this.networkMemSize = MemorySize.ofMebiBytes((long)networkMemoryMB);
            return this;
        }

        public Builder setManagedMemoryMB(int managedMemoryMB) {
            this.managedMemSize = MemorySize.ofMebiBytes((long)managedMemoryMB);
            return this;
        }

        public WorkerResourceSpec build() {
            return new WorkerResourceSpec(this.cpuCores, this.taskHeapSize, this.taskOffHeapSize, this.networkMemSize, this.managedMemSize);
        }
    }
}

