/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicConfiguration
extends Configuration {
    protected static final Logger LOG = LoggerFactory.getLogger(DynamicConfiguration.class);
    private final Configuration delegate;
    private final Map<String, AppConfigurationEntry[]> dynamicEntries = new HashMap<String, AppConfigurationEntry[]>();

    public DynamicConfiguration(@Nullable Configuration delegate2) {
        this.delegate = delegate2;
    }

    public void addAppConfigurationEntry(String name, AppConfigurationEntry ... entry) {
        AppConfigurationEntry[] existing = this.dynamicEntries.get(name);
        AppConfigurationEntry[] updated = existing == null ? Arrays.copyOf(entry, entry.length) : DynamicConfiguration.merge(existing, entry);
        this.dynamicEntries.put(name, updated);
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        AppConfigurationEntry[] existing;
        AppConfigurationEntry[] entry = null;
        if (this.delegate != null) {
            entry = this.delegate.getAppConfigurationEntry(name);
        }
        if ((existing = this.dynamicEntries.get(name)) != null) {
            entry = entry != null ? DynamicConfiguration.merge(entry, existing) : Arrays.copyOf(existing, existing.length);
        }
        return entry;
    }

    private static AppConfigurationEntry[] merge(AppConfigurationEntry[] a, AppConfigurationEntry[] b) {
        AppConfigurationEntry[] merged = Arrays.copyOf(a, a.length + b.length);
        System.arraycopy(b, 0, merged, a.length, b.length);
        return merged;
    }

    @Override
    public void refresh() {
        if (this.delegate != null) {
            this.delegate.refresh();
        }
    }
}

