/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.File;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.configuration.ClusterOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.util.Hardware;
import org.apache.flink.util.Preconditions;

public final class ClusterEntrypointUtils {
    private ClusterEntrypointUtils() {
        throw new UnsupportedOperationException("This class should not be instantiated.");
    }

    public static Optional<File> tryFindUserLibDirectory() {
        File flinkHomeDirectory = ClusterEntrypointUtils.deriveFlinkHomeDirectoryFromLibDirectory();
        File usrLibDirectory = new File(flinkHomeDirectory, "usrlib");
        if (!usrLibDirectory.isDirectory()) {
            return Optional.empty();
        }
        return Optional.of(usrLibDirectory);
    }

    @Nullable
    private static File deriveFlinkHomeDirectoryFromLibDirectory() {
        String libDirectory = System.getenv().get("FLINK_LIB_DIR");
        if (libDirectory == null) {
            return null;
        }
        return new File(libDirectory).getParentFile();
    }

    public static int getPoolSize(Configuration config) {
        int poolSize = config.getInteger(ClusterOptions.CLUSTER_IO_EXECUTOR_POOL_SIZE, 4 * Hardware.getNumberCPUCores());
        Preconditions.checkArgument((poolSize > 0 ? 1 : 0) != 0, (Object)String.format("Illegal pool size (%s) of io-executor, please re-configure '%s'.", poolSize, ClusterOptions.CLUSTER_IO_EXECUTOR_POOL_SIZE.key()));
        return poolSize;
    }
}

