/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util.bash;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessSpec;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessUtils;
import org.apache.flink.runtime.jobmanager.JobManagerProcessSpec;
import org.apache.flink.runtime.jobmanager.JobManagerProcessUtils;
import org.apache.flink.runtime.util.bash.FlinkConfigLoader;
import org.apache.flink.runtime.util.config.memory.ProcessMemoryUtils;
import org.apache.flink.runtime.util.config.memory.jobmanager.JobManagerFlinkMemory;
import org.apache.flink.runtime.util.config.memory.taskmanager.TaskExecutorFlinkMemory;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BashJavaUtils {
    private static final Logger LOG = LoggerFactory.getLogger(BashJavaUtils.class);
    @VisibleForTesting
    public static final String EXECUTION_PREFIX = "BASH_JAVA_UTILS_EXEC_RESULT:";

    private BashJavaUtils() {
    }

    public static void main(String[] args) throws FlinkException {
        Preconditions.checkArgument((args.length > 0 ? 1 : 0) != 0, (Object)"Command not specified.");
        Command command = Command.valueOf(args[0]);
        String[] commandArgs = Arrays.copyOfRange(args, 1, args.length);
        List<String> output = BashJavaUtils.runCommand(command, commandArgs);
        for (String outputLine : output) {
            System.out.println(EXECUTION_PREFIX + outputLine);
        }
    }

    private static List<String> runCommand(Command command, String[] commandArgs) throws FlinkException {
        Configuration configuration = FlinkConfigLoader.loadConfiguration(commandArgs);
        switch (command) {
            case GET_TM_RESOURCE_PARAMS: {
                return BashJavaUtils.getTmResourceParams(configuration);
            }
            case GET_JM_RESOURCE_PARAMS: {
                return BashJavaUtils.getJmResourceParams(configuration);
            }
        }
        throw new RuntimeException("Unexpected, something is wrong.");
    }

    private static List<String> getTmResourceParams(Configuration configuration) {
        Configuration configurationWithFallback = TaskExecutorProcessUtils.getConfigurationMapLegacyTaskManagerHeapSizeToConfigOption(configuration, (ConfigOption<MemorySize>)TaskManagerOptions.TOTAL_FLINK_MEMORY);
        TaskExecutorProcessSpec taskExecutorProcessSpec = TaskExecutorProcessUtils.processSpecFromConfig(configurationWithFallback);
        BashJavaUtils.logTaskExecutorConfiguration(taskExecutorProcessSpec);
        return Arrays.asList(ProcessMemoryUtils.generateJvmParametersStr(taskExecutorProcessSpec), TaskExecutorProcessUtils.generateDynamicConfigsStr(taskExecutorProcessSpec));
    }

    @VisibleForTesting
    static List<String> getJmResourceParams(Configuration configuration) {
        JobManagerProcessSpec jobManagerProcessSpec = JobManagerProcessUtils.processSpecFromConfigWithNewOptionToInterpretLegacyHeap(configuration, (ConfigOption<MemorySize>)JobManagerOptions.JVM_HEAP_MEMORY);
        BashJavaUtils.logMasterConfiguration(jobManagerProcessSpec);
        return Collections.singletonList(JobManagerProcessUtils.generateJvmParametersStr(jobManagerProcessSpec, configuration));
    }

    private static void logMasterConfiguration(JobManagerProcessSpec spec) {
        JobManagerFlinkMemory flinkMemory = (JobManagerFlinkMemory)spec.getFlinkMemory();
        LOG.info("Final Master Memory configuration:");
        LOG.info("  Total Process Memory: {}", (Object)spec.getTotalProcessMemorySize().toHumanReadableString());
        LOG.info("    Total Flink Memory: {}", (Object)flinkMemory.getTotalFlinkMemorySize().toHumanReadableString());
        LOG.info("      JVM Heap:         {}", (Object)flinkMemory.getJvmHeapMemorySize().toHumanReadableString());
        LOG.info("      Off-heap:         {}", (Object)flinkMemory.getJvmDirectMemorySize().toHumanReadableString());
        LOG.info("    JVM Metaspace:      {}", (Object)spec.getJvmMetaspaceSize().toHumanReadableString());
        LOG.info("    JVM Overhead:       {}", (Object)spec.getJvmOverheadSize().toHumanReadableString());
    }

    private static void logTaskExecutorConfiguration(TaskExecutorProcessSpec spec) {
        TaskExecutorFlinkMemory flinkMemory = (TaskExecutorFlinkMemory)spec.getFlinkMemory();
        MemorySize totalOffHeapMemory = flinkMemory.getManaged().add(flinkMemory.getJvmDirectMemorySize());
        LOG.info("Final TaskExecutor Memory configuration:");
        LOG.info("  Total Process Memory:          {}", (Object)spec.getTotalProcessMemorySize().toHumanReadableString());
        LOG.info("    Total Flink Memory:          {}", (Object)flinkMemory.getTotalFlinkMemorySize().toHumanReadableString());
        LOG.info("      Total JVM Heap Memory:     {}", (Object)flinkMemory.getJvmHeapMemorySize().toHumanReadableString());
        LOG.info("        Framework:               {}", (Object)flinkMemory.getFrameworkHeap().toHumanReadableString());
        LOG.info("        Task:                    {}", (Object)flinkMemory.getTaskHeap().toHumanReadableString());
        LOG.info("      Total Off-heap Memory:     {}", (Object)totalOffHeapMemory.toHumanReadableString());
        LOG.info("        Managed:                 {}", (Object)flinkMemory.getManaged().toHumanReadableString());
        LOG.info("        Total JVM Direct Memory: {}", (Object)flinkMemory.getJvmDirectMemorySize().toHumanReadableString());
        LOG.info("          Framework:             {}", (Object)flinkMemory.getFrameworkOffHeap().toHumanReadableString());
        LOG.info("          Task:                  {}", (Object)flinkMemory.getTaskOffHeap().toHumanReadableString());
        LOG.info("          Network:               {}", (Object)flinkMemory.getNetwork().toHumanReadableString());
        LOG.info("    JVM Metaspace:               {}", (Object)spec.getJvmMetaspaceSize().toHumanReadableString());
        LOG.info("    JVM Overhead:                {}", (Object)spec.getJvmOverheadSize().toHumanReadableString());
    }

    public static enum Command {
        GET_TM_RESOURCE_PARAMS,
        GET_JM_RESOURCE_PARAMS;

    }
}

