/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util.config.memory.taskmanager;

import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.util.config.memory.FlinkMemory;
import org.apache.flink.util.Preconditions;

public class TaskExecutorFlinkMemory
implements FlinkMemory {
    private static final long serialVersionUID = 1L;
    private final MemorySize frameworkHeap;
    private final MemorySize frameworkOffHeap;
    private final MemorySize taskHeap;
    private final MemorySize taskOffHeap;
    private final MemorySize network;
    private final MemorySize managed;

    public TaskExecutorFlinkMemory(MemorySize frameworkHeap, MemorySize frameworkOffHeap, MemorySize taskHeap, MemorySize taskOffHeap, MemorySize network, MemorySize managed) {
        this.frameworkHeap = (MemorySize)Preconditions.checkNotNull((Object)frameworkHeap);
        this.frameworkOffHeap = (MemorySize)Preconditions.checkNotNull((Object)frameworkOffHeap);
        this.taskHeap = (MemorySize)Preconditions.checkNotNull((Object)taskHeap);
        this.taskOffHeap = (MemorySize)Preconditions.checkNotNull((Object)taskOffHeap);
        this.network = (MemorySize)Preconditions.checkNotNull((Object)network);
        this.managed = (MemorySize)Preconditions.checkNotNull((Object)managed);
    }

    public MemorySize getFrameworkHeap() {
        return this.frameworkHeap;
    }

    public MemorySize getFrameworkOffHeap() {
        return this.frameworkOffHeap;
    }

    public MemorySize getTaskHeap() {
        return this.taskHeap;
    }

    public MemorySize getTaskOffHeap() {
        return this.taskOffHeap;
    }

    public MemorySize getNetwork() {
        return this.network;
    }

    public MemorySize getManaged() {
        return this.managed;
    }

    @Override
    public MemorySize getJvmHeapMemorySize() {
        return this.frameworkHeap.add(this.taskHeap);
    }

    @Override
    public MemorySize getJvmDirectMemorySize() {
        return this.frameworkOffHeap.add(this.taskOffHeap).add(this.network);
    }

    @Override
    public MemorySize getTotalFlinkMemorySize() {
        return this.frameworkHeap.add(this.frameworkOffHeap).add(this.taskHeap).add(this.taskOffHeap).add(this.network).add(this.managed);
    }
}

