/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.plugin.PluginDescriptor;
import org.apache.flink.core.plugin.PluginLoader;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.shaded.guava18.com.google.common.collect.Iterators;

@Internal
@ThreadSafe
public class DefaultPluginManager
implements PluginManager {
    private final ClassLoader parentClassLoader;
    private final Collection<PluginDescriptor> pluginDescriptors;
    private final String[] alwaysParentFirstPatterns;

    @VisibleForTesting
    DefaultPluginManager() {
        this.parentClassLoader = null;
        this.pluginDescriptors = null;
        this.alwaysParentFirstPatterns = null;
    }

    public DefaultPluginManager(Collection<PluginDescriptor> pluginDescriptors, String[] alwaysParentFirstPatterns) {
        this(pluginDescriptors, DefaultPluginManager.class.getClassLoader(), alwaysParentFirstPatterns);
    }

    public DefaultPluginManager(Collection<PluginDescriptor> pluginDescriptors, ClassLoader parentClassLoader, String[] alwaysParentFirstPatterns) {
        this.pluginDescriptors = pluginDescriptors;
        this.parentClassLoader = parentClassLoader;
        this.alwaysParentFirstPatterns = alwaysParentFirstPatterns;
    }

    @Override
    public <P> Iterator<P> load(Class<P> service) {
        ArrayList<Iterator<P>> combinedIterators = new ArrayList<Iterator<P>>(this.pluginDescriptors.size());
        for (PluginDescriptor pluginDescriptor : this.pluginDescriptors) {
            PluginLoader pluginLoader = PluginLoader.create(pluginDescriptor, this.parentClassLoader, this.alwaysParentFirstPatterns);
            combinedIterators.add(pluginLoader.load(service));
        }
        return Iterators.concat(combinedIterators.iterator());
    }

    public String toString() {
        return "PluginManager{parentClassLoader=" + this.parentClassLoader + ", pluginDescriptors=" + this.pluginDescriptors + ", alwaysParentFirstPatterns=" + Arrays.toString(this.alwaysParentFirstPatterns) + '}';
    }
}

