/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment.application.executors;

import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.time.Duration;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.dag.Pipeline;
import org.apache.flink.client.cli.ClientOptions;
import org.apache.flink.client.deployment.application.executors.EmbeddedJobClientCreator;
import org.apache.flink.client.deployment.executors.PipelineExecutorUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.PipelineOptionsInternal;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.core.execution.PipelineExecutor;
import org.apache.flink.runtime.blob.BlobClient;
import org.apache.flink.runtime.client.ClientUtils;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class EmbeddedExecutor
implements PipelineExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedExecutor.class);
    public static final String NAME = "embedded";
    private final Collection<JobID> submittedJobIds;
    private final DispatcherGateway dispatcherGateway;
    private final EmbeddedJobClientCreator jobClientCreator;

    public EmbeddedExecutor(Collection<JobID> submittedJobIds, DispatcherGateway dispatcherGateway, EmbeddedJobClientCreator jobClientCreator) {
        this.submittedJobIds = (Collection)Preconditions.checkNotNull(submittedJobIds);
        this.dispatcherGateway = (DispatcherGateway)Preconditions.checkNotNull((Object)dispatcherGateway);
        this.jobClientCreator = (EmbeddedJobClientCreator)Preconditions.checkNotNull((Object)jobClientCreator);
    }

    public CompletableFuture<JobClient> execute(Pipeline pipeline, Configuration configuration) throws MalformedURLException {
        Preconditions.checkNotNull((Object)pipeline);
        Preconditions.checkNotNull((Object)configuration);
        Optional<JobID> optJobId = configuration.getOptional(PipelineOptionsInternal.PIPELINE_FIXED_JOB_ID).map(JobID::fromHexString);
        if (optJobId.isPresent() && this.submittedJobIds.contains(optJobId.get())) {
            return this.getJobClientFuture(optJobId.get());
        }
        return this.submitAndGetJobClientFuture(pipeline, configuration);
    }

    private CompletableFuture<JobClient> getJobClientFuture(JobID jobId) {
        LOG.info("Job {} was recovered successfully.", (Object)jobId);
        return CompletableFuture.completedFuture(this.jobClientCreator.getJobClient(jobId));
    }

    private CompletableFuture<JobClient> submitAndGetJobClientFuture(Pipeline pipeline, Configuration configuration) throws MalformedURLException {
        Time timeout = Time.milliseconds((long)((Duration)configuration.get(ClientOptions.CLIENT_TIMEOUT)).toMillis());
        JobGraph jobGraph = PipelineExecutorUtils.getJobGraph(pipeline, configuration);
        JobID actualJobId = jobGraph.getJobID();
        this.submittedJobIds.add(actualJobId);
        LOG.info("Job {} is submitted.", (Object)actualJobId);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Effective Configuration: {}", (Object)configuration);
        }
        CompletableFuture<JobID> jobSubmissionFuture = EmbeddedExecutor.submitJob(configuration, this.dispatcherGateway, jobGraph, timeout);
        return jobSubmissionFuture.thenApplyAsync(jobID -> this.jobClientCreator.getJobClient(actualJobId));
    }

    private static CompletableFuture<JobID> submitJob(Configuration configuration, DispatcherGateway dispatcherGateway, JobGraph jobGraph, Time rpcTimeout) {
        Preconditions.checkNotNull((Object)jobGraph);
        LOG.info("Submitting Job with JobId={}.", (Object)jobGraph.getJobID());
        return ((CompletableFuture)((CompletableFuture)dispatcherGateway.getBlobServerPort(rpcTimeout).thenApply(blobServerPort -> new InetSocketAddress(dispatcherGateway.getHostname(), (int)blobServerPort))).thenCompose(blobServerAddress -> {
            try {
                ClientUtils.extractAndUploadJobGraphFiles((JobGraph)jobGraph, () -> new BlobClient(blobServerAddress, configuration));
            }
            catch (FlinkException e) {
                throw new CompletionException(e);
            }
            return dispatcherGateway.submitJob(jobGraph, rpcTimeout);
        })).thenApply(ack -> jobGraph.getJobID());
    }
}

