/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.KeyedStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.operators.collect.CollectResultIterator;
import org.apache.flink.streaming.api.operators.collect.CollectSinkOperator;
import org.apache.flink.streaming.api.operators.collect.CollectSinkOperatorFactory;
import org.apache.flink.streaming.api.operators.collect.CollectStreamSink;
import org.apache.flink.streaming.api.transformations.PartitionTransformation;
import org.apache.flink.streaming.runtime.partitioner.ForwardPartitioner;
import org.apache.flink.util.Preconditions;

@Experimental
public final class DataStreamUtils {
    public static <OUT> Iterator<OUT> collect(DataStream<OUT> stream) {
        return DataStreamUtils.collect(stream, "Data Stream Collect");
    }

    public static <OUT> Iterator<OUT> collect(DataStream<OUT> stream, String executionJobName) {
        try {
            return DataStreamUtils.collectWithClient(stream, (String)executionJobName).iterator;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to execute data stream", e);
        }
    }

    public static <OUT> ClientAndIterator<OUT> collectWithClient(DataStream<OUT> stream, String jobExecutionName) throws Exception {
        TypeSerializer serializer = stream.getType().createSerializer(stream.getExecutionEnvironment().getConfig());
        String accumulatorName = "dataStreamCollect_" + UUID.randomUUID().toString();
        StreamExecutionEnvironment env = stream.getExecutionEnvironment();
        CollectSinkOperatorFactory factory = new CollectSinkOperatorFactory(serializer, accumulatorName);
        CollectSinkOperator operator = (CollectSinkOperator)factory.getOperator();
        CollectResultIterator iterator = new CollectResultIterator(operator.getOperatorIdFuture(), serializer, accumulatorName);
        CollectStreamSink<OUT> sink = new CollectStreamSink<OUT>(stream, factory);
        sink.name("Data stream collect sink");
        env.addOperator(sink.getTransformation());
        JobClient jobClient = env.executeAsync(jobExecutionName);
        iterator.setJobClient(jobClient);
        return new ClientAndIterator(jobClient, iterator);
    }

    public static <E> List<E> collectBoundedStream(DataStream<E> stream, String jobName) throws Exception {
        ArrayList list = new ArrayList();
        Iterator iter = DataStreamUtils.collectWithClient(stream, (String)jobName).iterator;
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        list.trimToSize();
        return list;
    }

    public static <E> List<E> collectUnboundedStream(DataStream<E> stream, int numElements, String jobName) throws Exception {
        ClientAndIterator<E> clientAndIterator = DataStreamUtils.collectWithClient(stream, jobName);
        List<E> result = DataStreamUtils.collectRecordsFromUnboundedStream(clientAndIterator, numElements);
        clientAndIterator.client.cancel().get();
        return result;
    }

    public static <E> List<E> collectRecordsFromUnboundedStream(ClientAndIterator<E> client, int numElements) {
        Preconditions.checkNotNull(client, (String)"client");
        Preconditions.checkArgument((numElements > 0 ? 1 : 0) != 0, (Object)"numElement must be > 0");
        ArrayList result = new ArrayList(numElements);
        Iterator iterator = client.iterator;
        while (iterator.hasNext()) {
            result.add(iterator.next());
            if (result.size() != numElements) continue;
            return result;
        }
        throw new IllegalArgumentException(String.format("The stream ended before reaching the requested %d records. Only %d records were received.", numElements, result.size()));
    }

    public static <T, K> KeyedStream<T, K> reinterpretAsKeyedStream(DataStream<T> stream, KeySelector<T, K> keySelector) {
        return DataStreamUtils.reinterpretAsKeyedStream(stream, keySelector, TypeExtractor.getKeySelectorTypes(keySelector, stream.getType()));
    }

    public static <T, K> KeyedStream<T, K> reinterpretAsKeyedStream(DataStream<T> stream, KeySelector<T, K> keySelector, TypeInformation<K> typeInfo) {
        PartitionTransformation<T> partitionTransformation = new PartitionTransformation<T>(stream.getTransformation(), new ForwardPartitioner());
        return new KeyedStream<T, K>(stream, partitionTransformation, keySelector, typeInfo);
    }

    private DataStreamUtils() {
    }

    public static final class ClientAndIterator<E> {
        public final JobClient client;
        public final Iterator<E> iterator;

        ClientAndIterator(JobClient client, Iterator<E> iterator) {
            this.client = (JobClient)Preconditions.checkNotNull((Object)client);
            this.iterator = (Iterator)Preconditions.checkNotNull(iterator);
        }
    }
}

