/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.io.network.api.serialization.RecordSerializer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;

public class SpanningRecordSerializer<T extends IOReadableWritable>
implements RecordSerializer<T> {
    private static final boolean CHECKED = false;
    private final DataOutputSerializer serializationBuffer = new DataOutputSerializer(128);
    private ByteBuffer dataBuffer = this.serializationBuffer.wrapAsByteBuffer();

    @Override
    public void serializeRecord(T record) throws IOException {
        this.serializationBuffer.clear();
        this.serializationBuffer.skipBytesToWrite(4);
        record.write((DataOutputView)this.serializationBuffer);
        int len = this.serializationBuffer.length() - 4;
        this.serializationBuffer.setPosition(0);
        this.serializationBuffer.writeInt(len);
        this.serializationBuffer.skipBytesToWrite(len);
        this.dataBuffer = this.serializationBuffer.wrapAsByteBuffer();
    }

    @Override
    public RecordSerializer.SerializationResult copyToBufferBuilder(BufferBuilder targetBuffer) {
        targetBuffer.append(this.dataBuffer);
        targetBuffer.commit();
        return this.getSerializationResult(targetBuffer);
    }

    private RecordSerializer.SerializationResult getSerializationResult(BufferBuilder targetBuffer) {
        if (this.dataBuffer.hasRemaining()) {
            return RecordSerializer.SerializationResult.PARTIAL_RECORD_MEMORY_SEGMENT_FULL;
        }
        return !targetBuffer.isFull() ? RecordSerializer.SerializationResult.FULL_RECORD : RecordSerializer.SerializationResult.FULL_RECORD_MEMORY_SEGMENT_FULL;
    }

    @Override
    public void reset() {
        this.dataBuffer.position(0);
    }

    @Override
    public void prune() {
        this.serializationBuffer.pruneBuffer();
        this.dataBuffer = this.serializationBuffer.wrapAsByteBuffer();
    }

    @Override
    public boolean hasSerializedData() {
        return this.dataBuffer.hasRemaining();
    }
}

