/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.Counter;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.execution.CancelTaskException;
import org.apache.flink.runtime.io.network.TaskEventPublisher;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.PartitionNotFoundException;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalInputChannel
extends InputChannel
implements BufferAvailabilityListener {
    private static final Logger LOG = LoggerFactory.getLogger(LocalInputChannel.class);
    private final Object requestLock = new Object();
    private final ResultPartitionManager partitionManager;
    private final TaskEventPublisher taskEventPublisher;
    private volatile ResultSubpartitionView subpartitionView;
    private volatile boolean isReleased;
    private long lastRequestedCheckpointId = -1L;
    private long receivedCheckpointId = -1L;

    public LocalInputChannel(SingleInputGate inputGate, int channelIndex, ResultPartitionID partitionId, ResultPartitionManager partitionManager, TaskEventPublisher taskEventPublisher, Counter numBytesIn, Counter numBuffersIn) {
        this(inputGate, channelIndex, partitionId, partitionManager, taskEventPublisher, 0, 0, numBytesIn, numBuffersIn);
    }

    public LocalInputChannel(SingleInputGate inputGate, int channelIndex, ResultPartitionID partitionId, ResultPartitionManager partitionManager, TaskEventPublisher taskEventPublisher, int initialBackoff, int maxBackoff, Counter numBytesIn, Counter numBuffersIn) {
        super(inputGate, channelIndex, partitionId, initialBackoff, maxBackoff, numBytesIn, numBuffersIn);
        this.partitionManager = (ResultPartitionManager)Preconditions.checkNotNull((Object)partitionManager);
        this.taskEventPublisher = (TaskEventPublisher)Preconditions.checkNotNull((Object)taskEventPublisher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void requestSubpartition(int subpartitionIndex) throws IOException {
        boolean retriggerRequest = false;
        Object object = this.requestLock;
        synchronized (object) {
            Preconditions.checkState((!this.isReleased ? 1 : 0) != 0, (Object)"LocalInputChannel has been released already");
            if (this.subpartitionView == null) {
                LOG.debug("{}: Requesting LOCAL subpartition {} of partition {}.", new Object[]{this, subpartitionIndex, this.partitionId});
                try {
                    ResultSubpartitionView subpartitionView = this.partitionManager.createSubpartitionView(this.partitionId, subpartitionIndex, this);
                    if (subpartitionView == null) {
                        throw new IOException("Error requesting subpartition.");
                    }
                    this.subpartitionView = subpartitionView;
                    if (this.isReleased) {
                        subpartitionView.releaseAllResources();
                        this.subpartitionView = null;
                    }
                }
                catch (PartitionNotFoundException notFound) {
                    if (this.increaseBackoff()) {
                        retriggerRequest = true;
                    }
                    throw notFound;
                }
            }
        }
        if (retriggerRequest) {
            this.inputGate.retriggerPartitionRequest(this.partitionId.getPartitionId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retriggerSubpartitionRequest(Timer timer, final int subpartitionIndex) {
        Object object = this.requestLock;
        synchronized (object) {
            Preconditions.checkState((this.subpartitionView == null ? 1 : 0) != 0, (Object)"already requested partition");
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        LocalInputChannel.this.requestSubpartition(subpartitionIndex);
                    }
                    catch (Throwable t) {
                        LocalInputChannel.this.setError(t);
                    }
                }
            }, this.getCurrentBackoff());
        }
    }

    @Override
    public void spillInflightBuffers(long checkpointId, ChannelStateWriter channelStateWriter) {
        this.lastRequestedCheckpointId = checkpointId;
    }

    @Override
    Optional<InputChannel.BufferAndAvailability> getNextBuffer() throws IOException, InterruptedException {
        ResultSubpartition.BufferAndBacklog next;
        this.checkError();
        ResultSubpartitionView subpartitionView = this.subpartitionView;
        if (subpartitionView == null) {
            if (this.isReleased) {
                return Optional.empty();
            }
            subpartitionView = this.checkAndWaitForSubpartitionView();
        }
        if ((next = subpartitionView.getNextBuffer()) == null) {
            if (subpartitionView.isReleased()) {
                throw new CancelTaskException("Consumed partition " + subpartitionView + " has been released.");
            }
            return Optional.empty();
        }
        Buffer buffer = next.buffer();
        CheckpointBarrier notifyReceivedBarrier = this.parseCheckpointBarrierOrNull(buffer);
        if (notifyReceivedBarrier != null) {
            this.receivedCheckpointId = notifyReceivedBarrier.getId();
        } else if (this.receivedCheckpointId < this.lastRequestedCheckpointId && buffer.isBuffer()) {
            this.inputGate.getBufferReceivedListener().notifyBufferReceived(buffer.retainBuffer(), this.channelInfo);
        }
        this.numBytesIn.inc((long)buffer.getSize());
        this.numBuffersIn.inc();
        return Optional.of(new InputChannel.BufferAndAvailability(buffer, next.isDataAvailable(), next.buffersInBacklog()));
    }

    @Override
    public void notifyDataAvailable() {
        this.notifyChannelNonEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSubpartitionView checkAndWaitForSubpartitionView() {
        Object object = this.requestLock;
        synchronized (object) {
            Preconditions.checkState((!this.isReleased ? 1 : 0) != 0, (Object)"released");
            Preconditions.checkState((this.subpartitionView != null ? 1 : 0) != 0, (Object)"Queried for a buffer before requesting the subpartition.");
            return this.subpartitionView;
        }
    }

    @Override
    public void resumeConsumption() {
        Preconditions.checkState((!this.isReleased ? 1 : 0) != 0, (Object)"Channel released.");
        this.subpartitionView.resumeConsumption();
        if (this.subpartitionView.isAvailable(Integer.MAX_VALUE)) {
            this.notifyChannelNonEmpty();
        }
    }

    @Override
    void sendTaskEvent(TaskEvent event) throws IOException {
        this.checkError();
        Preconditions.checkState((this.subpartitionView != null ? 1 : 0) != 0, (Object)"Tried to send task event to producer before requesting the subpartition.");
        if (!this.taskEventPublisher.publish(this.partitionId, event)) {
            throw new IOException("Error while publishing event " + event + " to producer. The producer could not be found.");
        }
    }

    @Override
    boolean isReleased() {
        return this.isReleased;
    }

    @Override
    void releaseAllResources() throws IOException {
        if (!this.isReleased) {
            this.isReleased = true;
            ResultSubpartitionView view = this.subpartitionView;
            if (view != null) {
                view.releaseAllResources();
                this.subpartitionView = null;
            }
        }
    }

    @Override
    public int unsynchronizedGetNumberOfQueuedBuffers() {
        ResultSubpartitionView view = this.subpartitionView;
        if (view != null) {
            return view.unsynchronizedGetNumberOfQueuedBuffers();
        }
        return 0;
    }

    public String toString() {
        return "LocalInputChannel [" + this.partitionId + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean notifyPriorityEvent(BufferConsumer eventBufferConsumer) throws IOException {
        if (this.inputGate.getBufferReceivedListener() == null) {
            return false;
        }
        Buffer buffer = eventBufferConsumer.build();
        try {
            CheckpointBarrier event = this.parseCheckpointBarrierOrNull(buffer);
            if (event == null) {
                throw new IllegalStateException("Currently only checkpoint barriers are known priority events");
            }
            if (event.isCheckpoint()) {
                this.inputGate.getBufferReceivedListener().notifyBarrierReceived(event, this.channelInfo);
            }
        }
        finally {
            buffer.recycleBuffer();
        }
        return true;
    }

    @VisibleForTesting
    ResultSubpartitionView getSubpartitionView() {
        return this.subpartitionView;
    }
}

