/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.strategy.FileLockExclusiveReadLockStrategy;
import org.apache.camel.component.file.strategy.GenericFileProcessStrategySupport;
import org.apache.camel.component.file.strategy.GenericFileRenamer;
import org.apache.camel.support.ExchangeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericFileDeleteProcessStrategy<T>
extends GenericFileProcessStrategySupport<T> {
    private static final Logger LOG = LoggerFactory.getLogger(GenericFileDeleteProcessStrategy.class);
    private GenericFileRenamer<T> failureRenamer;
    private GenericFileRenamer<T> beginRenamer;

    @Override
    public boolean begin(GenericFileOperations<T> operations, GenericFileEndpoint<T> endpoint, Exchange exchange, GenericFile<T> file) throws Exception {
        GenericFile<T> newName;
        GenericFile<T> to;
        boolean result = super.begin(operations, endpoint, exchange, file);
        if (!result) {
            return false;
        }
        if (this.beginRenamer != null && (to = this.renameFile(operations, file, newName = this.beginRenamer.renameFile(exchange, file))) != null) {
            to.bindToExchange(exchange);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(GenericFileOperations<T> operations, GenericFileEndpoint<T> endpoint, Exchange exchange, GenericFile<T> file) throws Exception {
        boolean releaseEager = this.exclusiveReadLockStrategy instanceof FileLockExclusiveReadLockStrategy;
        if (releaseEager) {
            this.exclusiveReadLockStrategy.releaseExclusiveReadLockOnCommit(operations, file, exchange);
        }
        try {
            this.deleteLocalWorkFile(exchange);
            operations.releaseRetrievedFileResources(exchange);
            boolean deleted = false;
            for (int retries = 3; retries > 0 && !deleted; --retries) {
                if (operations.deleteFile(file.getAbsoluteFilePath())) {
                    deleted = true;
                    break;
                }
                boolean exits = operations.existsFile(file.getAbsoluteFilePath());
                if (!exits) {
                    deleted = true;
                    continue;
                }
                LOG.trace("File was not deleted at this attempt will try again in 1 sec.: {}", file);
                Thread.sleep(1000L);
            }
            if (!deleted) {
                throw new GenericFileOperationFailedException("Cannot delete file: " + file);
            }
        }
        finally {
            if (!releaseEager && this.exclusiveReadLockStrategy != null) {
                this.exclusiveReadLockStrategy.releaseExclusiveReadLockOnCommit(operations, file, exchange);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(GenericFileOperations<T> operations, GenericFileEndpoint<T> endpoint, Exchange exchange, GenericFile<T> file) throws Exception {
        try {
            this.deleteLocalWorkFile(exchange);
            operations.releaseRetrievedFileResources(exchange);
            if (this.failureRenamer != null) {
                Exchange copy = ExchangeHelper.createCopy((Exchange)exchange, (boolean)true);
                file.bindToExchange(copy);
                copy.getIn().setMessageId(exchange.getIn().getMessageId());
                copy.setExchangeId(exchange.getExchangeId());
                GenericFile<T> newName = this.failureRenamer.renameFile(copy, file);
                this.renameFile(operations, file, newName);
            }
        }
        finally {
            if (this.exclusiveReadLockStrategy != null) {
                this.exclusiveReadLockStrategy.releaseExclusiveReadLockOnRollback(operations, file, exchange);
            }
        }
    }

    public GenericFileRenamer<T> getFailureRenamer() {
        return this.failureRenamer;
    }

    public void setFailureRenamer(GenericFileRenamer<T> failureRenamer) {
        this.failureRenamer = failureRenamer;
    }

    public GenericFileRenamer<T> getBeginRenamer() {
        return this.beginRenamer;
    }

    public void setBeginRenamer(GenericFileRenamer<T> beginRenamer) {
        this.beginRenamer = beginRenamer;
    }
}

