/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.io.IOException;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.spi.ConfigurerResolver;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConfigurerResolver
implements ConfigurerResolver {
    public static final String RESOURCE_PATH = "META-INF/services/org/apache/camel/configurer/";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultConfigurerResolver.class);
    protected FactoryFinder factoryFinder;

    public GeneratedPropertyConfigurer resolvePropertyConfigurer(String name, CamelContext context) {
        Class<?> type;
        GeneratedPropertyConfigurer configurer = (GeneratedPropertyConfigurer)context.getRegistry().lookupByNameAndType(name, GeneratedPropertyConfigurer.class);
        if (configurer != null) {
            return configurer;
        }
        if (name.endsWith("-configurer")) {
            name = name.substring(0, name.length() - 11);
        }
        try {
            type = this.findConfigurer(name, context);
            if (type == null) {
                return null;
            }
        }
        catch (NoFactoryAvailableException e) {
            return null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid URI, no Configurer registered for scheme: " + name, e);
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Found configurer: {} via type: {} via: {}{}", new Object[]{name, type.getName(), this.factoryFinder.getResourcePath(), name});
        }
        if (GeneratedPropertyConfigurer.class.isAssignableFrom(type)) {
            return (GeneratedPropertyConfigurer)context.getInjector().newInstance(type, false);
        }
        throw new IllegalArgumentException("Type is not a GeneratedPropertyConfigurer implementation. Found: " + type.getName());
    }

    private Class<?> findConfigurer(String name, CamelContext context) throws IOException {
        if (this.factoryFinder == null) {
            this.factoryFinder = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getFactoryFinder(RESOURCE_PATH);
        }
        return this.factoryFinder.findClass(name).orElse(null);
    }

    protected Logger getLog() {
        return LOG;
    }
}

