/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import org.apache.camel.CamelContext;
import org.apache.camel.impl.converter.AnnotationTypeConverterLoader;
import org.apache.camel.impl.converter.BaseTypeConverterRegistry;
import org.apache.camel.spi.AnnotationScanTypeConverters;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTypeConverter
extends BaseTypeConverterRegistry
implements AnnotationScanTypeConverters {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTypeConverter.class);
    private volatile boolean loadTypeConvertersDone;
    private final boolean loadTypeConverters;

    public DefaultTypeConverter(PackageScanClassResolver resolver, Injector injector, FactoryFinder factoryFinder, boolean loadTypeConverters) {
        this(null, resolver, injector, factoryFinder, loadTypeConverters);
    }

    public DefaultTypeConverter(CamelContext camelContext, PackageScanClassResolver resolver, Injector injector, FactoryFinder factoryFinder, boolean loadTypeConverters) {
        super(camelContext, resolver, injector, factoryFinder);
        this.loadTypeConverters = loadTypeConverters;
    }

    public boolean isRunAllowed() {
        return true;
    }

    @Override
    protected void doInit() throws Exception {
        StopWatch watch = new StopWatch();
        super.doInit();
        this.loadCoreAndFastTypeConverters();
        String time = TimeUtils.printDuration((double)watch.taken());
        LOG.debug("Loaded {} type converters in {}", (Object)this.typeMappings.size(), (Object)time);
        if (!this.loadTypeConvertersDone && this.isLoadTypeConverters()) {
            this.scanTypeConverters();
        }
    }

    private boolean isLoadTypeConverters() {
        boolean load = this.loadTypeConverters;
        if (this.camelContext != null) {
            load = this.camelContext.isLoadTypeConverters();
        }
        return load;
    }

    public void scanTypeConverters() throws Exception {
        StopWatch watch = new StopWatch();
        if (!this.loadTypeConvertersDone) {
            this.loadTypeConvertersDone = true;
            if (this.resolver != null) {
                this.typeConverterLoaders.add(new AnnotationTypeConverterLoader(this.resolver));
            }
            int fast = this.typeMappings.size();
            this.loadTypeConverters();
            int additional = this.typeMappings.size() - fast;
            if (additional > 0) {
                LOG.info("Type converters loaded (fast: {}, scanned: {})", (Object)fast, (Object)additional);
                LOG.warn("Annotation scanning mode loaded {} type converters. Its recommended to migrate to @Converter(loader = true) for fast type converter mode.", (Object)additional);
            }
            if (this.resolver != null) {
                this.resolver.clearCache();
            }
        }
        String time = TimeUtils.printDuration((double)watch.taken());
        LOG.debug("Scanned {} type converters in {}", (Object)this.typeMappings.size(), (Object)time);
    }
}

