/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grape;

import java.io.File;
import java.io.FileReader;
import java.io.IOError;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Paths;
import java.util.List;
import org.apache.camel.component.grape.PatchesRepository;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;

public class FilePatchesRepository
implements PatchesRepository {
    private final File repository;

    public FilePatchesRepository() {
        this(Paths.get(SystemUtils.getUserHome().getAbsolutePath(), ".camel", "patches").toFile());
    }

    public FilePatchesRepository(File repository) {
        try {
            if (!repository.exists()) {
                if (repository.getParentFile() != null) {
                    repository.getParentFile().mkdirs();
                }
                repository.createNewFile();
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        this.repository = repository;
    }

    @Override
    public void install(String coordinates) {
        try {
            FileUtils.writeStringToFile((File)this.repository, (String)(coordinates + "\n"), (boolean)true);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public List<String> listPatches() {
        try {
            return IOUtils.readLines((Reader)new FileReader(this.repository));
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public void clear() {
        try {
            this.repository.delete();
            this.repository.createNewFile();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }
}

