/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.csimple;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.language.csimple.CSimpleExpressionParser;
import org.apache.camel.language.csimple.CSimpleGeneratedCode;
import org.apache.camel.language.csimple.CSimplePredicateParser;
import org.apache.camel.util.StringHelper;

public class CSimpleCodeGenerator {
    private static final AtomicInteger UUID = new AtomicInteger();
    private Set<String> imports = new TreeSet<String>();
    private Map<String, String> aliases = new HashMap<String, String>();

    public Set<String> getImports() {
        return this.imports;
    }

    public void setImports(Set<String> imports) {
        this.imports = imports;
    }

    public Map<String, String> getAliases() {
        return this.aliases;
    }

    public void setAliases(Map<String, String> aliases) {
        this.aliases = aliases;
    }

    public CSimpleGeneratedCode generateExpression(String fqn, String script) {
        return this.generateCode(fqn, script, false);
    }

    public CSimpleGeneratedCode generatePredicate(String fqn, String script) {
        return this.generateCode(fqn, script, true);
    }

    private CSimpleGeneratedCode generateCode(String fqn, String script, boolean predicate) {
        Object parser;
        String text = script;
        text = text.replaceAll("\n", "");
        text = text.trim();
        String qn = fqn.substring(0, fqn.lastIndexOf(46));
        String name = CSimpleCodeGenerator.nextName();
        script = script.trim();
        script = this.alias(script);
        StringBuilder sb = new StringBuilder();
        sb.append("package ").append(qn).append(";\n");
        sb.append("\n");
        sb.append("import java.util.*;\n");
        sb.append("import java.util.concurrent.*;\n");
        sb.append("import java.util.stream.*;\n");
        sb.append("\n");
        sb.append("import org.apache.camel.*;\n");
        sb.append("import org.apache.camel.util.*;\n");
        sb.append("import static org.apache.camel.language.csimple.CSimpleHelper.*;\n");
        sb.append("\n");
        for (String i : this.imports) {
            sb.append(i);
            if (!i.endsWith(";")) {
                sb.append(";");
            }
            sb.append("\n");
        }
        sb.append("\n");
        sb.append("public class ").append(name).append(" extends org.apache.camel.language.csimple.CSimpleSupport {\n");
        sb.append("\n");
        sb.append("    public ").append(name).append("() {\n");
        sb.append("    }\n");
        sb.append("\n");
        sb.append("    @Override\n");
        sb.append("    public boolean isPredicate() {\n");
        sb.append("        return ").append(predicate).append(";\n");
        sb.append("    }\n");
        sb.append("\n");
        sb.append("    @Override\n");
        sb.append("    public String getText() {\n");
        String escaped = StringHelper.replaceAll((String)text, (String)"\\", (String)"\\\\");
        escaped = StringHelper.replaceAll((String)escaped, (String)"\"", (String)"\\\"");
        sb.append("        return \"").append(escaped).append("\";\n");
        sb.append("    }\n");
        sb.append("\n");
        sb.append("    @Override\n");
        sb.append("    public Object evaluate(CamelContext context, Exchange exchange, Message message, Object body) throws Exception {\n");
        sb.append("        ");
        if (!script.contains("return ")) {
            sb.append("return ");
        }
        if (predicate) {
            parser = new CSimplePredicateParser();
            if ((script = ((CSimplePredicateParser)parser).parsePredicate(script)).trim().isEmpty()) {
                script = "false";
            }
        } else {
            parser = new CSimpleExpressionParser();
            if ((script = ((CSimpleExpressionParser)parser).parseExpression(script)).trim().isEmpty()) {
                script = "\"" + script + "\"";
            }
        }
        sb.append(script);
        if (!script.endsWith("}") && !script.endsWith(";")) {
            sb.append(";");
        }
        sb.append("\n");
        sb.append("    }\n");
        sb.append("}\n");
        sb.append("\n");
        return new CSimpleGeneratedCode(qn + "." + name, sb.toString());
    }

    private String alias(String script) {
        for (Map.Entry<String, String> entry : this.aliases.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            script = StringHelper.replaceAll((String)script, (String)key, (String)value);
        }
        return script;
    }

    private static String nextName() {
        return "CSimpleScript" + UUID.incrementAndGet();
    }
}

