/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.sps;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsLocatedFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.LocatedStripedBlock;
import org.apache.hadoop.hdfs.server.balancer.Matcher;
import org.apache.hadoop.hdfs.server.namenode.ErasureCodingPolicyManager;
import org.apache.hadoop.hdfs.server.namenode.sps.BlockStorageMovementAttemptedItems;
import org.apache.hadoop.hdfs.server.namenode.sps.BlockStorageMovementNeeded;
import org.apache.hadoop.hdfs.server.namenode.sps.Context;
import org.apache.hadoop.hdfs.server.namenode.sps.DatanodeCacheManager;
import org.apache.hadoop.hdfs.server.namenode.sps.ItemInfo;
import org.apache.hadoop.hdfs.server.namenode.sps.SPSService;
import org.apache.hadoop.hdfs.server.protocol.BlockStorageMovementCommand;
import org.apache.hadoop.hdfs.util.StripedBlockUtil;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class StoragePolicySatisfier
implements SPSService,
Runnable {
    public static final Logger LOG = LoggerFactory.getLogger(StoragePolicySatisfier.class);
    private Daemon storagePolicySatisfierThread;
    private BlockStorageMovementNeeded storageMovementNeeded;
    private BlockStorageMovementAttemptedItems storageMovementsMonitor;
    private volatile boolean isRunning = false;
    private int spsWorkMultiplier;
    private long blockCount = 0L;
    private int blockMovementMaxRetry;
    private Context ctxt;
    private final Configuration conf;
    private DatanodeCacheManager dnCacheMgr;

    public StoragePolicySatisfier(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public void init(Context context) {
        this.ctxt = context;
        this.storageMovementNeeded = new BlockStorageMovementNeeded(context);
        this.storageMovementsMonitor = new BlockStorageMovementAttemptedItems(this, this.storageMovementNeeded, context);
        this.spsWorkMultiplier = StoragePolicySatisfier.getSPSWorkMultiplier(this.getConf());
        this.blockMovementMaxRetry = this.getConf().getInt("dfs.storage.policy.satisfier.retry.max.attempts", 3);
    }

    @Override
    public synchronized void start(HdfsConstants.StoragePolicySatisfierMode serviceMode) {
        if (serviceMode == HdfsConstants.StoragePolicySatisfierMode.NONE) {
            LOG.error("Can't start StoragePolicySatisfier for the given mode:{}", (Object)serviceMode);
            return;
        }
        LOG.info("Starting {} StoragePolicySatisfier.", (Object)StringUtils.toLowerCase((String)serviceMode.toString()));
        this.isRunning = true;
        this.storagePolicySatisfierThread = new Daemon((Runnable)this);
        this.storagePolicySatisfierThread.setName("StoragePolicySatisfier");
        this.storagePolicySatisfierThread.start();
        this.storageMovementsMonitor.start();
        this.storageMovementNeeded.activate();
        this.dnCacheMgr = new DatanodeCacheManager(this.conf);
    }

    @Override
    public synchronized void stop(boolean forceStop) {
        this.isRunning = false;
        if (this.storagePolicySatisfierThread == null) {
            return;
        }
        this.storageMovementNeeded.close();
        this.storagePolicySatisfierThread.interrupt();
        this.storageMovementsMonitor.stop();
        if (forceStop) {
            this.storageMovementNeeded.clearQueuesWithNotification();
        } else {
            LOG.info("Stopping StoragePolicySatisfier.");
        }
    }

    @Override
    public synchronized void stopGracefully() {
        block5: {
            if (this.isRunning) {
                this.stop(false);
            }
            if (this.storageMovementsMonitor != null) {
                this.storageMovementsMonitor.stopGracefully();
            }
            if (this.storagePolicySatisfierThread != null) {
                try {
                    this.storagePolicySatisfierThread.join(3000L);
                }
                catch (InterruptedException ie) {
                    if (!LOG.isDebugEnabled()) break block5;
                    LOG.debug("Interrupted Exception while waiting to join sps thread, ignoring it", (Throwable)ie);
                }
            }
        }
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.isRunning) {
            if (!this.ctxt.isRunning()) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Upstream service is down, skipping the sps work.");
                continue;
            }
            ItemInfo itemInfo = null;
            try {
                boolean retryItem = false;
                if (!this.ctxt.isInSafeMode()) {
                    itemInfo = this.storageMovementNeeded.get();
                    if (itemInfo != null) {
                        if (itemInfo.getRetryCount() >= this.blockMovementMaxRetry) {
                            LOG.info("Failed to satisfy the policy after " + this.blockMovementMaxRetry + " retries. Removing inode " + itemInfo.getFile() + " from the queue");
                            this.storageMovementNeeded.removeItemTrackInfo(itemInfo, false);
                            continue;
                        }
                        long trackId = itemInfo.getFile();
                        BlocksMovingAnalysis status = null;
                        HdfsFileStatus fileStatus = this.ctxt.getFileInfo(trackId);
                        if (fileStatus == null || fileStatus.isDir()) {
                            this.storageMovementNeeded.removeItemTrackInfo(itemInfo, true);
                        } else {
                            byte existingStoragePolicyID = fileStatus.getStoragePolicy();
                            BlockStoragePolicy existingStoragePolicy = this.ctxt.getStoragePolicy(existingStoragePolicyID);
                            HdfsLocatedFileStatus file = (HdfsLocatedFileStatus)fileStatus;
                            status = this.analyseBlocksStorageMovementsAndAssignToDN(file, existingStoragePolicy);
                            switch (status.status) {
                                case ANALYSIS_SKIPPED_FOR_RETRY: 
                                case BLOCKS_TARGETS_PAIRED: {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug("Block analysis status:{} for the file id:{}. Adding to attempt monitor queue for the storage movement attempt finished report", (Object)status.status, (Object)fileStatus.getFileId());
                                    }
                                    this.storageMovementsMonitor.add(itemInfo.getStartPath(), itemInfo.getFile(), Time.monotonicNow(), status.assignedBlocks, itemInfo.getRetryCount());
                                    break;
                                }
                                case NO_BLOCKS_TARGETS_PAIRED: {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug("Adding trackID:{} for the file id:{} back to retry queue as none of the blocks found its eligible targets.", (Object)trackId, (Object)fileStatus.getFileId());
                                    }
                                    retryItem = true;
                                    break;
                                }
                                case FEW_LOW_REDUNDANCY_BLOCKS: {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug("Adding trackID:{} for the file id:{} back to retry queue as some of the blocks are low redundant.", (Object)trackId, (Object)fileStatus.getFileId());
                                    }
                                    retryItem = true;
                                    break;
                                }
                                case BLOCKS_FAILED_TO_MOVE: {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug("Adding trackID:{} for the file id:{} back to retry queue as some of the blocks movement failed.", (Object)trackId, (Object)fileStatus.getFileId());
                                    }
                                    retryItem = true;
                                    break;
                                }
                                default: {
                                    LOG.info("Block analysis status:{} for the file id:{}. So, Cleaning up the Xattrs.", (Object)status.status, (Object)fileStatus.getFileId());
                                    this.storageMovementNeeded.removeItemTrackInfo(itemInfo, true);
                                }
                            }
                        }
                    }
                } else {
                    LOG.info("Namenode is in safemode. It will retry again.");
                    Thread.sleep(3000L);
                }
                int numLiveDn = this.ctxt.getNumLiveDataNodes();
                if (this.storageMovementNeeded.size() == 0 || this.blockCount > (long)(numLiveDn * this.spsWorkMultiplier)) {
                    Thread.sleep(3000L);
                    this.blockCount = 0L;
                }
                if (!retryItem) continue;
                this.storageMovementNeeded.add(itemInfo);
            }
            catch (IOException e) {
                LOG.error("Exception during StoragePolicySatisfier execution - will continue next cycle", (Throwable)e);
                this.storageMovementNeeded.add(itemInfo);
            }
            catch (Throwable t) {
                StoragePolicySatisfier storagePolicySatisfier = this;
                synchronized (storagePolicySatisfier) {
                    if (this.isRunning) {
                        this.isRunning = false;
                        if (t instanceof InterruptedException) {
                            LOG.info("Stopping StoragePolicySatisfier.", t);
                        } else {
                            LOG.error("StoragePolicySatisfier thread received runtime exception.", t);
                        }
                        this.clearQueues();
                        this.storageMovementsMonitor.stopGracefully();
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BlocksMovingAnalysis analyseBlocksStorageMovementsAndAssignToDN(HdfsLocatedFileStatus fileInfo, BlockStoragePolicy existingStoragePolicy) throws IOException {
        BlocksMovingAnalysis.Status status = BlocksMovingAnalysis.Status.BLOCKS_ALREADY_SATISFIED;
        ErasureCodingPolicy ecPolicy = fileInfo.getErasureCodingPolicy();
        LocatedBlocks locatedBlocks = fileInfo.getLocatedBlocks();
        boolean lastBlkComplete = locatedBlocks.isLastBlockComplete();
        if (!lastBlkComplete) {
            LOG.info("File: {} is under construction. So, postpone this to the next retry iteration", (Object)fileInfo.getFileId());
            return new BlocksMovingAnalysis(BlocksMovingAnalysis.Status.ANALYSIS_SKIPPED_FOR_RETRY, new HashMap<Block, Set<StorageTypeNodePair>>());
        }
        List blocks = locatedBlocks.getLocatedBlocks();
        if (blocks.size() == 0) {
            LOG.info("File: {} is not having any blocks. So, skipping the analysis.", (Object)fileInfo.getFileId());
            return new BlocksMovingAnalysis(BlocksMovingAnalysis.Status.BLOCKS_TARGET_PAIRING_SKIPPED, new HashMap<Block, Set<StorageTypeNodePair>>());
        }
        ArrayList<BlockStorageMovementCommand.BlockMovingInfo> blockMovingInfos = new ArrayList<BlockStorageMovementCommand.BlockMovingInfo>();
        boolean hasLowRedundancyBlocks = false;
        short replication = fileInfo.getReplication();
        DatanodeMap liveDns = this.dnCacheMgr.getLiveDatanodeStorageReport(this.ctxt);
        for (int i = 0; i < blocks.size(); ++i) {
            List expectedStorageTypes;
            LocatedBlock blockInfo = (LocatedBlock)blocks.get(i);
            hasLowRedundancyBlocks |= this.isLowRedundancyBlock(blockInfo, replication, ecPolicy);
            if (blockInfo.isStriped()) {
                if (!ErasureCodingPolicyManager.checkStoragePolicySuitableForECStripedMode(existingStoragePolicy.getId())) {
                    LOG.warn("The storage policy " + existingStoragePolicy.getName() + " is not suitable for Striped EC files. So, ignoring to move the blocks");
                    return new BlocksMovingAnalysis(BlocksMovingAnalysis.Status.BLOCKS_TARGET_PAIRING_SKIPPED, new HashMap<Block, Set<StorageTypeNodePair>>());
                }
                expectedStorageTypes = existingStoragePolicy.chooseStorageTypes((short)blockInfo.getLocations().length);
            } else {
                expectedStorageTypes = existingStoragePolicy.chooseStorageTypes(fileInfo.getReplication());
            }
            LinkedList<StorageType> existing = new LinkedList<StorageType>(Arrays.asList(blockInfo.getStorageTypes()));
            if (StoragePolicySatisfier.removeOverlapBetweenStorageTypes(expectedStorageTypes, existing, true)) continue;
            boolean blocksPaired = this.computeBlockMovingInfos(blockMovingInfos, blockInfo, expectedStorageTypes, existing, blockInfo.getLocations(), liveDns, ecPolicy);
            if (blocksPaired) {
                status = BlocksMovingAnalysis.Status.BLOCKS_TARGETS_PAIRED;
                continue;
            }
            if (status == BlocksMovingAnalysis.Status.BLOCKS_TARGETS_PAIRED) continue;
            status = BlocksMovingAnalysis.Status.NO_BLOCKS_TARGETS_PAIRED;
        }
        if (hasLowRedundancyBlocks && status != BlocksMovingAnalysis.Status.BLOCKS_TARGETS_PAIRED) {
            status = BlocksMovingAnalysis.Status.FEW_LOW_REDUNDANCY_BLOCKS;
        }
        HashMap<Block, Set<StorageTypeNodePair>> assignedBlocks = new HashMap<Block, Set<StorageTypeNodePair>>();
        Iterator iterator = blockMovingInfos.iterator();
        while (iterator.hasNext()) {
            BlockStorageMovementCommand.BlockMovingInfo blkMovingInfo = (BlockStorageMovementCommand.BlockMovingInfo)iterator.next();
            try {
                this.ctxt.submitMoveTask(blkMovingInfo);
                LOG.debug("BlockMovingInfo: {}", (Object)blkMovingInfo);
                StorageTypeNodePair nodeStorage = new StorageTypeNodePair(blkMovingInfo.getTargetStorageType(), blkMovingInfo.getTarget());
                HashSet<StorageTypeNodePair> nodesWithStorage = (HashSet<StorageTypeNodePair>)assignedBlocks.get(blkMovingInfo.getBlock());
                if (nodesWithStorage == null) {
                    nodesWithStorage = new HashSet<StorageTypeNodePair>();
                    assignedBlocks.put(blkMovingInfo.getBlock(), nodesWithStorage);
                }
                nodesWithStorage.add(nodeStorage);
                ++this.blockCount;
            }
            catch (IOException e) {
                LOG.warn("Exception while scheduling movement task", (Throwable)e);
                status = BlocksMovingAnalysis.Status.BLOCKS_FAILED_TO_MOVE;
                continue;
            }
            break;
        }
        return new BlocksMovingAnalysis(status, assignedBlocks);
    }

    private boolean isLowRedundancyBlock(LocatedBlock blockInfo, int replication, ErasureCodingPolicy ecPolicy) {
        boolean hasLowRedundancyBlock = false;
        if (blockInfo.isStriped()) {
            replication = ecPolicy.getNumDataUnits() + ecPolicy.getNumParityUnits();
        }
        hasLowRedundancyBlock = blockInfo.getLocations().length < replication;
        return hasLowRedundancyBlock;
    }

    private boolean computeBlockMovingInfos(List<BlockStorageMovementCommand.BlockMovingInfo> blockMovingInfos, LocatedBlock blockInfo, List<StorageType> expectedStorageTypes, List<StorageType> existing, DatanodeInfo[] storages, DatanodeMap liveDns, ErasureCodingPolicy ecPolicy) {
        boolean foundMatchingTargetNodesForBlock = true;
        if (!StoragePolicySatisfier.removeOverlapBetweenStorageTypes(expectedStorageTypes, existing, true)) {
            ArrayList<StorageTypeNodePair> sourceWithStorageMap = new ArrayList<StorageTypeNodePair>();
            ArrayList<DatanodeInfo> existingBlockStorages = new ArrayList<DatanodeInfo>(Arrays.asList(storages));
            ArrayList<DatanodeInfo> excludeNodes = new ArrayList<DatanodeInfo>(existingBlockStorages);
            Iterator iterator = existingBlockStorages.iterator();
            while (iterator.hasNext()) {
                DatanodeInfoWithStorage dnInfo = (DatanodeInfoWithStorage)iterator.next();
                if (!this.checkSourceAndTargetTypeExists((DatanodeInfo)dnInfo, existing, expectedStorageTypes, liveDns)) continue;
                sourceWithStorageMap.add(new StorageTypeNodePair(dnInfo.getStorageType(), (DatanodeInfo)dnInfo));
                iterator.remove();
                existing.remove(dnInfo.getStorageType());
            }
            block1: for (StorageType existingType : existing) {
                iterator = existingBlockStorages.iterator();
                while (iterator.hasNext()) {
                    DatanodeInfoWithStorage dnStorageInfo = (DatanodeInfoWithStorage)iterator.next();
                    StorageType storageType = dnStorageInfo.getStorageType();
                    if (storageType != existingType) continue;
                    iterator.remove();
                    sourceWithStorageMap.add(new StorageTypeNodePair(storageType, (DatanodeInfo)dnStorageInfo));
                    continue block1;
                }
            }
            EnumMap<StorageType, List<DatanodeWithStorage.StorageDetails>> targetDns = this.findTargetsForExpectedStorageTypes(expectedStorageTypes, liveDns);
            foundMatchingTargetNodesForBlock |= this.findSourceAndTargetToMove(blockMovingInfos, blockInfo, sourceWithStorageMap, expectedStorageTypes, targetDns, ecPolicy, excludeNodes);
        }
        return foundMatchingTargetNodesForBlock;
    }

    private boolean findSourceAndTargetToMove(List<BlockStorageMovementCommand.BlockMovingInfo> blockMovingInfos, LocatedBlock blockInfo, List<StorageTypeNodePair> sourceWithStorageList, List<StorageType> expectedTypes, EnumMap<StorageType, List<DatanodeWithStorage.StorageDetails>> targetDns, ErasureCodingPolicy ecPolicy, List<DatanodeInfo> excludeNodes) {
        StorageTypeNodePair chosenTarget;
        StorageTypeNodePair existingTypeNodePair;
        int i;
        boolean foundMatchingTargetNodesForBlock = true;
        for (i = 0; i < sourceWithStorageList.size(); ++i) {
            existingTypeNodePair = sourceWithStorageList.get(i);
            if (expectedTypes.contains(existingTypeNodePair.storageType) || (chosenTarget = this.chooseTargetTypeInSameNode(blockInfo, existingTypeNodePair.dn, targetDns, expectedTypes)) == null) continue;
            if (blockInfo.isStriped()) {
                this.buildStripedBlockMovingInfos(blockInfo, existingTypeNodePair.dn, existingTypeNodePair.storageType, chosenTarget.dn, chosenTarget.storageType, blockMovingInfos, ecPolicy);
            } else {
                this.buildContinuousBlockMovingInfos(blockInfo, existingTypeNodePair.dn, existingTypeNodePair.storageType, chosenTarget.dn, chosenTarget.storageType, blockMovingInfos);
            }
            expectedTypes.remove(chosenTarget.storageType);
        }
        if (expectedTypes.size() <= 0) {
            return foundMatchingTargetNodesForBlock;
        }
        for (i = 0; i < sourceWithStorageList.size(); ++i) {
            existingTypeNodePair = sourceWithStorageList.get(i);
            chosenTarget = null;
            if (this.checkIfAlreadyChosen(blockMovingInfos, existingTypeNodePair.dn)) continue;
            if (chosenTarget == null && this.dnCacheMgr.getCluster().isNodeGroupAware()) {
                chosenTarget = this.chooseTarget(blockInfo, existingTypeNodePair.dn, expectedTypes, Matcher.SAME_NODE_GROUP, targetDns, excludeNodes);
            }
            if (chosenTarget == null) {
                chosenTarget = this.chooseTarget(blockInfo, existingTypeNodePair.dn, expectedTypes, Matcher.SAME_RACK, targetDns, excludeNodes);
            }
            if (chosenTarget == null) {
                chosenTarget = this.chooseTarget(blockInfo, existingTypeNodePair.dn, expectedTypes, Matcher.ANY_OTHER, targetDns, excludeNodes);
            }
            if (null != chosenTarget) {
                if (blockInfo.isStriped()) {
                    this.buildStripedBlockMovingInfos(blockInfo, existingTypeNodePair.dn, existingTypeNodePair.storageType, chosenTarget.dn, chosenTarget.storageType, blockMovingInfos, ecPolicy);
                } else {
                    this.buildContinuousBlockMovingInfos(blockInfo, existingTypeNodePair.dn, existingTypeNodePair.storageType, chosenTarget.dn, chosenTarget.storageType, blockMovingInfos);
                }
                expectedTypes.remove(chosenTarget.storageType);
                excludeNodes.add(chosenTarget.dn);
                continue;
            }
            LOG.warn("Failed to choose target datanode for the required storage types {}, block:{}, existing storage type:{}", new Object[]{expectedTypes, blockInfo, existingTypeNodePair.storageType});
        }
        if (expectedTypes.size() > 0) {
            foundMatchingTargetNodesForBlock = false;
        }
        return foundMatchingTargetNodesForBlock;
    }

    private boolean checkIfAlreadyChosen(List<BlockStorageMovementCommand.BlockMovingInfo> blockMovingInfos, DatanodeInfo dn) {
        for (BlockStorageMovementCommand.BlockMovingInfo blockMovingInfo : blockMovingInfos) {
            if (!blockMovingInfo.getSource().equals((Object)dn)) continue;
            return true;
        }
        return false;
    }

    private void buildContinuousBlockMovingInfos(LocatedBlock blockInfo, DatanodeInfo sourceNode, StorageType sourceStorageType, DatanodeInfo targetNode, StorageType targetStorageType, List<BlockStorageMovementCommand.BlockMovingInfo> blkMovingInfos) {
        Block blk = ExtendedBlock.getLocalBlock((ExtendedBlock)blockInfo.getBlock());
        BlockStorageMovementCommand.BlockMovingInfo blkMovingInfo = new BlockStorageMovementCommand.BlockMovingInfo(blk, sourceNode, targetNode, sourceStorageType, targetStorageType);
        blkMovingInfos.add(blkMovingInfo);
    }

    private void buildStripedBlockMovingInfos(LocatedBlock blockInfo, DatanodeInfo sourceNode, StorageType sourceStorageType, DatanodeInfo targetNode, StorageType targetStorageType, List<BlockStorageMovementCommand.BlockMovingInfo> blkMovingInfos, ErasureCodingPolicy ecPolicy) {
        LocatedStripedBlock sBlockInfo = (LocatedStripedBlock)blockInfo;
        byte[] indices = sBlockInfo.getBlockIndices();
        DatanodeInfo[] locations = sBlockInfo.getLocations();
        for (int i = 0; i < indices.length; ++i) {
            byte blkIndex = indices[i];
            if (blkIndex < 0 || !sourceNode.equals((Object)locations[i])) continue;
            ExtendedBlock extBlock = sBlockInfo.getBlock();
            long numBytes = StripedBlockUtil.getInternalBlockLength((long)extBlock.getNumBytes(), (ErasureCodingPolicy)ecPolicy, (int)blkIndex);
            Block blk = new Block(ExtendedBlock.getLocalBlock((ExtendedBlock)extBlock));
            long blkId = blk.getBlockId() + (long)blkIndex;
            blk.setBlockId(blkId);
            blk.setNumBytes(numBytes);
            BlockStorageMovementCommand.BlockMovingInfo blkMovingInfo = new BlockStorageMovementCommand.BlockMovingInfo(blk, sourceNode, targetNode, sourceStorageType, targetStorageType);
            blkMovingInfos.add(blkMovingInfo);
        }
    }

    private StorageTypeNodePair chooseTargetTypeInSameNode(LocatedBlock blockInfo, DatanodeInfo source, EnumMap<StorageType, List<DatanodeWithStorage.StorageDetails>> targetDns, List<StorageType> targetTypes) {
        for (StorageType t : targetTypes) {
            List<DatanodeWithStorage.StorageDetails> targetNodeStorages = targetDns.get(t);
            if (targetNodeStorages == null) continue;
            for (DatanodeWithStorage.StorageDetails targetNode : targetNodeStorages) {
                if (!targetNode.getDatanodeInfo().equals((Object)source)) continue;
                if (targetNode.hasSpaceForScheduling(blockInfo.getBlockSize())) {
                    targetNode.incScheduledSize(blockInfo.getBlockSize());
                    return new StorageTypeNodePair(t, source);
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Datanode:{} storage type:{} doesn't have sufficient space:{} to move the target block size:{}", new Object[]{source, t, targetNode, blockInfo.getBlockSize()});
            }
        }
        return null;
    }

    private StorageTypeNodePair chooseTarget(LocatedBlock block, DatanodeInfo source, List<StorageType> targetTypes, Matcher matcher, EnumMap<StorageType, List<DatanodeWithStorage.StorageDetails>> locsForExpectedStorageTypes, List<DatanodeInfo> excludeNodes) {
        for (StorageType t : targetTypes) {
            List<DatanodeWithStorage.StorageDetails> nodesWithStorages = locsForExpectedStorageTypes.get(t);
            if (nodesWithStorages == null || nodesWithStorages.isEmpty()) continue;
            Collections.shuffle(nodesWithStorages);
            for (DatanodeWithStorage.StorageDetails targetNode : nodesWithStorages) {
                DatanodeInfo target = targetNode.getDatanodeInfo();
                if (excludeNodes.contains(target) || !matcher.match(this.dnCacheMgr.getCluster(), (Node)source, (Node)target)) continue;
                if (targetNode.hasSpaceForScheduling(block.getBlockSize())) {
                    targetNode.incScheduledSize(block.getBlockSize());
                    return new StorageTypeNodePair(t, target);
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Datanode:{} storage type:{} doesn't have sufficient space:{} to move the target block size:{}", new Object[]{target, t, targetNode, block.getBlockSize()});
            }
        }
        return null;
    }

    private EnumMap<StorageType, List<DatanodeWithStorage.StorageDetails>> findTargetsForExpectedStorageTypes(List<StorageType> expected, DatanodeMap liveDns) {
        EnumMap<StorageType, List<DatanodeWithStorage.StorageDetails>> targetsMap = new EnumMap<StorageType, List<DatanodeWithStorage.StorageDetails>>(StorageType.class);
        for (StorageType storageType : expected) {
            List<DatanodeWithStorage> nodes = liveDns.getTarget(storageType);
            if (nodes == null) {
                return targetsMap;
            }
            List<DatanodeWithStorage.StorageDetails> listNodes = targetsMap.get(storageType);
            if (listNodes == null) {
                listNodes = new ArrayList<DatanodeWithStorage.StorageDetails>();
                targetsMap.put(storageType, listNodes);
            }
            for (DatanodeWithStorage n : nodes) {
                DatanodeWithStorage.StorageDetails node = StoragePolicySatisfier.getMaxRemaining(n, storageType);
                if (node == null) continue;
                listNodes.add(node);
            }
        }
        return targetsMap;
    }

    private static DatanodeWithStorage.StorageDetails getMaxRemaining(DatanodeWithStorage node, StorageType storageType) {
        long max = 0L;
        DatanodeWithStorage.StorageDetails nodeInfo = null;
        List storages = node.getNodesWithStorages(storageType);
        for (DatanodeWithStorage.StorageDetails n : storages) {
            if (n.availableSizeToMove() <= max) continue;
            max = n.availableSizeToMove();
            nodeInfo = n;
        }
        return nodeInfo;
    }

    private boolean checkSourceAndTargetTypeExists(DatanodeInfo dn, List<StorageType> existingStorageTypes, List<StorageType> expectedStorageTypes, DatanodeMap liveDns) {
        boolean isExpectedTypeAvailable = false;
        boolean isExistingTypeAvailable = false;
        for (DatanodeWithStorage liveDn : liveDns.getTargets()) {
            if (!dn.equals((Object)liveDn.datanode)) continue;
            for (StorageType eachType : liveDn.getStorageTypes()) {
                if (existingStorageTypes.contains(eachType)) {
                    isExistingTypeAvailable = true;
                }
                if (expectedStorageTypes.contains(eachType)) {
                    isExpectedTypeAvailable = true;
                }
                if (!isExistingTypeAvailable || !isExpectedTypeAvailable) continue;
                return true;
            }
        }
        return isExistingTypeAvailable && isExpectedTypeAvailable;
    }

    @Override
    public void notifyStorageMovementAttemptFinishedBlk(DatanodeInfo dnInfo, StorageType storageType, Block block) {
        this.storageMovementsMonitor.notifyReportedBlock(dnInfo, storageType, block);
    }

    @VisibleForTesting
    public BlockStorageMovementAttemptedItems getAttemptedItemsMonitor() {
        return this.storageMovementsMonitor;
    }

    public void clearQueues() {
        LOG.warn("Clearing all the queues from StoragePolicySatisfier. So, user requests on satisfying block storages would be discarded.");
        this.storageMovementNeeded.clearAll();
    }

    @Override
    public void addFileToProcess(ItemInfo trackInfo, boolean scanCompleted) {
        this.storageMovementNeeded.add(trackInfo, scanCompleted);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Added track info for inode {} to block storageMovementNeeded queue", (Object)trackInfo.getFile());
        }
    }

    @Override
    public void addAllFilesToProcess(long startPath, List<ItemInfo> itemInfoList, boolean scanCompleted) {
        this.getStorageMovementQueue().addAll(startPath, itemInfoList, scanCompleted);
    }

    @Override
    public int processingQueueSize() {
        return this.storageMovementNeeded.size();
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @VisibleForTesting
    public BlockStorageMovementNeeded getStorageMovementQueue() {
        return this.storageMovementNeeded;
    }

    @Override
    public void markScanCompletedForPath(long inodeId) {
        this.getStorageMovementQueue().markScanCompletedForDir(inodeId);
    }

    public void join() throws InterruptedException {
        this.storagePolicySatisfierThread.join();
    }

    private static boolean removeOverlapBetweenStorageTypes(List<StorageType> expected, List<StorageType> existing, boolean ignoreNonMovable) {
        Iterator<StorageType> i = existing.iterator();
        while (i.hasNext()) {
            StorageType t = i.next();
            if (!expected.remove(t)) continue;
            i.remove();
        }
        if (ignoreNonMovable) {
            StoragePolicySatisfier.removeNonMovable(existing);
            StoragePolicySatisfier.removeNonMovable(expected);
        }
        return expected.isEmpty() || existing.isEmpty();
    }

    private static void removeNonMovable(List<StorageType> types) {
        Iterator<StorageType> i = types.iterator();
        while (i.hasNext()) {
            StorageType t = i.next();
            if (t.isMovable()) continue;
            i.remove();
        }
    }

    private static int getSPSWorkMultiplier(Configuration conf) {
        int spsWorkMultiplier = conf.getInt("dfs.storage.policy.satisfier.work.multiplier.per.iteration", 1);
        Preconditions.checkArgument((spsWorkMultiplier > 0 ? 1 : 0) != 0, (Object)("dfs.storage.policy.satisfier.work.multiplier.per.iteration = '" + spsWorkMultiplier + "' is invalid. It should be a positive, non-zero integer value."));
        return spsWorkMultiplier;
    }

    static final class AttemptedItemInfo
    extends ItemInfo {
        private long lastAttemptedOrReportedTime;
        private final Set<Block> blocks;

        AttemptedItemInfo(long rootId, long trackId, long lastAttemptedOrReportedTime, Set<Block> blocks, int retryCount) {
            super(rootId, trackId, retryCount);
            this.lastAttemptedOrReportedTime = lastAttemptedOrReportedTime;
            this.blocks = blocks;
        }

        long getLastAttemptedOrReportedTime() {
            return this.lastAttemptedOrReportedTime;
        }

        void touchLastReportedTimeStamp() {
            this.lastAttemptedOrReportedTime = Time.monotonicNow();
        }

        Set<Block> getBlocks() {
            return this.blocks;
        }
    }

    public static final class DatanodeWithStorage {
        private final EnumMap<StorageType, List<StorageDetails>> storageMap = new EnumMap(StorageType.class);
        private final DatanodeInfo datanode;

        private DatanodeWithStorage(DatanodeInfo datanode) {
            this.datanode = datanode;
        }

        public DatanodeInfo getDatanodeInfo() {
            return this.datanode;
        }

        Set<StorageType> getStorageTypes() {
            return this.storageMap.keySet();
        }

        private void addStorageType(StorageType t, long maxSize2Move) {
            List<StorageDetails> nodesWithStorages = this.getNodesWithStorages(t);
            if (nodesWithStorages == null) {
                nodesWithStorages = new LinkedList<StorageDetails>();
                this.storageMap.put(t, nodesWithStorages);
            }
            nodesWithStorages.add(new StorageDetails(maxSize2Move));
        }

        private List<StorageDetails> getNodesWithStorages(StorageType type) {
            return this.storageMap.get(type);
        }

        public String toString() {
            return "DatanodeWithStorageInfo(\n  " + "Datanode: " + this.datanode + " StorageTypeNodeMap: " + this.storageMap + ")";
        }

        final class StorageDetails {
            private final long maxSize2Move;
            private long scheduledSize = 0L;

            private StorageDetails(long maxSize2Move) {
                this.maxSize2Move = maxSize2Move;
            }

            private DatanodeInfo getDatanodeInfo() {
                return DatanodeWithStorage.this.datanode;
            }

            private synchronized boolean hasSpaceForScheduling(long size) {
                return this.availableSizeToMove() > size;
            }

            private synchronized long availableSizeToMove() {
                return this.maxSize2Move - this.scheduledSize;
            }

            private synchronized void incScheduledSize(long size) {
                this.scheduledSize += size;
            }

            public String toString() {
                return "StorageDetails(\n  " + "maxSize2Move: " + this.maxSize2Move + " scheduledSize: " + this.scheduledSize + ")";
            }
        }
    }

    public static class DatanodeMap {
        private final EnumMap<StorageType, List<DatanodeWithStorage>> targetsMap = new EnumMap(StorageType.class);
        private List<DatanodeWithStorage> targets = new ArrayList<DatanodeWithStorage>();

        void addTarget(DatanodeInfo node, List<StorageType> storageTypes, List<Long> maxSize2Move) {
            DatanodeWithStorage nodeStorage = new DatanodeWithStorage(node);
            this.targets.add(nodeStorage);
            for (int i = 0; i < storageTypes.size(); ++i) {
                StorageType type = storageTypes.get(i);
                List<DatanodeWithStorage> nodeStorages = this.targetsMap.get(type);
                nodeStorage.addStorageType(type, maxSize2Move.get(i));
                if (nodeStorages == null) {
                    nodeStorages = new LinkedList<DatanodeWithStorage>();
                    this.targetsMap.put(type, nodeStorages);
                }
                nodeStorages.add(nodeStorage);
            }
        }

        List<DatanodeWithStorage> getTarget(StorageType storageType) {
            return this.targetsMap.get(storageType);
        }

        public List<DatanodeWithStorage> getTargets() {
            return this.targets;
        }

        void reset() {
            this.targetsMap.clear();
        }
    }

    static final class StorageTypeNodePair {
        private final StorageType storageType;
        private final DatanodeInfo dn;

        StorageTypeNodePair(StorageType storageType, DatanodeInfo dn) {
            this.storageType = storageType;
            this.dn = dn;
        }

        public DatanodeInfo getDatanodeInfo() {
            return this.dn;
        }

        public StorageType getStorageType() {
            return this.storageType;
        }

        public String toString() {
            return "StorageTypeNodePair(\n  " + "DatanodeInfo: " + this.dn + ", StorageType: " + this.storageType;
        }
    }

    private static class BlocksMovingAnalysis {
        private Status status = null;
        private Map<Block, Set<StorageTypeNodePair>> assignedBlocks = null;

        BlocksMovingAnalysis(Status status, Map<Block, Set<StorageTypeNodePair>> assignedBlocks) {
            this.status = status;
            this.assignedBlocks = assignedBlocks;
        }

        static enum Status {
            ANALYSIS_SKIPPED_FOR_RETRY,
            BLOCKS_TARGETS_PAIRED,
            NO_BLOCKS_TARGETS_PAIRED,
            BLOCKS_ALREADY_SATISFIED,
            BLOCKS_TARGET_PAIRING_SKIPPED,
            FEW_LOW_REDUNDANCY_BLOCKS,
            BLOCKS_FAILED_TO_MOVE;

        }
    }
}

