/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.common.FileRegion;
import org.apache.hadoop.hdfs.server.datanode.DirectoryScanner;
import org.apache.hadoop.hdfs.server.datanode.FileIoProvider;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.checker.Checkable;
import org.apache.hadoop.hdfs.server.datanode.checker.VolumeCheckResult;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.DataNodeVolumeMetrics;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeReference;

public interface FsVolumeSpi
extends Checkable<VolumeCheckContext, VolumeCheckResult> {
    public FsVolumeReference obtainReference() throws ClosedChannelException;

    public String getStorageID();

    public String[] getBlockPoolList();

    public long getAvailable() throws IOException;

    public URI getBaseURI();

    public DF getUsageStats(Configuration var1);

    public StorageLocation getStorageLocation();

    public StorageType getStorageType();

    public boolean isTransientStorage();

    public void reserveSpaceForReplica(long var1);

    public void releaseReservedSpace(long var1);

    public void releaseLockedMemory(long var1);

    public BlockIterator newBlockIterator(String var1, String var2);

    public BlockIterator loadBlockIterator(String var1, String var2) throws IOException;

    public FsDatasetSpi getDataset();

    public byte[] loadLastPartialChunkChecksum(File var1, File var2) throws IOException;

    public void compileReport(String var1, Collection<ScanInfo> var2, DirectoryScanner.ReportCompiler var3) throws InterruptedException, IOException;

    public FileIoProvider getFileIoProvider();

    public DataNodeVolumeMetrics getMetrics();

    public static class VolumeCheckContext {
    }

    public static class ScanInfo
    implements Comparable<ScanInfo> {
        private final long blockId;
        private final String blockSuffix;
        private final String metaSuffix;
        private final FsVolumeSpi volume;
        private final FileRegion fileRegion;
        private final long blockLength;
        private static final Pattern CONDENSED_PATH_REGEX = Pattern.compile("(?<!^)(\\\\|/){2,}");
        private static final String QUOTED_FILE_SEPARATOR = Matcher.quoteReplacement(File.separator);

        private static String getCondensedPath(String path) {
            return CONDENSED_PATH_REGEX.matcher(path).replaceAll(QUOTED_FILE_SEPARATOR);
        }

        private static String getSuffix(File f, String prefix) {
            String fullPath = ScanInfo.getCondensedPath(f.getAbsolutePath());
            if (fullPath.startsWith(prefix)) {
                return fullPath.substring(prefix.length());
            }
            throw new RuntimeException(prefix + " is not a prefix of " + fullPath);
        }

        public ScanInfo(long blockId, File blockFile, File metaFile, FsVolumeSpi vol) {
            this.blockId = blockId;
            String condensedVolPath = vol == null || vol.getBaseURI() == null ? null : ScanInfo.getCondensedPath(new File(vol.getBaseURI()).getAbsolutePath());
            this.blockSuffix = blockFile == null ? null : ScanInfo.getSuffix(blockFile, condensedVolPath);
            long l = this.blockLength = blockFile != null ? blockFile.length() : 0L;
            this.metaSuffix = metaFile == null ? null : (blockFile == null ? ScanInfo.getSuffix(metaFile, condensedVolPath) : ScanInfo.getSuffix(metaFile, condensedVolPath + this.blockSuffix));
            this.volume = vol;
            this.fileRegion = null;
        }

        public ScanInfo(long blockId, FsVolumeSpi vol, FileRegion fileRegion, long length) {
            this.blockId = blockId;
            this.blockLength = length;
            this.volume = vol;
            this.fileRegion = fileRegion;
            this.blockSuffix = null;
            this.metaSuffix = null;
        }

        public File getBlockFile() {
            return this.blockSuffix == null ? null : new File(new File(this.volume.getBaseURI()).getAbsolutePath(), this.blockSuffix);
        }

        public long getBlockLength() {
            return this.blockLength;
        }

        public File getMetaFile() {
            if (this.metaSuffix == null) {
                return null;
            }
            String fileSuffix = this.metaSuffix;
            if (this.blockSuffix != null) {
                fileSuffix = this.blockSuffix + this.metaSuffix;
            }
            return new File(new File(this.volume.getBaseURI()).getAbsolutePath(), fileSuffix);
        }

        public long getBlockId() {
            return this.blockId;
        }

        public FsVolumeSpi getVolume() {
            return this.volume;
        }

        @Override
        public int compareTo(ScanInfo b) {
            return Long.compare(this.blockId, b.blockId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ScanInfo)) {
                return false;
            }
            return this.blockId == ((ScanInfo)o).blockId;
        }

        public int hashCode() {
            return Long.hashCode(this.blockId);
        }

        public long getGenStamp() {
            return this.metaSuffix != null ? Block.getGenerationStamp((String)this.getMetaFile().getName()) : 0L;
        }

        public FileRegion getFileRegion() {
            return this.fileRegion;
        }
    }

    public static interface BlockIterator
    extends Closeable {
        public ExtendedBlock nextBlock() throws IOException;

        public boolean atEnd();

        public void rewind();

        public void save() throws IOException;

        public void setMaxStalenessMs(long var1);

        public long getIterStartMs();

        public long getLastSavedMs();

        public String getBlockPoolId();
    }
}

