/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.ImageVisitor;

abstract class TextWriterImageVisitor
extends ImageVisitor {
    private boolean printToScreen = false;
    private boolean okToWrite = false;
    private final OutputStreamWriter fw;

    public TextWriterImageVisitor(String filename) throws IOException {
        this(filename, false);
    }

    public TextWriterImageVisitor(String filename, boolean printToScreen) throws IOException {
        this.printToScreen = printToScreen;
        this.fw = new OutputStreamWriter(Files.newOutputStream(Paths.get(filename, new String[0]), new OpenOption[0]), Charsets.UTF_8);
        this.okToWrite = true;
    }

    @Override
    void finish() throws IOException {
        this.close();
    }

    @Override
    void finishAbnormally() throws IOException {
        this.close();
    }

    private void close() throws IOException {
        this.fw.close();
        this.okToWrite = false;
    }

    protected void write(String toWrite) throws IOException {
        if (!this.okToWrite) {
            throw new IOException("file not open for writing.");
        }
        if (this.printToScreen) {
            System.out.print(toWrite);
        }
        try {
            this.fw.write(toWrite);
        }
        catch (IOException e) {
            this.okToWrite = false;
            throw e;
        }
    }
}

