/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.FailoverController;
import org.apache.hadoop.ha.FailoverFailedException;
import org.apache.hadoop.ha.HAAdmin;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceProtocolHelper;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.tools.NNHAServiceTarget;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DFSHAAdmin
extends HAAdmin {
    private static final String FORCEFENCE = "forcefence";
    private static final Logger LOG = LoggerFactory.getLogger(DFSHAAdmin.class);
    private String nameserviceId;
    private static final Map<String, HAAdmin.UsageInfo> USAGE_DFS_ONLY = ImmutableMap.builder().put((Object)"-transitionToObserver", (Object)new HAAdmin.UsageInfo("<serviceId>", "Transitions the service into Observer state")).put((Object)"-failover", (Object)new HAAdmin.UsageInfo("[--forcefence] [--forceactive] <serviceId> <serviceId>", "Failover from the first service to the second.\nUnconditionally fence services if the --forcefence option is used.\nTry to failover to the target service even if it is not ready if the --forceactive option is used.")).build();
    private static final Map<String, HAAdmin.UsageInfo> USAGE_DFS_MERGED = ImmutableSortedMap.naturalOrder().putAll(USAGE).putAll(USAGE_DFS_ONLY).build();

    protected void setErrOut(PrintStream errOut) {
        this.errOut = errOut;
    }

    protected void setOut(PrintStream out) {
        this.out = out;
    }

    public void setConf(Configuration conf) {
        if (conf != null) {
            conf = DFSHAAdmin.addSecurityConfiguration(conf);
        }
        super.setConf(conf);
    }

    public static Configuration addSecurityConfiguration(Configuration conf) {
        conf = new HdfsConfiguration(conf);
        String nameNodePrincipal = conf.get("dfs.namenode.kerberos.principal", "");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using NN principal: " + nameNodePrincipal);
        }
        conf.set("hadoop.security.service.user.name.key", nameNodePrincipal);
        return conf;
    }

    protected HAServiceTarget resolveTarget(String nnId) {
        HdfsConfiguration conf = (HdfsConfiguration)this.getConf();
        return new NNHAServiceTarget((Configuration)conf, this.nameserviceId, nnId);
    }

    protected String getUsageString() {
        return "Usage: haadmin [-ns <nameserviceId>]";
    }

    private void addFailoverCliOpts(Options failoverOpts) {
        failoverOpts.addOption(FORCEFENCE, false, "force fencing");
        failoverOpts.addOption("forceactive", false, "force failover");
    }

    protected boolean checkParameterValidity(String[] argv) {
        return this.checkParameterValidity(argv, USAGE_DFS_MERGED);
    }

    protected int runCmd(String[] argv) throws Exception {
        CommandLine cmdLine;
        String cmd;
        if (argv.length < 1) {
            this.printUsage(this.errOut, USAGE_DFS_MERGED);
            return -1;
        }
        int i = 0;
        if ("-ns".equals(cmd = argv[i++])) {
            if (i == argv.length) {
                this.errOut.println("Missing nameservice ID");
                this.printUsage(this.errOut, USAGE_DFS_MERGED);
                return -1;
            }
            this.nameserviceId = argv[i++];
            if (i >= argv.length) {
                this.errOut.println("Missing command");
                this.printUsage(this.errOut, USAGE_DFS_MERGED);
                return -1;
            }
            argv = Arrays.copyOfRange(argv, i, argv.length);
            cmd = argv[0];
        }
        if (!this.checkParameterValidity(argv)) {
            return -1;
        }
        if ("-help".equals(cmd)) {
            return this.help(argv, USAGE_DFS_MERGED);
        }
        if (!USAGE_DFS_ONLY.containsKey(cmd)) {
            return super.runCmd(argv);
        }
        Options opts = new Options();
        if ("-failover".equals(cmd)) {
            this.addFailoverCliOpts(opts);
        }
        if ("-transitionToObserver".equals(cmd) || "-failover".equals(cmd)) {
            opts.addOption("forcemanual", false, "force manual control even if auto-failover is enabled");
        }
        if ((cmdLine = this.parseOpts(cmd, opts, argv, USAGE_DFS_MERGED)) == null) {
            return -1;
        }
        if (cmdLine.hasOption("forcemanual")) {
            if (!this.confirmForceManual()) {
                LOG.error("Aborted");
                return -1;
            }
            this.setRequestSource(HAServiceProtocol.RequestSource.REQUEST_BY_USER_FORCED);
        }
        if ("-transitionToObserver".equals(cmd)) {
            return this.transitionToObserver(cmdLine);
        }
        if ("-failover".equals(cmd)) {
            return this.failover(cmdLine);
        }
        throw new AssertionError((Object)("Should not get here, command: " + cmd));
    }

    protected Collection<String> getTargetIds(String namenodeToActivate) {
        return DFSUtilClient.getNameNodeIds((Configuration)this.getConf(), (String)(this.nameserviceId != null ? this.nameserviceId : DFSUtil.getNamenodeNameServiceId(this.getConf())));
    }

    private boolean checkSupportObserver(HAServiceTarget target) {
        if (target.supportObserver()) {
            return true;
        }
        this.errOut.println("The target " + target + " doesn't support Observer state.");
        return false;
    }

    private int transitionToObserver(CommandLine cmd) throws IOException, ServiceFailedException {
        String[] argv = cmd.getArgs();
        if (argv.length != 1) {
            this.errOut.println("transitionToObserver: incorrect number of arguments");
            this.printUsage(this.errOut, "-transitionToObserver", USAGE_DFS_MERGED);
            return -1;
        }
        HAServiceTarget target = this.resolveTarget(argv[0]);
        if (!this.checkSupportObserver(target)) {
            return -1;
        }
        if (!this.checkManualStateManagementOK(target)) {
            return -1;
        }
        HAServiceProtocol proto = target.getProxy(this.getConf(), 0);
        HAServiceProtocolHelper.transitionToObserver((HAServiceProtocol)proto, (HAServiceProtocol.StateChangeRequestInfo)this.createReqInfo());
        return 0;
    }

    private int failover(CommandLine cmd) throws IOException, ServiceFailedException {
        boolean forceFence = cmd.hasOption(FORCEFENCE);
        boolean forceActive = cmd.hasOption("forceactive");
        int numOpts = cmd.getOptions() == null ? 0 : cmd.getOptions().length;
        String[] args = cmd.getArgs();
        if (numOpts > 3 || args.length != 2) {
            this.errOut.println("failover: incorrect arguments");
            this.printUsage(this.errOut, "-failover", USAGE_DFS_MERGED);
            return -1;
        }
        HAServiceTarget fromNode = this.resolveTarget(args[0]);
        HAServiceTarget toNode = this.resolveTarget(args[1]);
        Preconditions.checkState((fromNode.isAutoFailoverEnabled() == toNode.isAutoFailoverEnabled() ? 1 : 0) != 0, (String)"Inconsistent auto-failover configs between %s and %s!", (Object)fromNode, (Object)toNode);
        if (fromNode.isAutoFailoverEnabled()) {
            if (forceFence || forceActive) {
                this.errOut.println("forcefence and forceactive flags not supported with auto-failover enabled.");
                return -1;
            }
            try {
                return this.gracefulFailoverThroughZKFCs(toNode);
            }
            catch (UnsupportedOperationException e) {
                this.errOut.println("Failover command is not supported with auto-failover enabled: " + e.getLocalizedMessage());
                return -1;
            }
        }
        FailoverController fc = new FailoverController(this.getConf(), this.getRequestSource());
        try {
            fc.failover(fromNode, toNode, forceFence, forceActive);
            this.out.println("Failover from " + args[0] + " to " + args[1] + " successful");
        }
        catch (FailoverFailedException ffe) {
            this.errOut.println("Failover failed: " + ffe.getLocalizedMessage());
            return -1;
        }
        return 0;
    }

    public static void main(String[] argv) throws Exception {
        int res = ToolRunner.run((Tool)new DFSHAAdmin(), (String[])argv);
        System.exit(res);
    }
}

