/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Producer;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.http.BasicAuthenticationHttpClientConfigurer;
import org.apache.camel.component.http.CompositeHttpConfigurer;
import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.component.http.HttpComponentVerifierExtension;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.http.ProxyHttpClientConfigurer;
import org.apache.camel.http.base.HttpHelper;
import org.apache.camel.http.common.HttpBinding;
import org.apache.camel.http.common.HttpCommonComponent;
import org.apache.camel.http.common.HttpRestHeaderFilterStrategy;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestProducerFactory;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.RestProducerFactoryHelper;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.PropertiesHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(label="verifiers", enums="parameters,connectivity")
@Component(value="http,https")
public class HttpComponent
extends HttpCommonComponent
implements RestProducerFactory,
SSLContextParametersAware {
    private static final Logger LOG = LoggerFactory.getLogger(HttpComponent.class);
    @Metadata(label="advanced", description="To use the custom HttpClientConfigurer to perform configuration of the HttpClient that will be used.")
    protected HttpClientConfigurer httpClientConfigurer;
    @Metadata(label="advanced", description="To use a custom and shared HttpClientConnectionManager to manage connections. If this has been configured then this is always used for all endpoints created by this component.")
    protected HttpClientConnectionManager clientConnectionManager;
    @Metadata(label="advanced", description="To use a custom org.apache.http.protocol.HttpContext when executing requests.")
    protected HttpContext httpContext;
    @Metadata(label="security", description="To configure security using SSLContextParameters. Important: Only one instance of org.apache.camel.support.jsse.SSLContextParameters is supported per HttpComponent. If you need to use 2 or more different instances, you need to define a new HttpComponent per instance you need.")
    protected SSLContextParameters sslContextParameters;
    @Metadata(label="security", description="To use a custom X509HostnameVerifier such as DefaultHostnameVerifier or NoopHostnameVerifier.")
    protected HostnameVerifier x509HostnameVerifier = new DefaultHostnameVerifier();
    @Metadata(label="producer", description="To use a custom org.apache.http.client.CookieStore. By default the org.apache.http.impl.client.BasicCookieStore is used which is an in-memory only cookie store. Notice if bridgeEndpoint=true then the cookie store is forced to be a noop cookie store as cookie shouldn't be stored as we are just bridging (eg acting as a proxy).")
    protected CookieStore cookieStore;
    @Metadata(label="timeout", defaultValue="-1", description="The timeout in milliseconds used when requesting a connection from the connection manager. A timeout value of zero is interpreted as an infinite timeout. A timeout value of zero is interpreted as an infinite timeout. A negative value is interpreted as undefined (system default).")
    protected int connectionRequestTimeout = -1;
    @Metadata(label="timeout", defaultValue="-1", description="Determines the timeout in milliseconds until a connection is established. A timeout value of zero is interpreted as an infinite timeout. A timeout value of zero is interpreted as an infinite timeout. A negative value is interpreted as undefined (system default).")
    protected int connectTimeout = -1;
    @Metadata(label="timeout", defaultValue="-1", description="Defines the socket timeout in milliseconds, which is the timeout for waiting for data  or, put differently, a maximum period inactivity between two consecutive data packets). A timeout value of zero is interpreted as an infinite timeout. A negative value is interpreted as undefined (system default).")
    protected int socketTimeout = -1;
    @Metadata(label="advanced", defaultValue="200", description="The maximum number of connections.")
    protected int maxTotalConnections = 200;
    @Metadata(label="advanced", defaultValue="20", description="The maximum number of connections per route.")
    protected int connectionsPerRoute = 20;
    @Metadata(label="advanced", description="The time for connection to live, the time unit is millisecond, the default value is always keep alive.")
    protected long connectionTimeToLive = -1L;
    @Metadata(label="security", defaultValue="false", description="Enable usage of global SSL context parameters.")
    private boolean useGlobalSslContextParameters;

    public HttpComponent() {
        this(HttpEndpoint.class);
    }

    public HttpComponent(Class<? extends HttpEndpoint> endpointClass) {
        this.registerExtension(HttpComponentVerifierExtension::new);
    }

    protected HttpClientConfigurer createHttpClientConfigurer(Map<String, Object> parameters, boolean secure) throws Exception {
        HttpClientConfigurer configurer = (HttpClientConfigurer)this.resolveAndRemoveReferenceParameter(parameters, "httpClientConfigurer", HttpClientConfigurer.class);
        if (configurer == null) {
            configurer = this.getHttpClientConfigurer();
        }
        configurer = this.configureBasicAuthentication(parameters, configurer);
        configurer = this.configureHttpProxy(parameters, configurer, secure);
        return configurer;
    }

    private HttpClientConfigurer configureBasicAuthentication(Map<String, Object> parameters, HttpClientConfigurer configurer) {
        String authUsername = (String)this.getParameter(parameters, "authUsername", String.class);
        String authPassword = (String)this.getParameter(parameters, "authPassword", String.class);
        if (authUsername != null && authPassword != null) {
            String authDomain = (String)this.getParameter(parameters, "authDomain", String.class);
            String authHost = (String)this.getParameter(parameters, "authHost", String.class);
            return CompositeHttpConfigurer.combineConfigurers(configurer, new BasicAuthenticationHttpClientConfigurer(authUsername, authPassword, authDomain, authHost));
        }
        if (this.httpConfiguration != null && "basic".equalsIgnoreCase(this.httpConfiguration.getAuthMethod())) {
            return CompositeHttpConfigurer.combineConfigurers(configurer, new BasicAuthenticationHttpClientConfigurer(this.httpConfiguration.getAuthUsername(), this.httpConfiguration.getAuthPassword(), this.httpConfiguration.getAuthDomain(), this.httpConfiguration.getAuthHost()));
        }
        return configurer;
    }

    private HttpClientConfigurer configureHttpProxy(Map<String, Object> parameters, HttpClientConfigurer configurer, boolean secure) throws Exception {
        String proxyAuthScheme = (String)this.getParameter(parameters, "proxyAuthScheme", String.class);
        if (proxyAuthScheme == null) {
            proxyAuthScheme = secure ? "https" : "http";
        }
        String proxyAuthHost = (String)this.getParameter(parameters, "proxyAuthHost", String.class);
        Integer proxyAuthPort = (Integer)this.getParameter(parameters, "proxyAuthPort", Integer.class);
        if (proxyAuthHost != null && proxyAuthPort != null) {
            String proxyAuthUsername = (String)this.getParameter(parameters, "proxyAuthUsername", String.class);
            String proxyAuthPassword = (String)this.getParameter(parameters, "proxyAuthPassword", String.class);
            String proxyAuthDomain = (String)this.getParameter(parameters, "proxyAuthDomain", String.class);
            String proxyAuthNtHost = (String)this.getParameter(parameters, "proxyAuthNtHost", String.class);
            if (proxyAuthUsername != null && proxyAuthPassword != null) {
                return CompositeHttpConfigurer.combineConfigurers(configurer, new ProxyHttpClientConfigurer(proxyAuthHost, proxyAuthPort, proxyAuthScheme, proxyAuthUsername, proxyAuthPassword, proxyAuthDomain, proxyAuthNtHost));
            }
            return CompositeHttpConfigurer.combineConfigurers(configurer, new ProxyHttpClientConfigurer(proxyAuthHost, proxyAuthPort, proxyAuthScheme));
        }
        return configurer;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String part;
        HashMap<String, Object> httpClientParameters = new HashMap<String, Object>(parameters);
        HashMap<String, Object> httpClientOptions = new HashMap<String, Object>();
        int val = (Integer)this.getAndRemoveParameter(parameters, "connectionRequestTimeout", Integer.TYPE, this.connectionRequestTimeout);
        if (val != -1) {
            httpClientOptions.put("connectionRequestTimeout", val);
        }
        if ((val = ((Integer)this.getAndRemoveParameter(parameters, "connectTimeout", Integer.TYPE, this.connectTimeout)).intValue()) != -1) {
            httpClientOptions.put("connectTimeout", val);
        }
        if ((val = ((Integer)this.getAndRemoveParameter(parameters, "socketTimeout", Integer.TYPE, this.socketTimeout)).intValue()) != -1) {
            httpClientOptions.put("socketTimeout", val);
        }
        HttpClientBuilder clientBuilder = this.createHttpClientBuilder(uri, parameters, httpClientOptions);
        HttpBinding httpBinding = (HttpBinding)this.resolveAndRemoveReferenceParameter(parameters, "httpBinding", HttpBinding.class);
        HttpContext httpContext = (HttpContext)this.resolveAndRemoveReferenceParameter(parameters, "httpContext", HttpContext.class);
        SSLContextParameters sslContextParameters = (SSLContextParameters)this.resolveAndRemoveReferenceParameter(parameters, "sslContextParameters", SSLContextParameters.class);
        if (sslContextParameters == null) {
            sslContextParameters = this.getSslContextParameters();
        }
        if (sslContextParameters == null) {
            sslContextParameters = this.retrieveGlobalSslContextParameters();
        }
        String httpMethodRestrict = (String)this.getAndRemoveParameter(parameters, "httpMethodRestrict", String.class);
        HeaderFilterStrategy headerFilterStrategy = (HeaderFilterStrategy)this.resolveAndRemoveReferenceParameter(parameters, "headerFilterStrategy", HeaderFilterStrategy.class);
        boolean secure = HttpHelper.isSecureConnection((String)uri) || sslContextParameters != null;
        String addressUri = (secure ? "https://" : "http://") + remaining;
        addressUri = UnsafeUriCharactersEncoder.encodeHttpURI((String)addressUri);
        URI uriHttpUriAddress = new URI(addressUri);
        int pos = uri.indexOf("//");
        if (pos != -1 && ((part = uri.substring(pos + 2)).startsWith("http:") || part.startsWith("https:"))) {
            throw new ResolveEndpointFailedException(uri, "The uri part is not configured correctly. You have duplicated the http(s) protocol.");
        }
        HttpClientConfigurer configurer = this.createHttpClientConfigurer(parameters, secure);
        URI endpointUri = URISupport.createRemainingURI((URI)uriHttpUriAddress, httpClientParameters);
        String scheme = StringHelper.before((String)uri, (String)"://");
        endpointUri = URISupport.createRemainingURI((URI)new URI(scheme, endpointUri.getUserInfo(), endpointUri.getHost(), endpointUri.getPort(), endpointUri.getPath(), endpointUri.getQuery(), endpointUri.getFragment()), httpClientParameters);
        String endpointUriString = endpointUri.toString();
        LOG.debug("Creating endpoint uri {}", (Object)endpointUriString);
        HttpClientConnectionManager localConnectionManager = this.createConnectionManager(parameters, sslContextParameters);
        HttpEndpoint endpoint = new HttpEndpoint(endpointUriString, this, clientBuilder, localConnectionManager, configurer);
        if (this.getHttpConfiguration() != null) {
            HashMap properties = new HashMap();
            BeanIntrospection beanIntrospection = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getBeanIntrospection();
            beanIntrospection.getProperties((Object)this.getHttpConfiguration(), properties, null);
            this.setProperties((Endpoint)endpoint, properties);
        }
        this.setProperties((Endpoint)endpoint, parameters);
        URI httpUri = URISupport.createRemainingURI((URI)new URI(uriHttpUriAddress.getScheme(), uriHttpUriAddress.getUserInfo(), uriHttpUriAddress.getHost(), uriHttpUriAddress.getPort(), uriHttpUriAddress.getPath(), uriHttpUriAddress.getQuery(), uriHttpUriAddress.getFragment()), parameters);
        endpoint.setHttpUri(httpUri);
        if (headerFilterStrategy != null) {
            endpoint.setHeaderFilterStrategy(headerFilterStrategy);
        } else {
            this.setEndpointHeaderFilterStrategy((Endpoint)endpoint);
        }
        endpoint.setHttpBinding(this.getHttpBinding());
        if (httpBinding != null) {
            endpoint.setHttpBinding(httpBinding);
        }
        if (httpMethodRestrict != null) {
            endpoint.setHttpMethodRestrict(httpMethodRestrict);
        }
        endpoint.setHttpContext(this.getHttpContext());
        if (httpContext != null) {
            endpoint.setHttpContext(httpContext);
        }
        if (endpoint.getCookieStore() == null) {
            endpoint.setCookieStore(this.getCookieStore());
        }
        endpoint.setHttpClientOptions(httpClientOptions);
        return endpoint;
    }

    protected HttpClientConnectionManager createConnectionManager(Map<String, Object> parameters, SSLContextParameters sslContextParameters) throws GeneralSecurityException, IOException {
        if (this.clientConnectionManager != null) {
            return this.clientConnectionManager;
        }
        HostnameVerifier resolvedHostnameVerifier = (HostnameVerifier)this.resolveAndRemoveReferenceParameter(parameters, "x509HostnameVerifier", HostnameVerifier.class);
        HostnameVerifier hostnameVerifier = Optional.ofNullable(resolvedHostnameVerifier).orElse(this.x509HostnameVerifier);
        int maxTotalConnections = (Integer)this.getAndRemoveParameter(parameters, "maxTotalConnections", Integer.TYPE, 0);
        int connectionsPerRoute = (Integer)this.getAndRemoveParameter(parameters, "connectionsPerRoute", Integer.TYPE, 0);
        Registry<ConnectionSocketFactory> connectionRegistry = this.createConnectionRegistry(hostnameVerifier, sslContextParameters);
        return this.createConnectionManager(connectionRegistry, maxTotalConnections, connectionsPerRoute);
    }

    protected HttpClientBuilder createHttpClientBuilder(String uri, Map<String, Object> parameters, Map<String, Object> httpClientOptions) throws Exception {
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        httpClientOptions.putAll(PropertiesHelper.extractProperties(parameters, (String)"httpClient."));
        PropertyBindingSupport.bindProperties((CamelContext)this.getCamelContext(), (Object)clientBuilder, httpClientOptions);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        PropertyBindingSupport.bindProperties((CamelContext)this.getCamelContext(), (Object)requestConfigBuilder, httpClientOptions);
        clientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
        this.validateParameters(uri, httpClientOptions, null);
        return clientBuilder;
    }

    protected Registry<ConnectionSocketFactory> createConnectionRegistry(HostnameVerifier x509HostnameVerifier, SSLContextParameters sslContextParams) throws GeneralSecurityException, IOException {
        RegistryBuilder builder = RegistryBuilder.create();
        builder.register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
        if (sslContextParams != null) {
            builder.register("https", (Object)new SSLConnectionSocketFactory(sslContextParams.createSSLContext(this.getCamelContext()), x509HostnameVerifier));
        } else {
            builder.register("https", (Object)new SSLConnectionSocketFactory(SSLContexts.createDefault(), x509HostnameVerifier));
        }
        return builder.build();
    }

    protected HttpClientConnectionManager createConnectionManager(Registry<ConnectionSocketFactory> registry) {
        return this.createConnectionManager(registry, 0, 0);
    }

    protected HttpClientConnectionManager createConnectionManager(Registry<ConnectionSocketFactory> registry, int maxTotalConnections, int connectionsPerRoute) {
        int localConnectionsPerRoute;
        PoolingHttpClientConnectionManager answer = new PoolingHttpClientConnectionManager(registry, null, null, null, this.getConnectionTimeToLive(), TimeUnit.MILLISECONDS);
        int localMaxTotalConnections = maxTotalConnections;
        if (localMaxTotalConnections == 0) {
            localMaxTotalConnections = this.getMaxTotalConnections();
        }
        if (localMaxTotalConnections > 0) {
            answer.setMaxTotal(localMaxTotalConnections);
        }
        if ((localConnectionsPerRoute = connectionsPerRoute) == 0) {
            localConnectionsPerRoute = this.getConnectionsPerRoute();
        }
        if (localConnectionsPerRoute > 0) {
            answer.setDefaultMaxPerRoute(localConnectionsPerRoute);
        }
        LOG.info("Created ClientConnectionManager {}", (Object)answer);
        return answer;
    }

    protected boolean useIntrospectionOnEndpoint() {
        return false;
    }

    public Producer createProducer(CamelContext camelContext, String host, String verb, String basePath, String uriTemplate, String queryParameters, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        String query;
        RestConfiguration config;
        basePath = FileUtil.stripLeadingSeparator((String)basePath);
        uriTemplate = FileUtil.stripLeadingSeparator((String)uriTemplate);
        String url = host;
        if (!ObjectHelper.isEmpty((Object)basePath)) {
            url = url + "/" + basePath;
        }
        if (!ObjectHelper.isEmpty((Object)uriTemplate)) {
            url = url + "/" + uriTemplate;
        }
        if ((config = configuration) == null) {
            config = camelContext.getRestConfiguration("http", false);
            if (config == null) {
                camelContext.getRestConfiguration();
            }
            if (config == null) {
                config = camelContext.getRestConfiguration("http", true);
            }
        }
        HashMap map = new HashMap();
        if ((config.getProducerComponent() == null || config.getProducerComponent().equals("http")) && config.getEndpointProperties() != null && !config.getEndpointProperties().isEmpty()) {
            map.putAll(config.getEndpointProperties());
        }
        if (!(query = URISupport.createQueryString(map)).isEmpty()) {
            url = url + "?" + query;
        }
        parameters = parameters != null ? new HashMap<String, Object>(parameters) : new HashMap();
        RestProducerFactoryHelper.setupComponentFor((String)url, (CamelContext)camelContext, (Map)((Map)parameters.remove("component")));
        HttpEndpoint endpoint = (HttpEndpoint)camelContext.getEndpoint(url, HttpEndpoint.class);
        this.setProperties((Endpoint)endpoint, parameters);
        String path = uriTemplate != null ? uriTemplate : basePath;
        endpoint.setHeaderFilterStrategy((HeaderFilterStrategy)new HttpRestHeaderFilterStrategy(path, queryParameters));
        ServiceHelper.startService((Object)((Object)endpoint));
        return endpoint.createProducer();
    }

    public HttpClientConfigurer getHttpClientConfigurer() {
        return this.httpClientConfigurer;
    }

    public void setHttpClientConfigurer(HttpClientConfigurer httpClientConfigurer) {
        this.httpClientConfigurer = httpClientConfigurer;
    }

    public HttpClientConnectionManager getClientConnectionManager() {
        return this.clientConnectionManager;
    }

    public void setClientConnectionManager(HttpClientConnectionManager clientConnectionManager) {
        this.clientConnectionManager = clientConnectionManager;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    public HostnameVerifier getX509HostnameVerifier() {
        return this.x509HostnameVerifier;
    }

    public void setX509HostnameVerifier(HostnameVerifier x509HostnameVerifier) {
        this.x509HostnameVerifier = x509HostnameVerifier;
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public void setMaxTotalConnections(int maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    public int getConnectionsPerRoute() {
        return this.connectionsPerRoute;
    }

    public void setConnectionsPerRoute(int connectionsPerRoute) {
        this.connectionsPerRoute = connectionsPerRoute;
    }

    public long getConnectionTimeToLive() {
        return this.connectionTimeToLive;
    }

    public void setConnectionTimeToLive(long connectionTimeToLive) {
        this.connectionTimeToLive = connectionTimeToLive;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public void setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void doStart() throws Exception {
        super.doStart();
    }

    public void doStop() throws Exception {
        if (this.clientConnectionManager != null) {
            LOG.info("Shutting down ClientConnectionManager: {}", (Object)this.clientConnectionManager);
            this.clientConnectionManager.shutdown();
            this.clientConnectionManager = null;
        }
        super.doStop();
    }

    public ComponentVerifierExtension getVerifier() {
        return (scope, parameters) -> ((ComponentVerifierExtension)this.getExtension(ComponentVerifierExtension.class).orElseThrow(UnsupportedOperationException::new)).verify(scope, parameters);
    }
}

