/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.strategy.GenericFileRenamer;
import org.apache.camel.util.ObjectHelper;

public class GenericFileExpressionRenamer<T>
implements GenericFileRenamer<T> {
    private Expression expression;

    public GenericFileExpressionRenamer() {
    }

    public GenericFileExpressionRenamer(Expression expression) {
        this.expression = expression;
    }

    @Override
    public GenericFile<T> renameFile(GenericFileOperations<T> operations, Exchange exchange, GenericFile<T> file) {
        ObjectHelper.notNull((Object)this.expression, (String)"expression");
        String newName = (String)this.expression.evaluate(exchange, String.class);
        GenericFile<T> result = operations.newGenericFile();
        file.copyFrom(file, result);
        result.changeFileName(newName);
        return result;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }
}

