/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.NamedNode;
import org.apache.camel.Predicate;
import org.apache.camel.api.management.mbean.BacklogTracerEventMessage;
import org.apache.camel.processor.interceptor.DefaultBacklogTracerEventMessage;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.StringHelper;

public final class BacklogTracer
extends ServiceSupport {
    public static final int MAX_BACKLOG_SIZE = 10000;
    private final CamelContext camelContext;
    private boolean enabled;
    private final AtomicLong traceCounter = new AtomicLong();
    private final Queue<BacklogTracerEventMessage> queue = new LinkedBlockingQueue<BacklogTracerEventMessage>(10000);
    private int backlogSize = 1000;
    private boolean removeOnDump = true;
    private int bodyMaxChars = 131072;
    private boolean bodyIncludeStreams;
    private boolean bodyIncludeFiles = true;
    private String tracePattern;
    private String[] patterns;
    private String traceFilter;
    private Predicate predicate;

    private BacklogTracer(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public static BacklogTracer createTracer(CamelContext context) {
        return new BacklogTracer(context);
    }

    public boolean shouldTrace(NamedNode definition, Exchange exchange) {
        if (!this.enabled) {
            return false;
        }
        boolean pattern = true;
        boolean filter = true;
        if (this.patterns != null) {
            pattern = this.shouldTracePattern(definition);
        }
        if (this.predicate != null) {
            filter = this.shouldTraceFilter(exchange);
        }
        return pattern && filter;
    }

    private boolean shouldTracePattern(NamedNode definition) {
        for (String pattern : this.patterns) {
            String id = definition.getId();
            if (PatternHelper.matchPattern((String)id, (String)pattern)) {
                return true;
            }
            String routeId = CamelContextHelper.getRouteId((NamedNode)definition);
            if (routeId == null || Objects.equals(routeId, id) || !PatternHelper.matchPattern((String)routeId, (String)pattern)) continue;
            return true;
        }
        return false;
    }

    public void traceEvent(DefaultBacklogTracerEventMessage event) {
        if (!this.enabled) {
            return;
        }
        int drain = this.queue.size() - this.backlogSize + 1;
        if (drain > 0) {
            for (int i = 0; i < drain; ++i) {
                this.queue.poll();
            }
        }
        this.queue.add(event);
    }

    private boolean shouldTraceFilter(Exchange exchange) {
        return this.predicate.matches(exchange);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getBacklogSize() {
        return this.backlogSize;
    }

    public void setBacklogSize(int backlogSize) {
        if (backlogSize <= 0) {
            throw new IllegalArgumentException("The backlog size must be a positive number, was: " + backlogSize);
        }
        if (backlogSize > 10000) {
            throw new IllegalArgumentException("The backlog size cannot be greater than the max size of 10000, was: " + backlogSize);
        }
        this.backlogSize = backlogSize;
    }

    public boolean isRemoveOnDump() {
        return this.removeOnDump;
    }

    public void setRemoveOnDump(boolean removeOnDump) {
        this.removeOnDump = removeOnDump;
    }

    public int getBodyMaxChars() {
        return this.bodyMaxChars;
    }

    public void setBodyMaxChars(int bodyMaxChars) {
        this.bodyMaxChars = bodyMaxChars;
    }

    public boolean isBodyIncludeStreams() {
        return this.bodyIncludeStreams;
    }

    public void setBodyIncludeStreams(boolean bodyIncludeStreams) {
        this.bodyIncludeStreams = bodyIncludeStreams;
    }

    public boolean isBodyIncludeFiles() {
        return this.bodyIncludeFiles;
    }

    public void setBodyIncludeFiles(boolean bodyIncludeFiles) {
        this.bodyIncludeFiles = bodyIncludeFiles;
    }

    public String getTracePattern() {
        return this.tracePattern;
    }

    public void setTracePattern(String tracePattern) {
        this.tracePattern = tracePattern;
        this.patterns = tracePattern != null ? tracePattern.split(",") : null;
    }

    public String getTraceFilter() {
        return this.traceFilter;
    }

    public void setTraceFilter(String filter) {
        this.traceFilter = filter;
        if (filter != null) {
            String name = StringHelper.before((String)filter, (String)":");
            if (name == null) {
                name = "simple";
            }
            this.predicate = this.camelContext.resolveLanguage(name).createPredicate(filter);
        }
    }

    public long getTraceCounter() {
        return this.traceCounter.get();
    }

    public void resetTraceCounter() {
        this.traceCounter.set(0L);
    }

    public List<BacklogTracerEventMessage> dumpTracedMessages(String nodeId) {
        ArrayList<BacklogTracerEventMessage> answer = new ArrayList<BacklogTracerEventMessage>();
        if (nodeId != null) {
            for (BacklogTracerEventMessage message : this.queue) {
                if (!nodeId.equals(message.getToNode()) && !nodeId.equals(message.getRouteId())) continue;
                answer.add(message);
            }
        }
        if (this.removeOnDump) {
            this.queue.removeAll(answer);
        }
        return answer;
    }

    public String dumpTracedMessagesAsXml(String nodeId) {
        List<BacklogTracerEventMessage> events = this.dumpTracedMessages(nodeId);
        StringBuilder sb = new StringBuilder();
        sb.append("<").append("backlogTracerEventMessage").append("s>");
        for (BacklogTracerEventMessage event : events) {
            sb.append("\n").append(event.toXml(2));
        }
        sb.append("\n</").append("backlogTracerEventMessage").append("s>");
        return sb.toString();
    }

    public List<BacklogTracerEventMessage> dumpAllTracedMessages() {
        ArrayList<BacklogTracerEventMessage> answer = new ArrayList<BacklogTracerEventMessage>();
        answer.addAll(this.queue);
        if (this.isRemoveOnDump()) {
            this.queue.clear();
        }
        return answer;
    }

    public String dumpAllTracedMessagesAsXml() {
        List<BacklogTracerEventMessage> events = this.dumpAllTracedMessages();
        StringBuilder sb = new StringBuilder();
        sb.append("<").append("backlogTracerEventMessage").append("s>");
        for (BacklogTracerEventMessage event : events) {
            sb.append("\n").append(event.toXml(2));
        }
        sb.append("\n</").append("backlogTracerEventMessage").append("s>");
        return sb.toString();
    }

    public void clear() {
        this.queue.clear();
    }

    public long incrementTraceCounter() {
        return this.traceCounter.incrementAndGet();
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
        this.queue.clear();
    }
}

