/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.serde;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import io.apicurio.registry.client.RegistryService;
import io.apicurio.registry.common.proto.Serde;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.registry.utils.serde.AbstractKafkaDeserializer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.ws.rs.core.Response;
import org.apache.kafka.common.header.Headers;

public class ProtobufKafkaDeserializer
extends AbstractKafkaDeserializer<byte[], DynamicMessage, ProtobufKafkaDeserializer> {
    public ProtobufKafkaDeserializer() {
    }

    public ProtobufKafkaDeserializer(RegistryService client) {
        super(client);
    }

    @Override
    protected byte[] toSchema(Response response) {
        Object responseEntity = response.getEntity();
        if (responseEntity instanceof InputStream) {
            return IoUtil.toBytes((InputStream)((InputStream)responseEntity));
        }
        return (byte[])response.readEntity(byte[].class);
    }

    @Override
    protected DynamicMessage readData(byte[] schema, ByteBuffer buffer, int start, int length) {
        try {
            Serde.Schema s = Serde.Schema.parseFrom((byte[])schema);
            Descriptors.FileDescriptor fileDescriptor = this.toFileDescriptor(s);
            byte[] bytes = new byte[length];
            System.arraycopy(buffer.array(), start, bytes, 0, length);
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            Serde.Ref ref = Serde.Ref.parseDelimitedFrom((InputStream)is);
            Descriptors.Descriptor descriptor = fileDescriptor.findMessageTypeByName(ref.getName());
            return DynamicMessage.parseFrom((Descriptors.Descriptor)descriptor, (InputStream)is);
        }
        catch (Descriptors.DescriptorValidationException | IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected DynamicMessage readData(Headers headers, byte[] schema, ByteBuffer buffer, int start, int length) {
        return this.readData(schema, buffer, start, length);
    }

    private Descriptors.FileDescriptor toFileDescriptor(Serde.Schema s) throws Descriptors.DescriptorValidationException {
        ArrayList<Descriptors.FileDescriptor> imports = new ArrayList<Descriptors.FileDescriptor>();
        for (Serde.Schema i : s.getImportList()) {
            imports.add(this.toFileDescriptor(i));
        }
        return Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)s.getFile(), (Descriptors.FileDescriptor[])imports.toArray(new Descriptors.FileDescriptor[0]));
    }
}

