/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.http.common;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.http.common.HttpCommonEndpoint;
import org.apache.camel.http.common.HttpConverter;
import org.apache.camel.http.common.HttpMethods;
import org.apache.camel.support.CamelObjectInputStream;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;

public final class HttpHelper {
    private HttpHelper() {
    }

    public static boolean isSecureConnection(String uri) {
        return org.apache.camel.http.base.HttpHelper.isSecureConnection((String)uri);
    }

    public static int[] parserHttpVersion(String s) throws ProtocolException {
        return org.apache.camel.http.base.HttpHelper.parserHttpVersion((String)s);
    }

    public static void setCharsetFromContentType(String contentType, Exchange exchange) {
        org.apache.camel.http.base.HttpHelper.setCharsetFromContentType((String)contentType, (Exchange)exchange);
    }

    public static String getCharsetFromContentType(String contentType) {
        return org.apache.camel.http.base.HttpHelper.getCharsetFromContentType((String)contentType);
    }

    public static void writeObjectToServletResponse(ServletResponse response, Object target) throws IOException {
        response.setContentType("application/x-java-serialized-object");
        HttpHelper.writeObjectToStream((OutputStream)response.getOutputStream(), target);
    }

    public static void writeObjectToStream(OutputStream stream, Object target) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(stream);
        oos.writeObject(target);
        oos.flush();
        IOHelper.close((Closeable)oos);
    }

    @Deprecated
    public static Object deserializeJavaObjectFromStream(InputStream is) throws ClassNotFoundException, IOException {
        return HttpHelper.deserializeJavaObjectFromStream(is, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserializeJavaObjectFromStream(InputStream is, CamelContext context) throws ClassNotFoundException, IOException {
        if (is == null) {
            return null;
        }
        Object answer = null;
        CamelObjectInputStream ois = new CamelObjectInputStream(is, context);
        try {
            answer = ois.readObject();
        }
        finally {
            IOHelper.close((Closeable)ois);
        }
        return answer;
    }

    public static Object readRequestBodyFromServletRequest(HttpServletRequest request, Exchange exchange) throws IOException {
        InputStream is = HttpConverter.toInputStream(request, exchange);
        return HttpHelper.readResponseBodyFromInputStream(is, exchange);
    }

    public static Object readRequestBodyFromInputStream(InputStream is, Exchange exchange) throws IOException {
        boolean disableStreamCaching;
        if (is == null) {
            return null;
        }
        boolean bl = disableStreamCaching = exchange.getContext().isStreamCaching() == false;
        if (((Boolean)exchange.getProperty("CamelDisableHttpStreamCache", (Object)disableStreamCaching, Boolean.class)).booleanValue()) {
            return is;
        }
        CachedOutputStream cos = new CachedOutputStream(exchange);
        IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)cos);
        return cos.newStreamCache();
    }

    public static Object readResponseBodyFromInputStream(InputStream is, Exchange exchange) throws IOException {
        if (is == null) {
            return null;
        }
        if (((Boolean)exchange.getProperty("CamelDisableHttpStreamCache", (Object)Boolean.FALSE, Boolean.class)).booleanValue()) {
            return is;
        }
        CachedOutputStream cos = new CachedOutputStream(exchange);
        IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)cos);
        return cos.newStreamCache();
    }

    public static String createURL(Exchange exchange, HttpCommonEndpoint endpoint) {
        String uri = (String)exchange.getIn().removeHeader("CamelRestHttpUri");
        if (uri == null && !endpoint.isBridgeEndpoint()) {
            uri = (String)exchange.getIn().getHeader("CamelHttpUri", String.class);
        }
        if (uri == null) {
            uri = endpoint.getHttpUri().toASCIIString();
        }
        try {
            uri = exchange.getContext().resolvePropertyPlaceholders(uri);
        }
        catch (Exception e) {
            throw new RuntimeExchangeException("Cannot resolve property placeholders with uri: " + uri, exchange, (Throwable)e);
        }
        String path = (String)exchange.getIn().getHeader("CamelHttpPath", String.class);
        if (path != null) {
            if (path.length() > 1 && path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.length() > 0) {
                int idx = uri.indexOf(63);
                if (idx == -1) {
                    uri = uri.endsWith("/") || path.startsWith("/") ? uri : uri + "/";
                    uri = uri.concat(path);
                } else {
                    String base = uri.substring(0, idx);
                    base = base.endsWith("/") ? base : base + "/";
                    base = base.concat(path);
                    uri = base.concat(uri.substring(idx));
                }
            }
        }
        uri = UnsafeUriCharactersEncoder.encodeHttpURI((String)uri);
        return uri;
    }

    public static URI createURI(Exchange exchange, String url, HttpCommonEndpoint endpoint) throws URISyntaxException {
        URI uri = new URI(url);
        String queryString = (String)exchange.getIn().removeHeader("CamelRestHttpQuery");
        if (queryString == null) {
            queryString = (String)exchange.getIn().getHeader("CamelHttpRawQuery", String.class);
        }
        if (queryString == null) {
            queryString = (String)exchange.getIn().getHeader("CamelHttpQuery", String.class);
        }
        if (queryString == null) {
            queryString = endpoint.getHttpUri().getRawQuery();
        }
        if (queryString == null) {
            queryString = uri.getRawQuery();
        }
        if (queryString != null) {
            queryString = UnsafeUriCharactersEncoder.encodeHttpURI((String)queryString);
            uri = URISupport.createURIWithQuery((URI)uri, (String)queryString);
        }
        return uri;
    }

    public static void appendHeader(Map<String, Object> headers, String key, Object value) {
        org.apache.camel.http.base.HttpHelper.appendHeader(headers, (String)key, (Object)value);
    }

    public static Object extractHttpParameterValue(String value) {
        return org.apache.camel.http.base.HttpHelper.extractHttpParameterValue((String)value);
    }

    public static HttpMethods createMethod(Exchange exchange, HttpCommonEndpoint endpoint, boolean hasPayload) throws URISyntaxException {
        HttpMethods m;
        String queryString = (String)exchange.getIn().getHeader("CamelHttpQuery", String.class);
        String uriString = (String)exchange.getIn().getHeader("CamelHttpUri", String.class);
        try {
            uriString = exchange.getContext().resolvePropertyPlaceholders(uriString);
        }
        catch (Exception e) {
            throw new RuntimeExchangeException("Cannot resolve property placeholders with uri: " + uriString, exchange, (Throwable)e);
        }
        if (uriString != null) {
            uriString = UnsafeUriCharactersEncoder.encodeHttpURI((String)uriString);
            URI uri = new URI(uriString);
            queryString = uri.getQuery();
        }
        if (queryString == null) {
            queryString = endpoint.getHttpUri().getRawQuery();
        }
        HttpMethods answer = endpoint.getHttpMethod() != null ? endpoint.getHttpMethod() : ((m = (HttpMethods)((Object)exchange.getIn().getHeader("CamelHttpMethod", HttpMethods.class))) != null ? m : (queryString != null ? HttpMethods.GET : (hasPayload ? HttpMethods.POST : HttpMethods.GET)));
        return answer;
    }

    public static boolean isStatusCodeOk(int statusCode, String okStatusCodeRange) {
        return org.apache.camel.http.base.HttpHelper.isStatusCodeOk((int)statusCode, (String)okStatusCodeRange);
    }
}

